/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.listener.ITableViewListener;

public abstract class AbstractItemClickListener
implements RecyclerView.OnItemTouchListener {
    private ITableViewListener m_jListener;
    protected GestureDetector m_jGestureDetector;
    protected CellRecyclerView m_jRecyclerView;
    protected SelectionHandler m_iSelectionHandler;
    protected ITableView m_iTableView;

    public AbstractItemClickListener(CellRecyclerView p_jRecyclerView, ITableView p_iTableView) {
        this.m_jRecyclerView = p_jRecyclerView;
        this.m_iTableView = p_iTableView;
        this.m_iSelectionHandler = p_iTableView.getSelectionHandler();
        this.m_jGestureDetector = new GestureDetector(this.m_jRecyclerView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }

            public void onLongPress(MotionEvent e) {
                AbstractItemClickListener.this.longPressAction(e);
            }
        });
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
        return this.clickAction(view, e);
    }

    public void onTouchEvent(RecyclerView view, MotionEvent motionEvent) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected ITableViewListener getTableViewListener() {
        if (this.m_jListener == null) {
            this.m_jListener = this.m_iTableView.getTableViewListener();
        }
        return this.m_jListener;
    }

    protected abstract boolean clickAction(RecyclerView var1, MotionEvent var2);

    protected abstract void longPressAction(MotionEvent var1);
}

