/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.util.TableViewUtils;

public class ColumnLayoutManager
extends LinearLayoutManager {
    private static final String LOG_TAG = ColumnLayoutManager.class.getSimpleName();
    private SparseArray<SparseArray<Integer>> m_aCachedWidthList;
    private ITableView m_iTableView;
    private CellRecyclerView m_iCellRowRecyclerView;
    private CellRecyclerView m_iColumnHeaderRecyclerView;
    private ColumnHeaderLayoutManager m_jColumnHeaderLayoutManager;
    private CellLayoutManager m_iCellLayoutManager;
    private int m_nLastDx = 0;
    private boolean m_bNeedFit = false;

    public ColumnLayoutManager(Context context, ITableView p_iTableView, CellRecyclerView m_iCellRowRecyclerView) {
        super(context);
        this.m_iTableView = p_iTableView;
        this.m_iColumnHeaderRecyclerView = this.m_iTableView.getColumnHeaderRecyclerView();
        this.m_jColumnHeaderLayoutManager = this.m_iTableView.getColumnHeaderLayoutManager();
        this.m_iCellRowRecyclerView = m_iCellRowRecyclerView;
        this.m_iCellLayoutManager = this.m_iTableView.getCellLayoutManager();
        this.m_aCachedWidthList = new SparseArray();
        this.setOrientation(0);
    }

    public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.m_iTableView.hasFixedWidth()) {
            return;
        }
        this.measureChild(child, widthUsed, heightUsed);
    }

    public void measureChild(View child, int widthUsed, int heightUsed) {
        if (this.m_iTableView.hasFixedWidth()) {
            super.measureChild(child, widthUsed, heightUsed);
            return;
        }
        int nPosition = this.getPosition(child);
        int nCacheWidth = this.getCacheWidth(nPosition);
        int nColumnCacheWidth = this.m_jColumnHeaderLayoutManager.getCacheWidth(nPosition);
        if (nCacheWidth != -1 && nCacheWidth == nColumnCacheWidth) {
            TableViewUtils.setWidth(child, nCacheWidth);
        } else {
            this.fitWidthSize(child, nPosition, nCacheWidth, nColumnCacheWidth);
        }
        if (this.shouldFitColumns(nPosition)) {
            if (this.m_nLastDx < 0) {
                Log.e((String)LOG_TAG, (String)("x: " + nPosition + " y: " + this.getRowPosition() + " fitWidthSize left side"));
                this.m_iCellLayoutManager.fitWidthSize(nPosition, true);
            } else {
                this.m_iCellLayoutManager.fitWidthSize(nPosition, false);
                Log.e((String)LOG_TAG, (String)("x: " + nPosition + " y: " + this.getRowPosition() + " fitWidthSize right side"));
            }
            this.m_bNeedFit = false;
        }
    }

    private boolean shouldFitColumns(int p_nXPosition) {
        int nYPosition;
        return this.m_bNeedFit && this.m_iCellLayoutManager.shouldFitColumns(nYPosition = this.m_iCellLayoutManager.getPosition((View)this.m_iCellRowRecyclerView)) && (this.m_nLastDx > 0 ? p_nXPosition == this.findLastVisibleItemPosition() : this.m_nLastDx < 0 && p_nXPosition == this.findFirstVisibleItemPosition());
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.m_iColumnHeaderRecyclerView.getScrollState() == 0 && this.m_iCellRowRecyclerView.isScrollOthers()) {
            this.m_iColumnHeaderRecyclerView.scrollBy(dx, 0);
        }
        this.m_nLastDx = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    private void fitWidthSize(View child, int p_nPosition, int p_nCellCacheWidth, int p_nColumnCacheWidth) {
        View columnHeaderChild;
        int nCellWidth = p_nCellCacheWidth;
        if (nCellWidth == -1) {
            nCellWidth = child.getMeasuredWidth();
        }
        if (p_nPosition > -1 && (columnHeaderChild = this.m_jColumnHeaderLayoutManager.findViewByPosition(p_nPosition)) != null) {
            int nColumnHeaderWidth = p_nColumnCacheWidth;
            if (nColumnHeaderWidth == -1) {
                nColumnHeaderWidth = columnHeaderChild.getMeasuredWidth();
            }
            if (nCellWidth != 0) {
                if (nColumnHeaderWidth > nCellWidth) {
                    nCellWidth = nColumnHeaderWidth;
                } else if (nCellWidth > nColumnHeaderWidth) {
                    nColumnHeaderWidth = nCellWidth;
                }
                if (nColumnHeaderWidth != columnHeaderChild.getWidth()) {
                    TableViewUtils.setWidth(columnHeaderChild, nColumnHeaderWidth);
                    this.m_bNeedFit = true;
                }
                this.m_jColumnHeaderLayoutManager.setCacheWidth(p_nPosition, nColumnHeaderWidth);
            }
        }
        TableViewUtils.setWidth(child, nCellWidth);
        this.setCacheWidth(p_nPosition, nCellWidth);
    }

    private int getRowPosition() {
        return this.m_iCellLayoutManager.getPosition((View)this.m_iCellRowRecyclerView);
    }

    public void setCacheWidth(int p_nPosition, int p_nWidth) {
        int nYPosition = this.getRowPosition();
        SparseArray cellRowCaches = (SparseArray)this.m_aCachedWidthList.get(nYPosition);
        if (cellRowCaches == null) {
            cellRowCaches = new SparseArray();
        }
        cellRowCaches.put(p_nPosition, (Object)p_nWidth);
        this.m_aCachedWidthList.put(nYPosition, (Object)cellRowCaches);
    }

    public int getCacheWidth(int p_nPosition) {
        Integer nCachedWidth;
        int nYPosition = this.getRowPosition();
        SparseArray cellRowCaches = (SparseArray)this.m_aCachedWidthList.get(nYPosition);
        if (cellRowCaches != null && (nCachedWidth = (Integer)cellRowCaches.get(p_nPosition)) != null) {
            return (Integer)cellRowCaches.get(p_nPosition);
        }
        return -1;
    }

    public int getLastDx() {
        return this.m_nLastDx;
    }

    public boolean isNeedFit() {
        return this.m_bNeedFit;
    }

    public void clearNeedFit() {
        this.m_bNeedFit = false;
    }

    public AbstractViewHolder[] getVisibleViewHolders() {
        int nVisibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int nIndex = 0;
        AbstractViewHolder[] views = new AbstractViewHolder[nVisibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            views[nIndex] = (AbstractViewHolder)this.m_iCellRowRecyclerView.findViewHolderForAdapterPosition(i);
            ++nIndex;
        }
        return views;
    }
}

