/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.os.Handler;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.util.TableViewUtils;

public class CellLayoutManager
extends LinearLayoutManager {
    private static final String LOG_TAG = CellLayoutManager.class.getSimpleName();
    private static final int IGNORE_LEFT = -99999;
    private ColumnHeaderLayoutManager m_iColumnHeaderLayoutManager;
    private LinearLayoutManager m_jRowHeaderLayoutManager;
    private CellRecyclerView m_iRowHeaderRecyclerView;
    private CellRecyclerView m_iCellRecyclerView;
    private HorizontalRecyclerViewListener m_iHorizontalListener;
    private ITableView m_iTableView;
    private int m_nLastDy = 0;
    private boolean m_bNeedSetLeft = false;
    private boolean m_bNeedFit = false;

    public CellLayoutManager(Context context, ITableView p_iTableView) {
        super(context);
        this.m_iCellRecyclerView = p_iTableView.getCellRecyclerView();
        this.m_iColumnHeaderLayoutManager = p_iTableView.getColumnHeaderLayoutManager();
        this.m_jRowHeaderLayoutManager = p_iTableView.getRowHeaderLayoutManager();
        this.m_iRowHeaderRecyclerView = p_iTableView.getRowHeaderRecyclerView();
        this.m_iTableView = p_iTableView;
        this.initialize();
    }

    private void initialize() {
        this.setOrientation(1);
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        if (this.m_iCellRecyclerView == null) {
            this.m_iCellRecyclerView = this.m_iTableView.getCellRecyclerView();
        }
        if (this.m_iHorizontalListener == null) {
            this.m_iHorizontalListener = this.m_iTableView.getHorizontalRecyclerViewListener();
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.m_iRowHeaderRecyclerView.getScrollState() == 0 && !this.m_iRowHeaderRecyclerView.isScrollOthers()) {
            this.m_iRowHeaderRecyclerView.scrollBy(0, dy);
        }
        int nScroll = super.scrollVerticallyBy(dy, recycler, state);
        this.m_nLastDy = dy;
        return nScroll;
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0) {
            this.m_nLastDy = 0;
        }
    }

    public void fitWidthSize(boolean p_nScrollingUp) {
        int nLeft = this.m_iColumnHeaderLayoutManager.getFirstItemLeft();
        for (int i = this.m_iColumnHeaderLayoutManager.findFirstVisibleItemPosition(); i < this.m_iColumnHeaderLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            nLeft = this.fitSize(i, nLeft, p_nScrollingUp);
        }
        this.m_bNeedSetLeft = false;
    }

    public void fitWidthSize(int p_nPosition, boolean p_bScrollingLeft) {
        this.fitSize(p_nPosition, -99999, false);
        if (this.m_bNeedSetLeft & p_bScrollingLeft) {
            Handler handler = new Handler();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    CellLayoutManager.this.fitWidthSize2(true);
                }
            });
        }
    }

    private int fitSize(int p_nPosition, int p_nLeft, boolean p_nScrollingUp) {
        int nCellRight;
        block4: {
            nCellRight = -1;
            int nColumnCacheWidth = this.m_iColumnHeaderLayoutManager.getCacheWidth(p_nPosition);
            View column = this.m_iColumnHeaderLayoutManager.findViewByPosition(p_nPosition);
            if (column == null) break block4;
            nCellRight = column.getLeft() + nColumnCacheWidth + 1;
            if (p_nScrollingUp) {
                for (int i = this.findLastVisibleItemPosition(); i >= this.findFirstVisibleItemPosition(); --i) {
                    nCellRight = this.fit(p_nPosition, i, p_nLeft, nCellRight, nColumnCacheWidth);
                }
            } else {
                for (int j = this.findFirstVisibleItemPosition(); j < this.findLastVisibleItemPosition() + 1; ++j) {
                    nCellRight = this.fit(p_nPosition, j, p_nLeft, nCellRight, nColumnCacheWidth);
                }
            }
        }
        return nCellRight;
    }

    private int fit(int p_nXPosition, int p_nYPosition, int p_nLeft, int p_nRight, int p_nColumnCachedWidth) {
        CellRecyclerView child = (CellRecyclerView)this.findViewByPosition(p_nYPosition);
        if (child != null) {
            ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)child.getLayoutManager();
            int nCellCacheWidth = childLayoutManager.getCacheWidth(p_nXPosition);
            View cell = childLayoutManager.findViewByPosition(p_nXPosition);
            if (cell != null && (nCellCacheWidth != p_nColumnCachedWidth || this.m_bNeedSetLeft)) {
                if (nCellCacheWidth != p_nColumnCachedWidth) {
                    nCellCacheWidth = p_nColumnCachedWidth;
                    TableViewUtils.setWidth(cell, nCellCacheWidth);
                    childLayoutManager.setCacheWidth(p_nXPosition, nCellCacheWidth);
                }
                if (p_nLeft != -99999 && cell.getLeft() != p_nLeft) {
                    int nScrollX = Math.max(cell.getLeft(), p_nLeft) - Math.min(cell.getLeft(), p_nLeft);
                    cell.setLeft(p_nLeft);
                    if (this.m_iHorizontalListener.getScrollPositionOffset() > 0 && p_nXPosition == childLayoutManager.findFirstVisibleItemPosition() && this.m_iCellRecyclerView.getScrollState() != 0) {
                        this.m_iHorizontalListener.setScrollPositionOffset(this.m_iHorizontalListener.getScrollPositionOffset() + nScrollX);
                        childLayoutManager.scrollToPositionWithOffset(this.m_iHorizontalListener.getScrollPosition(), this.m_iHorizontalListener.getScrollPositionOffset());
                    }
                }
                if (cell.getWidth() != nCellCacheWidth) {
                    if (p_nLeft != -99999) {
                        p_nRight = cell.getLeft() + nCellCacheWidth + 1;
                        cell.setRight(p_nRight);
                        childLayoutManager.layoutDecoratedWithMargins(cell, cell.getLeft(), cell.getTop(), cell.getRight(), cell.getBottom());
                    }
                    this.m_bNeedSetLeft = true;
                }
            }
        } else {
            Log.e((String)LOG_TAG, (String)(" x: " + p_nXPosition + " y: " + p_nYPosition + " child is null. Because first visible item position is  " + this.findFirstVisibleItemPosition()));
        }
        return p_nRight;
    }

    public void fitWidthSize2(boolean scrollingLeft) {
        this.m_iColumnHeaderLayoutManager.customRequestLayout();
        int columnHeaderScrollPosition = this.m_iTableView.getColumnHeaderRecyclerView().getScrolledX();
        int columnHeaderOffset = this.m_iColumnHeaderLayoutManager.getFirstItemLeft();
        int columnHeaderFirstItem = this.m_iColumnHeaderLayoutManager.findFirstVisibleItemPosition();
        for (int i = this.m_iColumnHeaderLayoutManager.findFirstVisibleItemPosition(); i < this.m_iColumnHeaderLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            this.fitSize2(i, scrollingLeft, columnHeaderScrollPosition, columnHeaderOffset, columnHeaderFirstItem);
        }
        this.m_bNeedSetLeft = false;
    }

    private void fitSize2(int p_nPosition, boolean scrollingLeft, int columnHeaderScrollPosition, int columnHeaderOffset, int columnHeaderFirstItem) {
        int nColumnCacheWidth = this.m_iColumnHeaderLayoutManager.getCacheWidth(p_nPosition);
        View column = this.m_iColumnHeaderLayoutManager.findViewByPosition(p_nPosition);
        if (column != null) {
            for (int j = this.findFirstVisibleItemPosition(); j < this.findLastVisibleItemPosition() + 1; ++j) {
                CellRecyclerView child = (CellRecyclerView)this.findViewByPosition(j);
                if (!scrollingLeft && columnHeaderScrollPosition != child.getScrolledX()) {
                    ((LinearLayoutManager)child.getLayoutManager()).scrollToPositionWithOffset(columnHeaderFirstItem, columnHeaderOffset);
                }
                this.fit2(p_nPosition, j, nColumnCacheWidth, column);
            }
        }
    }

    private void fit2(int p_nXPosition, int p_nYPosition, int p_nColumnCachedWidth, View p_jColumn) {
        CellRecyclerView child = (CellRecyclerView)this.findViewByPosition(p_nYPosition);
        if (child != null) {
            ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)child.getLayoutManager();
            int nCellCacheWidth = childLayoutManager.getCacheWidth(p_nXPosition);
            View cell = childLayoutManager.findViewByPosition(p_nXPosition);
            if (cell != null && (nCellCacheWidth != p_nColumnCachedWidth || this.m_bNeedSetLeft)) {
                if (nCellCacheWidth != p_nColumnCachedWidth) {
                    nCellCacheWidth = p_nColumnCachedWidth;
                    TableViewUtils.setWidth(cell, nCellCacheWidth);
                    childLayoutManager.setCacheWidth(p_nXPosition, nCellCacheWidth);
                }
                if (p_jColumn.getLeft() != cell.getLeft() || p_jColumn.getRight() != cell.getRight()) {
                    cell.setLeft(p_jColumn.getLeft());
                    cell.setRight(p_jColumn.getRight() + 1);
                    childLayoutManager.layoutDecoratedWithMargins(cell, cell.getLeft(), cell.getTop(), cell.getRight(), cell.getBottom());
                    this.m_bNeedSetLeft = true;
                }
            }
        }
    }

    public boolean shouldFitColumns(int p_nYPosition) {
        int nLastVisiblePosition;
        CellRecyclerView lastCellRecyclerView;
        CellRecyclerView cellRecyclerView;
        if (this.m_iCellRecyclerView.getScrollState() == 0 && !(cellRecyclerView = (CellRecyclerView)this.findViewByPosition(p_nYPosition)).isScrollOthers() && (lastCellRecyclerView = (CellRecyclerView)this.findViewByPosition(nLastVisiblePosition = this.findLastVisibleItemPosition())) != null) {
            if (p_nYPosition == nLastVisiblePosition) {
                return true;
            }
            if (lastCellRecyclerView.isScrollOthers() && p_nYPosition == nLastVisiblePosition - 1) {
                return true;
            }
        }
        return false;
    }

    public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.m_iTableView.hasFixedWidth()) {
            super.measureChildWithMargins(child, widthUsed, heightUsed);
            return;
        }
        int nPosition = this.getPosition(child);
        ColumnLayoutManager childLayoutManager = (ColumnLayoutManager)((CellRecyclerView)child).getLayoutManager();
        if (this.m_iCellRecyclerView.getScrollState() != 0) {
            if (childLayoutManager.isNeedFit()) {
                if (this.m_nLastDy < 0) {
                    Log.e((String)LOG_TAG, (String)(nPosition + " fitWidthSize all vertically up"));
                    this.fitWidthSize(true);
                } else {
                    Log.e((String)LOG_TAG, (String)(nPosition + " fitWidthSize all vertically down"));
                    this.fitWidthSize(false);
                }
                childLayoutManager.clearNeedFit();
            }
        } else if (this.m_iCellRecyclerView.getScrollState() == 0 && childLayoutManager.getLastDx() == 0) {
            if (childLayoutManager.isNeedFit()) {
                this.m_bNeedFit = true;
                childLayoutManager.clearNeedFit();
            }
            if (this.m_bNeedFit && this.m_jRowHeaderLayoutManager.findLastVisibleItemPosition() == nPosition) {
                this.fitWidthSize2(false);
                Log.e((String)LOG_TAG, (String)(nPosition + " fitWidthSize populating data for the first time"));
                this.m_bNeedFit = false;
            }
        }
    }

    public AbstractViewHolder[] getVisibleCellViewsByColumnPosition(int p_nXPosition) {
        int nVisibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int nIndex = 0;
        AbstractViewHolder[] viewHolders = new AbstractViewHolder[nVisibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            AbstractViewHolder holder;
            CellRecyclerView cellRowRecyclerView = (CellRecyclerView)this.findViewByPosition(i);
            viewHolders[nIndex] = holder = (AbstractViewHolder)cellRowRecyclerView.findViewHolderForAdapterPosition(p_nXPosition);
            ++nIndex;
        }
        return viewHolders;
    }

    public AbstractViewHolder getCellViewHolder(int p_nXPosition, int p_nYPosition) {
        CellRecyclerView cellRowRecyclerView = (CellRecyclerView)this.findViewByPosition(p_nYPosition);
        if (cellRowRecyclerView != null) {
            return (AbstractViewHolder)cellRowRecyclerView.findViewHolderForAdapterPosition(p_nXPosition);
        }
        return null;
    }

    public void remeasureAllChild() {
        for (int j = 0; j < this.getChildCount(); ++j) {
            CellRecyclerView recyclerView = (CellRecyclerView)this.getChildAt(j);
            recyclerView.getLayoutParams().width = -2;
            recyclerView.requestLayout();
        }
    }

    public CellRecyclerView[] getVisibleCellRowRecyclerViews() {
        int nLength = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        CellRecyclerView[] recyclerViews = new CellRecyclerView[nLength];
        int index = 0;
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            recyclerViews[index] = (CellRecyclerView)this.findViewByPosition(i);
            ++index;
        }
        return recyclerViews;
    }
}

