/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.util.Log;
import android.util.SparseArray;
import com.evrencoskun.tableview.ITableView;
import java.util.List;

public class VisibilityHandler {
    private static final String LOG_TAG = VisibilityHandler.class.getSimpleName();
    private ITableView mTableView;
    private SparseArray<Row> mHideRowList = new SparseArray();
    private SparseArray<Column> mHideColumnList = new SparseArray();

    public VisibilityHandler(ITableView pTableView) {
        this.mTableView = pTableView;
    }

    public void hideRow(int pYPosition) {
        this.mHideRowList.put(pYPosition, (Object)this.getRowValueFromPosition(pYPosition));
        this.mTableView.getAdapter().removeRow(pYPosition);
    }

    public void showRow(int pYPosition) {
        this.showRow(pYPosition, true);
    }

    private void showRow(int pYPosition, boolean p_bRemoveFromList) {
        Row hiddenRow = (Row)this.mHideRowList.get(pYPosition);
        if (hiddenRow != null) {
            this.mTableView.getAdapter().addRow(pYPosition, hiddenRow.getRowHeaderModel(), hiddenRow.getCellModelList());
        } else {
            Log.e((String)LOG_TAG, (String)"This row is already visible.");
        }
        if (p_bRemoveFromList) {
            this.mHideRowList.remove(pYPosition);
        }
    }

    public void clearHideRowList() {
        this.mHideRowList.clear();
    }

    public void showAllHiddenRows() {
        for (int i = 0; i < this.mHideRowList.size(); ++i) {
            int nYPosition = this.mHideRowList.keyAt(i);
            this.showRow(nYPosition, false);
        }
        this.clearHideRowList();
    }

    public boolean isRowVisible(int row) {
        return this.mHideRowList.get(row) == null;
    }

    public void hideColumn(int column) {
        this.mHideColumnList.put(column, (Object)this.getColumnValueFromPosition(column));
        this.mTableView.getAdapter().removeColumn(column);
    }

    public void showColumn(int column) {
        this.showColumn(column, true);
    }

    private void showColumn(int column, boolean p_bRemoveFromList) {
        Column hiddenColumn = (Column)this.mHideColumnList.get(column);
        if (hiddenColumn != null) {
            this.mTableView.getAdapter().addColumn(column, hiddenColumn.getColumnHeaderModel(), hiddenColumn.getCellModelList());
        } else {
            Log.e((String)LOG_TAG, (String)"This column is already visible.");
        }
        if (p_bRemoveFromList) {
            this.mHideColumnList.remove(column);
        }
    }

    public void clearHideColumnList() {
        this.mHideColumnList.clear();
    }

    public void showAllHiddenColumns() {
        for (int i = 0; i < this.mHideColumnList.size(); ++i) {
            int nXPosition = this.mHideColumnList.keyAt(i);
            this.showColumn(nXPosition, false);
        }
        this.clearHideColumnList();
    }

    public boolean isColumnVisible(int column) {
        return this.mHideColumnList.get(column) == null;
    }

    private Row getRowValueFromPosition(int row) {
        Object rowHeaderModel = this.mTableView.getAdapter().getRowHeaderItem(row);
        List<Object> cellModelList = this.mTableView.getAdapter().getCellRowItems(row);
        return new Row(row, rowHeaderModel, cellModelList);
    }

    private Column getColumnValueFromPosition(int column) {
        Object columnHeaderModel = this.mTableView.getAdapter().getColumnHeaderItem(column);
        List<Object> cellModelList = this.mTableView.getAdapter().getCellColumnItems(column);
        return new Column(column, columnHeaderModel, cellModelList);
    }

    class Column {
        private int mYPosition;
        private Object mColumnHeaderModel;
        private List<Object> mCellModelList;

        public Column(int pYPosition, Object pColumnHeaderModel, List<Object> pCellModelList) {
            this.mYPosition = pYPosition;
            this.mColumnHeaderModel = pColumnHeaderModel;
            this.mCellModelList = pCellModelList;
        }

        public int getYPosition() {
            return this.mYPosition;
        }

        public Object getColumnHeaderModel() {
            return this.mColumnHeaderModel;
        }

        public List<Object> getCellModelList() {
            return this.mCellModelList;
        }
    }

    class Row {
        private int mYPosition;
        private Object mRowHeaderModel;
        private List<Object> mCellModelList;

        public Row(int pYPosition, Object pRowHeaderModel, List<Object> pCellModelList) {
            this.mYPosition = pYPosition;
            this.mRowHeaderModel = pRowHeaderModel;
            this.mCellModelList = pCellModelList;
        }

        public int getYPosition() {
            return this.mYPosition;
        }

        public Object getRowHeaderModel() {
            return this.mRowHeaderModel;
        }

        public List<Object> getCellModelList() {
            return this.mCellModelList;
        }
    }
}

