/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;

public class ScrollHandler {
    private ITableView mTableView;
    private CellLayoutManager mCellLayoutManager;
    private LinearLayoutManager mRowHeaderLayoutManager;

    public ScrollHandler(ITableView tableView) {
        this.mTableView = tableView;
        this.mCellLayoutManager = tableView.getCellLayoutManager();
        this.mRowHeaderLayoutManager = tableView.getRowHeaderLayoutManager();
    }

    public void scrollToColumnPosition(int columnPosition) {
        if (!((View)this.mTableView).isShown()) {
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPosition(columnPosition);
        }
        this.scrollColumnHeader(columnPosition);
        this.scrollCellHorizontally(columnPosition);
    }

    public void scrollToRowPosition(int rowPosition) {
        this.mRowHeaderLayoutManager.scrollToPosition(rowPosition);
        this.mCellLayoutManager.scrollToPosition(rowPosition);
    }

    private void scrollCellHorizontally(int pColumnPosition) {
        CellLayoutManager cellLayoutManager = this.mTableView.getCellLayoutManager();
        for (int i = cellLayoutManager.findFirstVisibleItemPosition(); i < cellLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)cellLayoutManager.findViewByPosition(i);
            if (cellRowRecyclerView == null) continue;
            ColumnLayoutManager columnLayoutManager = (ColumnLayoutManager)cellRowRecyclerView.getLayoutManager();
            columnLayoutManager.scrollToPosition(pColumnPosition);
        }
    }

    private void scrollColumnHeader(int pColumnPosition) {
        this.mTableView.getColumnHeaderLayoutManager().scrollToPosition(pColumnPosition);
    }
}

