/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.ColumnSortHelper;
import com.evrencoskun.tableview.sort.SortState;
import java.util.List;

public class ColumnHeaderRecyclerViewAdapter<CH>
extends AbstractRecyclerViewAdapter<CH> {
    private static final String LOG_TAG = ColumnHeaderRecyclerViewAdapter.class.getSimpleName();
    private ITableAdapter m_iTableAdapter;
    private ColumnSortHelper mColumnSortHelper;

    public ColumnHeaderRecyclerViewAdapter(Context context, List<CH> p_jItemList, ITableAdapter p_iTableAdapter) {
        super(context, p_jItemList);
        this.m_iTableAdapter = p_iTableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.m_iTableAdapter.onCreateColumnHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        Object value = this.getItem(position);
        this.m_iTableAdapter.onBindColumnHeaderViewHolder(viewHolder, value, position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.m_iTableAdapter.getColumnHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        AbstractViewHolder.SelectionState selectionState = this.m_iTableAdapter.getTableView().getSelectionHandler().getColumnSelectionState(viewHolder.getAdapterPosition());
        if (!this.m_iTableAdapter.getTableView().isIgnoreSelectionColors()) {
            this.m_iTableAdapter.getTableView().getSelectionHandler().changeColumnBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
        if (this.m_iTableAdapter.getTableView().isSortable() && viewHolder instanceof AbstractSorterViewHolder) {
            SortState state = this.getColumnSortHelper().getSortingStatus(viewHolder.getAdapterPosition());
            ((AbstractSorterViewHolder)viewHolder).onSortingStatusChanged(state);
        }
    }

    public ColumnSortHelper getColumnSortHelper() {
        if (this.mColumnSortHelper == null) {
            this.mColumnSortHelper = new ColumnSortHelper(this.m_iTableAdapter.getTableView().getColumnHeaderLayoutManager());
        }
        return this.mColumnSortHelper;
    }
}

