/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.R;
import com.evrencoskun.tableview.adapter.AbstractTableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.handler.ColumnSortHandler;
import com.evrencoskun.tableview.handler.ScrollHandler;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.handler.VisibilityHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.listener.ITableViewListener;
import com.evrencoskun.tableview.listener.TableViewLayoutChangeListener;
import com.evrencoskun.tableview.listener.itemclick.ColumnHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.itemclick.RowHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;
import com.evrencoskun.tableview.sort.SortState;

public class TableView
extends FrameLayout
implements ITableView {
    private static final String LOG_TAG = TableView.class.getSimpleName();
    protected CellRecyclerView m_jCellRecyclerView;
    protected CellRecyclerView m_jColumnHeaderRecyclerView;
    protected CellRecyclerView m_jRowHeaderRecyclerView;
    protected AbstractTableAdapter m_iTableAdapter;
    private ITableViewListener m_iTableViewListener;
    private VerticalRecyclerViewListener m_jVerticalRecyclerListener;
    private HorizontalRecyclerViewListener m_jHorizontalRecyclerViewListener;
    private ColumnHeaderRecyclerViewItemClickListener m_jColumnHeaderRecyclerViewItemClickListener;
    private RowHeaderRecyclerViewItemClickListener m_jRowHeaderRecyclerViewItemClickListener;
    private ColumnHeaderLayoutManager m_iColumnHeaderLayoutManager;
    private LinearLayoutManager m_jRowHeaderLayoutManager;
    private CellLayoutManager m_iCellLayoutManager;
    private DividerItemDecoration m_jVerticalItemDecoration;
    private DividerItemDecoration m_jHorizontalItemDecoration;
    private SelectionHandler mSelectionHandler;
    private ColumnSortHandler m_iColumnSortHandler;
    private VisibilityHandler m_iVisibilityHandler;
    private ScrollHandler mScrollHandler;
    private int m_nRowHeaderWidth;
    private int m_nColumnHeaderHeight;
    private int m_nSelectedColor;
    private int m_nUnSelectedColor;
    private int m_nShadowColor;
    private int m_nSeparatorColor = -1;
    private boolean m_bIsFixedWidth;
    private boolean m_bIgnoreSelectionColors;
    private boolean m_bShowHorizontalSeparators = true;
    private boolean m_bShowVerticalSeparators = true;
    private boolean m_bIsSortable = false;

    public TableView(@NonNull Context context) {
        super(context);
        this.initialDefaultValues(null);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialDefaultValues(attrs);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialDefaultValues(null);
        this.initialize();
    }

    private void initialDefaultValues(AttributeSet attrs) {
        this.m_nRowHeaderWidth = (int)this.getResources().getDimension(R.dimen.default_row_header_width);
        this.m_nColumnHeaderHeight = (int)this.getResources().getDimension(R.dimen.default_column_header_height);
        this.m_nSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_selected_background_color);
        this.m_nUnSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_unselected_background_color);
        this.m_nShadowColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_shadow_background_color);
        if (attrs == null) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TableView, 0, 0);
        try {
            this.m_nRowHeaderWidth = (int)a.getDimension(R.styleable.TableView_row_header_width, (float)this.m_nRowHeaderWidth);
            this.m_nColumnHeaderHeight = (int)a.getDimension(R.styleable.TableView_column_header_height, (float)this.m_nColumnHeaderHeight);
            this.m_nSelectedColor = a.getColor(R.styleable.TableView_selected_color, this.m_nSelectedColor);
            this.m_nUnSelectedColor = a.getColor(R.styleable.TableView_unselected_color, this.m_nUnSelectedColor);
            this.m_nShadowColor = a.getColor(R.styleable.TableView_shadow_color, this.m_nShadowColor);
            this.m_nSeparatorColor = a.getColor(R.styleable.TableView_separator_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_separator_color));
            this.m_bShowVerticalSeparators = a.getBoolean(R.styleable.TableView_show_vertical_separator, this.m_bShowVerticalSeparators);
            this.m_bShowHorizontalSeparators = a.getBoolean(R.styleable.TableView_show_horizontal_separator, this.m_bShowHorizontalSeparators);
        }
        finally {
            a.recycle();
        }
    }

    private void initialize() {
        this.m_jColumnHeaderRecyclerView = this.createColumnHeaderRecyclerView();
        this.m_jRowHeaderRecyclerView = this.createRowHeaderRecyclerView();
        this.m_jCellRecyclerView = this.createCellRecyclerView();
        this.addView((View)this.m_jColumnHeaderRecyclerView);
        this.addView((View)this.m_jRowHeaderRecyclerView);
        this.addView((View)this.m_jCellRecyclerView);
        this.mSelectionHandler = new SelectionHandler(this);
        this.m_iVisibilityHandler = new VisibilityHandler(this);
        this.mScrollHandler = new ScrollHandler(this);
        this.initializeListeners();
    }

    protected void initializeListeners() {
        this.m_jVerticalRecyclerListener = new VerticalRecyclerViewListener(this);
        this.m_jRowHeaderRecyclerView.addOnItemTouchListener(this.m_jVerticalRecyclerListener);
        this.m_jCellRecyclerView.addOnItemTouchListener(this.m_jVerticalRecyclerListener);
        this.m_jHorizontalRecyclerViewListener = new HorizontalRecyclerViewListener(this);
        this.m_jColumnHeaderRecyclerView.addOnItemTouchListener(this.m_jHorizontalRecyclerViewListener);
        this.m_jColumnHeaderRecyclerViewItemClickListener = new ColumnHeaderRecyclerViewItemClickListener(this.m_jColumnHeaderRecyclerView, this);
        this.m_jRowHeaderRecyclerViewItemClickListener = new RowHeaderRecyclerViewItemClickListener(this.m_jRowHeaderRecyclerView, this);
        this.m_jColumnHeaderRecyclerView.addOnItemTouchListener(this.m_jColumnHeaderRecyclerViewItemClickListener);
        this.m_jRowHeaderRecyclerView.addOnItemTouchListener(this.m_jRowHeaderRecyclerViewItemClickListener);
        TableViewLayoutChangeListener layoutChangeListener = new TableViewLayoutChangeListener(this);
        this.m_jColumnHeaderRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
        this.m_jCellRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
    }

    protected CellRecyclerView createColumnHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getColumnHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, this.m_nColumnHeaderHeight);
        layoutParams.leftMargin = this.m_nRowHeaderWidth;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowHorizontalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getHorizontalItemDecoration());
        }
        return recyclerView;
    }

    protected CellRecyclerView createRowHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getRowHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.m_nRowHeaderWidth, -2);
        layoutParams.topMargin = this.m_nColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    protected CellRecyclerView createCellRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setMotionEventSplittingEnabled(false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getCellLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = this.m_nRowHeaderWidth;
        layoutParams.topMargin = this.m_nColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    public void setAdapter(AbstractTableAdapter p_iTableAdapter) {
        if (p_iTableAdapter != null) {
            this.m_iTableAdapter = p_iTableAdapter;
            this.m_iTableAdapter.setRowHeaderWidth(this.m_nRowHeaderWidth);
            this.m_iTableAdapter.setColumnHeaderHeight(this.m_nColumnHeaderHeight);
            this.m_iTableAdapter.setTableView(this);
            if (this.m_jColumnHeaderRecyclerView != null) {
                this.m_jColumnHeaderRecyclerView.setAdapter(this.m_iTableAdapter.getColumnHeaderRecyclerViewAdapter());
            }
            if (this.m_jRowHeaderRecyclerView != null) {
                this.m_jRowHeaderRecyclerView.setAdapter(this.m_iTableAdapter.getRowHeaderRecyclerViewAdapter());
            }
            if (this.m_jCellRecyclerView != null) {
                this.m_jCellRecyclerView.setAdapter(this.m_iTableAdapter.getCellRecyclerViewAdapter());
                this.m_iColumnSortHandler = new ColumnSortHandler(this);
            }
        }
    }

    @Override
    public boolean hasFixedWidth() {
        return this.m_bIsFixedWidth;
    }

    public void setHasFixedWidth(boolean p_bHasFixedWidth) {
        this.m_bIsFixedWidth = p_bHasFixedWidth;
        this.m_jColumnHeaderRecyclerView.setHasFixedSize(p_bHasFixedWidth);
    }

    @Override
    public boolean isIgnoreSelectionColors() {
        return this.m_bIgnoreSelectionColors;
    }

    public void setIgnoreSelectionColors(boolean p_bIsIgnore) {
        this.m_bIgnoreSelectionColors = p_bIsIgnore;
    }

    @Override
    public boolean isShowHorizontalSeparators() {
        return this.m_bShowHorizontalSeparators;
    }

    @Override
    public boolean isSortable() {
        return this.m_bIsSortable;
    }

    public void setShowHorizontalSeparators(boolean p_bShowSeparators) {
        this.m_bShowHorizontalSeparators = p_bShowSeparators;
    }

    public boolean isShowVerticalSeparators() {
        return this.m_bShowVerticalSeparators;
    }

    public void setShowVerticalSeparators(boolean p_bShowSeparators) {
        this.m_bShowVerticalSeparators = p_bShowSeparators;
    }

    @Override
    public CellRecyclerView getCellRecyclerView() {
        return this.m_jCellRecyclerView;
    }

    @Override
    public CellRecyclerView getColumnHeaderRecyclerView() {
        return this.m_jColumnHeaderRecyclerView;
    }

    @Override
    public CellRecyclerView getRowHeaderRecyclerView() {
        return this.m_jRowHeaderRecyclerView;
    }

    @Override
    public ColumnHeaderLayoutManager getColumnHeaderLayoutManager() {
        if (this.m_iColumnHeaderLayoutManager == null) {
            this.m_iColumnHeaderLayoutManager = new ColumnHeaderLayoutManager(this.getContext(), this);
        }
        return this.m_iColumnHeaderLayoutManager;
    }

    @Override
    public CellLayoutManager getCellLayoutManager() {
        if (this.m_iCellLayoutManager == null) {
            this.m_iCellLayoutManager = new CellLayoutManager(this.getContext(), this);
        }
        return this.m_iCellLayoutManager;
    }

    @Override
    public LinearLayoutManager getRowHeaderLayoutManager() {
        if (this.m_jRowHeaderLayoutManager == null) {
            this.m_jRowHeaderLayoutManager = new LinearLayoutManager(this.getContext(), 1, false);
        }
        return this.m_jRowHeaderLayoutManager;
    }

    @Override
    public HorizontalRecyclerViewListener getHorizontalRecyclerViewListener() {
        return this.m_jHorizontalRecyclerViewListener;
    }

    @Override
    public VerticalRecyclerViewListener getVerticalRecyclerViewListener() {
        return this.m_jVerticalRecyclerListener;
    }

    @Override
    public ITableViewListener getTableViewListener() {
        return this.m_iTableViewListener;
    }

    public void setTableViewListener(ITableViewListener p_jTableViewListener) {
        this.m_iTableViewListener = p_jTableViewListener;
    }

    @Override
    public void sortColumn(int p_nColumnPosition, SortState p_eSortState) {
        this.m_bIsSortable = true;
        this.m_iColumnSortHandler.sort(p_nColumnPosition, p_eSortState);
    }

    @Override
    public void remeasureColumnWidth(int column) {
        this.getColumnHeaderLayoutManager().removeCachedWidth(column);
        this.getCellLayoutManager().fitWidthSize(column, false);
    }

    @Override
    public AbstractTableAdapter getAdapter() {
        return this.m_iTableAdapter;
    }

    @Override
    public SortState getSortingStatus(int column) {
        return this.m_iColumnSortHandler.getSortingStatus(column);
    }

    @Override
    public void scrollToColumnPosition(int column) {
        this.mScrollHandler.scrollToColumnPosition(column);
    }

    @Override
    public void scrollToRowPosition(int row) {
        this.mScrollHandler.scrollToRowPosition(row);
    }

    @Override
    public void showRow(int row) {
        this.m_iVisibilityHandler.showRow(row);
    }

    @Override
    public void hideRow(int row) {
        this.m_iVisibilityHandler.hideRow(row);
    }

    @Override
    public void showAllHiddenRows() {
        this.m_iVisibilityHandler.showAllHiddenRows();
    }

    @Override
    public void clearHiddenRowList() {
        this.m_iVisibilityHandler.clearHideRowList();
    }

    @Override
    public void showColumn(int column) {
        this.m_iVisibilityHandler.showColumn(column);
    }

    @Override
    public void hideColumn(int column) {
        this.m_iVisibilityHandler.hideColumn(column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.m_iVisibilityHandler.isColumnVisible(column);
    }

    @Override
    public void showAllHiddenColumns() {
        this.m_iVisibilityHandler.showAllHiddenColumns();
    }

    @Override
    public void clearHiddenColumnList() {
        this.m_iVisibilityHandler.clearHideColumnList();
    }

    @Override
    public boolean isRowVisible(int row) {
        return this.m_iVisibilityHandler.isRowVisible(row);
    }

    public int getSelectedRow() {
        return this.mSelectionHandler.getSelectedRowPosition();
    }

    public void setSelectedRow(int p_nYPosition) {
        AbstractViewHolder jRowViewHolder = (AbstractViewHolder)this.getRowHeaderRecyclerView().findViewHolderForAdapterPosition(p_nYPosition);
        this.mSelectionHandler.setSelectedRowPosition(jRowViewHolder, p_nYPosition);
    }

    public int getSelectedColumn() {
        return this.mSelectionHandler.getSelectedColumnPosition();
    }

    public void setSelectedColumn(int p_nXPosition) {
        AbstractViewHolder jColumnViewHolder = (AbstractViewHolder)this.getColumnHeaderRecyclerView().findViewHolderForAdapterPosition(p_nXPosition);
        this.mSelectionHandler.setSelectedColumnPosition(jColumnViewHolder, p_nXPosition);
    }

    public void setSelectedCell(int p_nXPosition, int p_nYPosition) {
        AbstractViewHolder jCellViewHolder = this.getCellLayoutManager().getCellViewHolder(p_nXPosition, p_nYPosition);
        this.mSelectionHandler.setSelectedCellPositions(jCellViewHolder, p_nXPosition, p_nYPosition);
    }

    @Override
    public SelectionHandler getSelectionHandler() {
        return this.mSelectionHandler;
    }

    @Override
    public DividerItemDecoration getHorizontalItemDecoration() {
        if (this.m_jHorizontalItemDecoration == null) {
            this.m_jHorizontalItemDecoration = this.createItemDecoration(0);
        }
        return this.m_jHorizontalItemDecoration;
    }

    private DividerItemDecoration getVerticalItemDecoration() {
        if (this.m_jVerticalItemDecoration == null) {
            this.m_jVerticalItemDecoration = this.createItemDecoration(1);
        }
        return this.m_jVerticalItemDecoration;
    }

    private DividerItemDecoration createItemDecoration(int orientation) {
        Drawable mDivider = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.cell_line_divider);
        if (this.m_nSeparatorColor != -1) {
            mDivider.setColorFilter(this.m_nSeparatorColor, PorterDuff.Mode.SRC_ATOP);
        }
        DividerItemDecoration jItemDecoration = new DividerItemDecoration(this.getContext(), orientation);
        jItemDecoration.setDrawable(mDivider);
        return jItemDecoration;
    }

    public void setSelectedColor(@ColorInt int p_nSelectedColor) {
        this.m_nSelectedColor = p_nSelectedColor;
    }

    @Override
    @ColorInt
    public int getSelectedColor() {
        return this.m_nSelectedColor;
    }

    public void setUnSelectedColor(@ColorInt int p_nUnSelectedColor) {
        this.m_nUnSelectedColor = p_nUnSelectedColor;
    }

    @Override
    @ColorInt
    public int getUnSelectedColor() {
        return this.m_nUnSelectedColor;
    }

    public void setShadowColor(@ColorInt int p_nShadowColor) {
        this.m_nShadowColor = p_nShadowColor;
    }

    @Override
    @ColorInt
    public int getShadowColor() {
        return this.m_nShadowColor;
    }
}

