/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.R;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;
import com.evrencoskun.tableview.listener.itemclick.CellRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import java.util.ArrayList;
import java.util.List;

public class CellRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRecyclerViewAdapter.class.getSimpleName();
    private List<RecyclerView.Adapter> m_jAdapterList;
    private ITableAdapter m_iTableAdapter;
    private final DividerItemDecoration m_jCellItemDecoration;
    private HorizontalRecyclerViewListener m_iHorizontalListener;
    private int m_nRecyclerViewId = 0;

    public CellRecyclerViewAdapter(Context context, List<C> p_jItemList, ITableAdapter p_iTableAdapter) {
        super(context, p_jItemList);
        this.m_iTableAdapter = p_iTableAdapter;
        this.m_jAdapterList = new ArrayList<RecyclerView.Adapter>();
        this.m_jCellItemDecoration = this.createCellItemDecoration();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ITableView iTableView = this.m_iTableAdapter.getTableView();
        CellRecyclerView jRecyclerView = new CellRecyclerView(this.m_jContext);
        jRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.m_jCellItemDecoration);
        if (iTableView != null) {
            jRecyclerView.setHasFixedSize(iTableView.hasFixedWidth());
            if (this.m_iHorizontalListener == null) {
                this.m_iHorizontalListener = iTableView.getHorizontalRecyclerViewListener();
            }
            jRecyclerView.addOnItemTouchListener(this.m_iHorizontalListener);
            if (iTableView.getTableViewListener() != null) {
                jRecyclerView.addOnItemTouchListener(new CellRecyclerViewItemClickListener(jRecyclerView, iTableView));
            }
            ColumnLayoutManager layoutManager = new ColumnLayoutManager(this.m_jContext, iTableView, jRecyclerView);
            jRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            jRecyclerView.setId(this.m_nRecyclerViewId);
            ++this.m_nRecyclerViewId;
        }
        return new CellRowViewHolder((View)jRecyclerView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int p_nYPosition) {
        if (!(holder instanceof CellRowViewHolder)) {
            return;
        }
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        List rowList = (List)this.m_jItemList.get(p_nYPosition);
        CellRowRecyclerViewAdapter viewAdapter = new CellRowRecyclerViewAdapter(this.m_jContext, rowList, this.m_iTableAdapter, p_nYPosition);
        viewHolder.m_jRecyclerView.setAdapter(viewAdapter);
        this.m_jAdapterList.add(viewAdapter);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        ((ColumnLayoutManager)viewHolder.m_jRecyclerView.getLayoutManager()).scrollToPositionWithOffset(this.m_iHorizontalListener.getScrollPosition(), this.m_iHorizontalListener.getScrollPositionOffset());
        SelectionHandler selectionHandler = this.m_iTableAdapter.getTableView().getSelectionHandler();
        if (selectionHandler.isAnyColumnSelected()) {
            AbstractViewHolder cellViewHolder = (AbstractViewHolder)((CellRowViewHolder)holder).m_jRecyclerView.findViewHolderForAdapterPosition(selectionHandler.getSelectedColumnPosition());
            if (cellViewHolder != null) {
                if (!this.m_iTableAdapter.getTableView().IsIgnoreSelectionColors()) {
                    cellViewHolder.setBackgroundColor(this.m_iTableAdapter.getTableView().getSelectedColor());
                }
                cellViewHolder.setSelected(true);
            }
        } else if (selectionHandler.isRowSelected(holder.getAdapterPosition())) {
            viewHolder.m_jRecyclerView.setSelected(true, this.m_iTableAdapter.getTableView().getSelectedColor(), this.m_iTableAdapter.getTableView().IsIgnoreSelectionColors());
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        ((CellRowViewHolder)holder).m_jRecyclerView.setSelected(false, this.m_iTableAdapter.getTableView().getUnSelectedColor(), this.m_iTableAdapter.getTableView().IsIgnoreSelectionColors());
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        viewHolder.m_jRecyclerView.clearScrolledX();
    }

    private DividerItemDecoration createCellItemDecoration() {
        Drawable mDivider = ContextCompat.getDrawable((Context)this.m_jContext, (int)R.drawable.cell_line_divider);
        DividerItemDecoration jItemDecoration = new DividerItemDecoration(this.m_jContext, 0);
        jItemDecoration.setDrawable(mDivider);
        return jItemDecoration;
    }

    public void notifyCellDataSetChanged() {
        if (this.m_jAdapterList != null) {
            if (this.m_jAdapterList.isEmpty()) {
                this.notifyDataSetChanged();
            } else {
                for (RecyclerView.Adapter adapter : this.m_jAdapterList) {
                    adapter.notifyDataSetChanged();
                }
            }
        }
    }

    static class CellRowViewHolder
    extends RecyclerView.ViewHolder {
        final CellRecyclerView m_jRecyclerView;

        CellRowViewHolder(View itemView) {
            super(itemView);
            this.m_jRecyclerView = (CellRecyclerView)itemView;
        }
    }
}

