/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.util.TableViewUtils;

public class ColumnLayoutManager
extends LinearLayoutManager {
    private static final String LOG_TAG = ColumnLayoutManager.class.getSimpleName();
    @NonNull
    private final ITableView mTableView;
    private CellRecyclerView mCellRowRecyclerView;
    @NonNull
    private final CellRecyclerView mColumnHeaderRecyclerView;
    @NonNull
    private final ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    @NonNull
    private final CellLayoutManager mCellLayoutManager;
    private boolean mNeedFitForVerticalScroll;
    private boolean mNeedFitForHorizontalScroll;
    private int mLastDx = 0;
    private int mYPosition;

    public ColumnLayoutManager(@NonNull Context context, @NonNull ITableView tableView) {
        super(context);
        this.mTableView = tableView;
        this.mColumnHeaderRecyclerView = this.mTableView.getColumnHeaderRecyclerView();
        this.mColumnHeaderLayoutManager = this.mTableView.getColumnHeaderLayoutManager();
        this.mCellLayoutManager = this.mTableView.getCellLayoutManager();
        this.setOrientation(0);
        this.setRecycleChildrenOnDetach(true);
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mCellRowRecyclerView = (CellRecyclerView)view;
        this.mYPosition = this.getRowPosition();
    }

    public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.mTableView.hasFixedWidth()) {
            return;
        }
        this.measureChild(child, widthUsed, heightUsed);
    }

    public void measureChild(@NonNull View child, int widthUsed, int heightUsed) {
        int columnPosition = this.getPosition(child);
        int cacheWidth = this.mCellLayoutManager.getCacheWidth(this.mYPosition, columnPosition);
        int columnCacheWidth = this.mColumnHeaderLayoutManager.getCacheWidth(columnPosition);
        if (cacheWidth != -1 && cacheWidth == columnCacheWidth) {
            if (child.getMeasuredWidth() != cacheWidth) {
                TableViewUtils.setWidth(child, cacheWidth);
            }
        } else {
            View columnHeaderChild = this.mColumnHeaderLayoutManager.findViewByPosition(columnPosition);
            if (columnHeaderChild == null) {
                return;
            }
            this.fitWidthSize(child, this.mYPosition, columnPosition, cacheWidth, columnCacheWidth, columnHeaderChild);
        }
        if (this.shouldFitColumns(columnPosition, this.mYPosition)) {
            if (this.mLastDx < 0) {
                Log.e((String)LOG_TAG, (String)("x: " + columnPosition + " y: " + this.mYPosition + " fitWidthSize left side "));
                this.mCellLayoutManager.fitWidthSize(columnPosition, true);
            } else {
                this.mCellLayoutManager.fitWidthSize(columnPosition, false);
                Log.e((String)LOG_TAG, (String)("x: " + columnPosition + " y: " + this.mYPosition + " fitWidthSize right side"));
            }
            this.mNeedFitForVerticalScroll = false;
        }
        this.mNeedFitForHorizontalScroll = false;
    }

    private void fitWidthSize(@NonNull View child, int row, int column, int cellWidth, int columnHeaderWidth, @NonNull View columnHeaderChild) {
        if (cellWidth == -1) {
            cellWidth = child.getMeasuredWidth();
        }
        if (columnHeaderWidth == -1) {
            columnHeaderWidth = columnHeaderChild.getMeasuredWidth();
        }
        if (cellWidth != 0) {
            if (columnHeaderWidth > cellWidth) {
                cellWidth = columnHeaderWidth;
            } else if (cellWidth > columnHeaderWidth) {
                columnHeaderWidth = cellWidth;
            }
            if (columnHeaderWidth != columnHeaderChild.getWidth()) {
                TableViewUtils.setWidth(columnHeaderChild, columnHeaderWidth);
                this.mNeedFitForVerticalScroll = true;
                this.mNeedFitForHorizontalScroll = true;
            }
            this.mColumnHeaderLayoutManager.setCacheWidth(column, columnHeaderWidth);
        }
        TableViewUtils.setWidth(child, cellWidth);
        this.mCellLayoutManager.setCacheWidth(row, column, cellWidth);
    }

    private boolean shouldFitColumns(int xPosition, int yPosition) {
        if (this.mNeedFitForHorizontalScroll && !this.mCellRowRecyclerView.isScrollOthers() && this.mCellLayoutManager.shouldFitColumns(yPosition)) {
            if (this.mLastDx > 0) {
                int last = this.findLastVisibleItemPosition();
                return xPosition == last;
            }
            if (this.mLastDx < 0) {
                int first = this.findFirstVisibleItemPosition();
                return xPosition == first;
            }
        }
        return false;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mColumnHeaderRecyclerView.getScrollState() == 0 && this.mCellRowRecyclerView.isScrollOthers()) {
            this.mColumnHeaderRecyclerView.scrollBy(dx, 0);
        }
        this.mLastDx = dx;
        this.setInitialPrefetchItemCount(2);
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    private int getRowPosition() {
        return this.mCellLayoutManager.getPosition((View)this.mCellRowRecyclerView);
    }

    public int getLastDx() {
        return this.mLastDx;
    }

    public boolean isNeedFit() {
        return this.mNeedFitForVerticalScroll;
    }

    public void clearNeedFit() {
        this.mNeedFitForVerticalScroll = false;
    }

    @NonNull
    public AbstractViewHolder[] getVisibleViewHolders() {
        int visibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int index = 0;
        AbstractViewHolder[] views = new AbstractViewHolder[visibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            views[index] = (AbstractViewHolder)this.mCellRowRecyclerView.findViewHolderForAdapterPosition(i);
            ++index;
        }
        return views;
    }
}

