/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import androidx.annotation.NonNull;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.AdapterDataSetChangedListener;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.filter.Filter;
import com.evrencoskun.tableview.filter.FilterChangedListener;
import com.evrencoskun.tableview.filter.FilterItem;
import com.evrencoskun.tableview.filter.FilterType;
import com.evrencoskun.tableview.filter.IFilterableModel;
import java.util.ArrayList;
import java.util.List;

public class FilterHandler<T extends IFilterableModel> {
    private final CellRecyclerViewAdapter<List<T>> mCellRecyclerViewAdapter;
    private final RowHeaderRecyclerViewAdapter<T> mRowHeaderRecyclerViewAdapter;
    private List<List<T>> originalCellDataStore;
    private List<T> originalRowDataStore;
    private List<FilterChangedListener<T>> filterChangedListeners;
    @NonNull
    private final AdapterDataSetChangedListener adapterDataSetChangedListener = new AdapterDataSetChangedListener(){

        public void onRowHeaderItemsChanged(@NonNull List rowHeaderItems) {
            FilterHandler.this.originalRowDataStore = new ArrayList(rowHeaderItems);
        }

        public void onCellItemsChanged(@NonNull List cellItems) {
            FilterHandler.this.originalCellDataStore = new ArrayList(cellItems);
        }
    };

    public FilterHandler(@NonNull ITableView tableView) {
        tableView.getAdapter().addAdapterDataSetChangedListener(this.adapterDataSetChangedListener);
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)tableView.getCellRecyclerView().getAdapter();
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)tableView.getRowHeaderRecyclerView().getAdapter();
    }

    public void filter(@NonNull Filter filter) {
        if (this.originalCellDataStore == null || this.originalRowDataStore == null) {
            return;
        }
        ArrayList<List<T>> originalCellData = new ArrayList<List<T>>(this.originalCellDataStore);
        ArrayList<Object> originalRowData = new ArrayList<T>(this.originalRowDataStore);
        ArrayList<List<T>> filteredCellList = new ArrayList();
        ArrayList<Object> filteredRowList = new ArrayList();
        if (filter.getFilterItems().isEmpty()) {
            filteredCellList = new ArrayList<List<T>>(this.originalCellDataStore);
            filteredRowList = new ArrayList<T>(this.originalRowDataStore);
            this.dispatchFilterClearedToListeners(this.originalCellDataStore, this.originalRowDataStore);
        } else {
            int x = 0;
            while (x < filter.getFilterItems().size()) {
                FilterItem filterItem = filter.getFilterItems().get(x);
                if (filterItem.getFilterType().equals((Object)FilterType.ALL)) {
                    block1: for (List list : originalCellData) {
                        for (IFilterableModel item : list) {
                            if (!item.getFilterableKeyword().toLowerCase().contains(filterItem.getFilter().toLowerCase())) continue;
                            filteredCellList.add(list);
                            filteredRowList.add(originalRowData.get(filteredCellList.indexOf(list)));
                            continue block1;
                        }
                    }
                } else {
                    for (List list : originalCellData) {
                        if (!((IFilterableModel)list.get(filterItem.getColumn())).getFilterableKeyword().toLowerCase().contains(filterItem.getFilter().toLowerCase())) continue;
                        filteredCellList.add(list);
                        filteredRowList.add(originalRowData.get(filteredCellList.indexOf(list)));
                    }
                }
                if (++x >= filter.getFilterItems().size()) continue;
                originalCellData = new ArrayList<List<T>>(filteredCellList);
                originalRowData = new ArrayList(filteredRowList);
                filteredCellList.clear();
                filteredRowList.clear();
            }
        }
        this.mRowHeaderRecyclerViewAdapter.setItems(filteredRowList, true);
        this.mCellRecyclerViewAdapter.setItems(filteredCellList, true);
        this.dispatchFilterChangedToListeners(filteredCellList, filteredRowList);
    }

    private void dispatchFilterChangedToListeners(@NonNull List<List<T>> filteredCellItems, @NonNull List<T> filteredRowHeaderItems) {
        if (this.filterChangedListeners != null) {
            for (FilterChangedListener<T> listener : this.filterChangedListeners) {
                listener.onFilterChanged(filteredCellItems, filteredRowHeaderItems);
            }
        }
    }

    private void dispatchFilterClearedToListeners(@NonNull List<List<T>> originalCellItems, @NonNull List<T> originalRowHeaderItems) {
        if (this.filterChangedListeners != null) {
            for (FilterChangedListener<T> listener : this.filterChangedListeners) {
                listener.onFilterCleared(originalCellItems, originalRowHeaderItems);
            }
        }
    }

    public void addFilterChangedListener(@NonNull FilterChangedListener<T> listener) {
        if (this.filterChangedListeners == null) {
            this.filterChangedListeners = new ArrayList<FilterChangedListener<T>>();
        }
        this.filterChangedListeners.add(listener);
    }
}

