/*
 * Decompiled with CFR 0.152.
 */
package com.github.euzee.permission;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import com.github.euzee.permission.PermissionCallback;
import com.github.euzee.permission.PermissionUtil;
import com.github.euzee.permission.R;

public class PermissionActivity
extends Activity {
    private static final String PERMISSION = "PERMISSION";

    static void contactsRead(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_CONTACTS"});
    }

    static void contactsWrite(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.WRITE_CONTACTS"});
    }

    static void contactsRW(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS"});
    }

    static void calendarRead(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_CALENDAR"});
    }

    static void calendarWrite(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.WRITE_CALENDAR"});
    }

    static void calendarRW(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR"});
    }

    static void storageRead(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
    }

    static void storageWrite(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
    }

    static void storageRW(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
    }

    static void locationFine(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.ACCESS_FINE_LOCATION"});
    }

    static void locationCoarse(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.ACCESS_COARSE_LOCATION"});
    }

    static void locationBoth(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"});
    }

    static void camera(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.CAMERA"});
    }

    static void microphone(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.RECORD_AUDIO"});
    }

    static void phoneReadState(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_PHONE_STATE"});
    }

    static void phoneCall(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.CALL_PHONE"});
    }

    static void phoneReadCallLog(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_CALL_LOG"});
    }

    static void phoneWriteCallLog(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.WRITE_CALL_LOG"});
    }

    static void phoneAddVoiceMail(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"com.android.voicemail.permission.ADD_VOICEMAIL"});
    }

    static void phoneSip(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.USE_SIP"});
    }

    static void phoneOutgoing(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.PROCESS_OUTGOING_CALLS"});
    }

    static void phoneAll(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS"});
    }

    static void sensors(Context context) {
        if (Build.VERSION.SDK_INT >= 20) {
            PermissionActivity.checkGroup(context, new String[]{"android.permission.BODY_SENSORS"});
        }
    }

    static void smsSend(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.SEND_SMS"});
    }

    static void smsReceive(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.RECEIVE_SMS"});
    }

    static void smsRead(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.READ_SMS"});
    }

    static void smsWap(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.RECEIVE_WAP_PUSH"});
    }

    static void smsMms(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.RECEIVE_MMS"});
    }

    static void smsAll(Context context) {
        PermissionActivity.checkGroup(context, new String[]{"android.permission.SEND_SMS", "android.permission.RECEIVE_SMS", "android.permission.READ_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECEIVE_WAP_PUSH"});
    }

    static void checkGroup(Context context, String[] permissions) {
        if (permissions != null && permissions.length != 0) {
            Intent intent = new Intent(context, PermissionActivity.class);
            intent.putExtra(PERMISSION, permissions);
            context.startActivity(intent);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(16);
        String[] requestedPermissions = this.getRequestedPermissions();
        if (this.checkIsEmptyPermissions(requestedPermissions)) {
            int result = this.checkPermissions(requestedPermissions);
            boolean rationale = this.checkRationale(requestedPermissions);
            if (rationale && this.isRationaleExist()) {
                this.showRationale(dialogInterface -> this.requestPermissionsIfNeeded(result, requestedPermissions));
            } else {
                this.requestPermissionsIfNeeded(result, requestedPermissions);
            }
        } else {
            this.onPermissionDenied();
        }
    }

    private boolean isRationaleExist() {
        PermissionCallback callback = PermissionUtil.getCallback();
        return callback != null && callback.getRationaleMessageId() != 0;
    }

    private void showRationale(DialogInterface.OnDismissListener listener) {
        PermissionCallback callback = PermissionUtil.getCallback();
        String title = this.getCallbackTitle(callback);
        String message = this.getCallbackMessage(callback);
        AlertDialog dialog = new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_MinWidth).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton(17039370, null).setOnDismissListener(listener).create();
        dialog.show();
    }

    private String getCallbackTitle(PermissionCallback callback) {
        return callback.getRationaleTitleId() == 0 ? "" : this.getString(callback.getRationaleTitleId());
    }

    private String getCallbackMessage(PermissionCallback callback) {
        return callback.getRationaleMessageId() == 0 ? "" : this.getString(callback.getRationaleMessageId());
    }

    private boolean checkRationale(String[] requestedPermissions) {
        boolean result = false;
        for (String permission2 : requestedPermissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission2)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String[] getRequestedPermissions() {
        return this.getIntent().getExtras() != null ? this.getIntent().getExtras().getStringArray(PERMISSION) : null;
    }

    private boolean checkIsEmptyPermissions(String[] requestedPermissions) {
        return requestedPermissions != null && requestedPermissions.length != 0;
    }

    private void requestPermissionsIfNeeded(int result, String[] requestedPermissions) {
        if (result == -1) {
            ActivityCompat.requestPermissions((Activity)this, (String[])requestedPermissions, (int)1001);
        } else {
            this.onPermissionGranted();
        }
    }

    private int checkPermissions(String[] requestedPermissions) {
        int result = 0;
        for (String permission2 : requestedPermissions) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)permission2) != -1) continue;
            result = -1;
            break;
        }
        return result;
    }

    private void onPermissionDenied() {
        if (PermissionUtil.getCallback() != null) {
            PermissionUtil.getCallback().onPermissionDenied();
        }
        this.finish();
    }

    private void onPermissionGranted() {
        if (PermissionUtil.getCallback() != null) {
            PermissionUtil.getCallback().onPermissionGranted();
        }
        this.finish();
    }

    private void onShowRationale() {
        if (PermissionUtil.getCallback() != null) {
            PermissionUtil.getCallback().getRationaleMessageId();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.handleGrantResult(this.checkGrantResults(grantResults));
    }

    private void handleGrantResult(int grantResult) {
        if (grantResult == 0) {
            this.onPermissionGranted();
        } else {
            this.onPermissionDenied();
        }
    }

    private int checkGrantResults(int[] grantResults) {
        int result = 0;
        for (int grant : grantResults) {
            if (grant != -1) continue;
            result = grant;
            break;
        }
        return result;
    }
}

