/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.rximagepicker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.esafirm.imagepicker.features.ImagePicker;
import com.esafirm.imagepicker.features.ImagePickerActivity;
import com.esafirm.imagepicker.model.Image;
import com.esafirm.rximagepicker.ShadowActivity;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class ImagePickerObservable
implements Observable.OnSubscribe<List<Image>> {
    private Context context;
    private ImagePicker imagePicker;

    public ImagePickerObservable(Context context, ImagePicker builder) {
        this.imagePicker = builder;
        this.context = context.getApplicationContext();
    }

    public void call(Subscriber<? super List<Image>> subscriber) {
        this.startImagePicker();
        subscriber.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                ImagePickerObservable.this.finishImagePicker();
            }
        }));
        subscriber.onCompleted();
    }

    private void finishImagePicker() {
        Intent intent = new Intent(this.context, ImagePickerActivity.class).addFlags(0x10000000).addFlags(32768).addFlags(65536);
        this.context.startActivity(intent);
    }

    private void startImagePicker() {
        Bundle bundle = this.imagePicker.getIntent(this.context).getExtras();
        Intent intent = ShadowActivity.getStartIntent(this.context, bundle).addFlags(0x10000000).addFlags(0x20000000);
        this.context.startActivity(intent);
    }
}

