/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.rximagepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.esafirm.imagepicker.features.ImagePicker;
import com.esafirm.imagepicker.model.Image;
import com.esafirm.rximagepicker.ShadowActivity;
import java.util.List;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class RxImagePicker {
    @SuppressLint(value={"StaticFieldLeak"})
    private static RxImagePicker INSTANCE;
    private SerializedSubject<List<Image>, List<Image>> subject = new SerializedSubject((Subject)PublishSubject.create());

    public static RxImagePicker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RxImagePicker();
        }
        return INSTANCE;
    }

    private RxImagePicker() {
    }

    public Observable<List<Image>> start(Context context, ImagePicker imagePicker) {
        this.startImagePicker(context, imagePicker);
        return this.subject;
    }

    private void startImagePicker(Context context, ImagePicker imagePicker) {
        Bundle bundle = imagePicker.getIntent(context).getExtras();
        Intent intent = ShadowActivity.getStartIntent(context, bundle).addFlags(0x10000000).addFlags(0x20000000);
        context.startActivity(intent);
    }

    void onHandleResult(List<Image> images) {
        this.subject.onNext(images);
    }
}

