/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.helper;

import android.content.Context;
import android.net.Uri;
import androidx.core.content.FileProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/esafirm/imagepicker/helper/UriUtils;", "", "()V", "uriForFile", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "imagepicker_release"})
public final class UriUtils {
    @NotNull
    public static final UriUtils INSTANCE = new UriUtils();

    private UriUtils() {
    }

    @NotNull
    public final Uri uriForFile(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Context appContext = context.getApplicationContext();
        Locale locale = Locale.ENGLISH;
        String string2 = "%s%s";
        Object[] objectArray = new Object[]{appContext.getPackageName(), ".imagepicker.provider"};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        String providerName = string3;
        Uri uri = FileProvider.getUriForFile((Context)appContext, (String)providerName, (File)file);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUriForFile(appContext, providerName, file)");
        return uri;
    }
}

