/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features.fileloader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.common.ImageLoaderListener;
import com.esafirm.imagepicker.features.fileloader.ImageFileLoader;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import com.esafirm.imagepicker.model.Folder;
import com.esafirm.imagepicker.model.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader;", "Lcom/esafirm/imagepicker/features/fileloader/ImageFileLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "abortLoadImages", "", "getExecutorService", "loadDeviceImages", "config", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "listener", "Lcom/esafirm/imagepicker/features/common/ImageLoaderListener;", "Companion", "ImageLoadRunnable", "imagepicker_release"})
public final class DefaultImageFileLoader
implements ImageFileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private ExecutorService executor;

    public DefaultImageFileLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void loadDeviceImages(@NotNull ImagePickerConfig config2, @NotNull ImageLoaderListener listener) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        boolean isFolderMode = config2.isFolderMode();
        boolean includeVideo = config2.isIncludeVideo();
        boolean onlyVideo = config2.isOnlyVideo();
        boolean includeAnimation = config2.isIncludeAnimation();
        List<File> excludedImages = config2.getExcludedImages();
        ExecutorService executorService = this.getExecutorService();
        Context context = this.context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
        executorService.execute(new ImageLoadRunnable(context, isFolderMode, onlyVideo, includeVideo, includeAnimation, excludedImages, listener));
    }

    @Override
    public void abortLoadImages() {
        ExecutorService executorService = this.executor;
        if (executorService != null) {
            executorService.shutdown();
        }
        this.executor = null;
    }

    private final ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        ExecutorService executorService = this.executor;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0003\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader$ImageLoadRunnable;", "Ljava/lang/Runnable;", "context", "Landroid/content/Context;", "isFolderMode", "", "onlyVideo", "includeVideo", "includeAnimation", "excludedImages", "", "Ljava/io/File;", "listener", "Lcom/esafirm/imagepicker/features/common/ImageLoaderListener;", "(Landroid/content/Context;ZZZZLjava/util/List;Lcom/esafirm/imagepicker/features/common/ImageLoaderListener;)V", "projection", "", "", "[Ljava/lang/String;", "cursorToImage", "Lcom/esafirm/imagepicker/model/Image;", "cursor", "Landroid/database/Cursor;", "getSourceUri", "Landroid/net/Uri;", "processData", "", "queryData", "limit", "", "(Ljava/lang/Integer;)Landroid/database/Cursor;", "run", "Companion", "imagepicker_release"})
    private static final class ImageLoadRunnable
    implements Runnable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Context context;
        private final boolean isFolderMode;
        private final boolean onlyVideo;
        private final boolean includeVideo;
        private final boolean includeAnimation;
        @Nullable
        private final List<File> excludedImages;
        @NotNull
        private final ImageLoaderListener listener;
        @NotNull
        private final String[] projection;
        @NotNull
        private static final String DEFAULT_FOLDER_NAME = "SDCARD";
        private static final int FIRST_LIMIT = 1000;
        @NotNull
        private static final String QUERY_LIMIT = "limit";

        public ImageLoadRunnable(@NotNull Context context, boolean isFolderMode, boolean onlyVideo, boolean includeVideo, boolean includeAnimation, @Nullable List<? extends File> excludedImages, @NotNull ImageLoaderListener listener) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.context = context;
            this.isFolderMode = isFolderMode;
            this.onlyVideo = onlyVideo;
            this.includeVideo = includeVideo;
            this.includeAnimation = includeAnimation;
            this.excludedImages = excludedImages;
            this.listener = listener;
            String[] stringArray = new String[]{"_id", "_display_name", "_data", "bucket_display_name"};
            this.projection = stringArray;
        }

        @SuppressLint(value={"InlinedApi"})
        private final Cursor queryData(Integer limit) {
            String selection;
            boolean useNewApi = Build.VERSION.SDK_INT >= 29;
            Uri sourceUri = limit != null && useNewApi ? this.getSourceUri().buildUpon().appendQueryParameter(QUERY_LIMIT, limit.toString()).build() : this.getSourceUri();
            String type = "media_type";
            String string2 = this.onlyVideo ? type + "=3" : (selection = this.includeVideo ? type + "=1 OR " + type + "=3" : "");
            if (useNewApi) {
                Bundle bundle;
                Bundle $this$queryData_u24lambda_u2d0 = bundle = new Bundle();
                boolean bl = false;
                String[] stringArray = new String[]{"date_modified"};
                $this$queryData_u24lambda_u2d0.putStringArray("android:query-arg-sort-columns", stringArray);
                $this$queryData_u24lambda_u2d0.putInt("android:query-arg-sort-direction", 1);
                $this$queryData_u24lambda_u2d0.putString("android:query-arg-sql-selection", selection);
                if (limit != null) {
                    $this$queryData_u24lambda_u2d0.putInt("android:query-arg-limit", limit.intValue());
                }
                Bundle args = bundle;
                return this.context.getContentResolver().query(sourceUri, this.projection, args, null);
            }
            String it = "date_modified DESC";
            boolean bl = false;
            String sortOrder = limit != null ? it + " LIMIT " + limit : it;
            return this.context.getContentResolver().query(sourceUri, this.projection, selection, null, sortOrder);
        }

        static /* synthetic */ Cursor queryData$default(ImageLoadRunnable imageLoadRunnable, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            return imageLoadRunnable.queryData(n);
        }

        private final Uri getSourceUri() {
            Uri uri;
            if (this.onlyVideo || this.includeVideo) {
                Uri uri2 = MediaStore.Files.getContentUri((String)"external");
                uri = uri2;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                MediaS\u2026\"external\")\n            }");
            } else {
                Uri uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                uri = uri3;
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
            }
            return uri;
        }

        private final Image cursorToImage(Cursor cursor) {
            String path = cursor.getString(cursor.getColumnIndex(this.projection[2]));
            File file = Companion.makeSafeFile(path);
            if (file == null) {
                return null;
            }
            File file2 = file;
            if (this.excludedImages != null && this.excludedImages.contains(file2)) {
                return null;
            }
            if (!this.includeAnimation) {
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                if (ImagePickerUtils.INSTANCE.isGifFormat(path)) {
                    return null;
                }
            }
            long id2 = cursor.getLong(cursor.getColumnIndex(this.projection[0]));
            String name = cursor.getString(cursor.getColumnIndex(this.projection[1]));
            if (name != null) {
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                return new Image(id2, name, path);
            }
            return null;
        }

        private final void processData(Cursor cursor) {
            if (cursor == null) {
                this.listener.onFailed(new NullPointerException());
                return;
            }
            List result = new ArrayList();
            Map folderMap = new LinkedHashMap();
            if (cursor.moveToFirst()) {
                do {
                    Image image;
                    if ((image = this.cursorToImage(cursor)) == null) continue;
                    result.add(image);
                    if (!this.isFolderMode) continue;
                    String bucket = cursor.getString(cursor.getColumnIndex(this.projection[3]));
                    if (bucket == null) {
                        File parent;
                        File file = parent = new File(image.getPath()).getParentFile();
                        String string2 = bucket = file != null ? file.getName() : DEFAULT_FOLDER_NAME;
                    }
                    if (bucket == null) continue;
                    Folder folder = (Folder)folderMap.get(bucket);
                    if (folder == null) {
                        folder = new Folder(bucket);
                        Map map = folderMap;
                        map.put(bucket, folder);
                    }
                    folder.getImages().add(image);
                } while (cursor.moveToNext());
            }
            cursor.close();
            List folders = CollectionsKt.toList((Iterable)folderMap.values());
            this.listener.onImageLoaded(result, folders);
        }

        @Override
        public void run() {
            Cursor cursor;
            Cursor cursor2 = cursor = this.queryData(1000);
            boolean isLoadDataAgain = cursor2 != null ? cursor2.getCount() == 1000 : false;
            this.processData(cursor);
            if (isLoadDataAgain) {
                this.processData(ImageLoadRunnable.queryData$default(this, null, 1, null));
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader$ImageLoadRunnable$Companion;", "", "()V", "DEFAULT_FOLDER_NAME", "", "FIRST_LIMIT", "", "QUERY_LIMIT", "imagepicker_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/esafirm/imagepicker/features/fileloader/DefaultImageFileLoader$Companion;", "", "()V", "makeSafeFile", "Ljava/io/File;", "path", "", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        private final File makeSafeFile(String path) {
            File file;
            if (path == null || ((CharSequence)path).length() == 0) {
                file = null;
            } else {
                File file2;
                try {
                    file2 = new File(path);
                }
                catch (Exception ignored) {
                    file2 = null;
                }
                file = file2;
            }
            return file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

