/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features.camera;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.esafirm.imagepicker.features.camera.CameraModule;
import com.esafirm.imagepicker.features.common.BaseConfig;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import com.esafirm.imagepicker.helper.IpLogger;
import com.esafirm.imagepicker.helper.UriUtils;
import com.esafirm.imagepicker.model.Image;
import com.esafirm.imagepicker.model.ImageFactory;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u001e\u0010\u0014\u001a\u001a\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00120\u0015j\u0002`\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/esafirm/imagepicker/features/camera/DefaultCameraModule;", "Lcom/esafirm/imagepicker/features/camera/CameraModule;", "()V", "currentImagePath", "", "currentUri", "createCameraUri", "Landroid/net/Uri;", "appContext", "Landroid/content/Context;", "imageFile", "Ljava/io/File;", "getCameraIntent", "Landroid/content/Intent;", "context", "config", "Lcom/esafirm/imagepicker/features/common/BaseConfig;", "getImage", "", "intent", "imageReadyListener", "Lkotlin/Function1;", "", "Lcom/esafirm/imagepicker/model/Image;", "Lcom/esafirm/imagepicker/features/camera/OnImageReadyListener;", "prepareForNewIntent", "removeImage", "imagepicker_release"})
public final class DefaultCameraModule
implements CameraModule {
    @Nullable
    private String currentImagePath;
    @Nullable
    private String currentUri;

    @Override
    @Nullable
    public Intent getCameraIntent(@NotNull Context context, @NotNull BaseConfig config2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.prepareForNewIntent();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File imageFile = ImagePickerUtils.INSTANCE.createImageFile(config2.getSavePath(), context);
        if (config2.isSaveImage() && imageFile != null) {
            Context appContext = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)appContext, (String)"appContext");
            Uri uri = this.createCameraUri(appContext, imageFile);
            intent.putExtra("output", (Parcelable)uri);
            ImagePickerUtils.INSTANCE.grantAppPermission(context, intent, uri);
            this.currentUri = String.valueOf(uri);
        }
        return intent;
    }

    private final void prepareForNewIntent() {
        this.currentImagePath = null;
        this.currentUri = null;
    }

    private final Uri createCameraUri(Context appContext, File imageFile) {
        this.currentImagePath = "file:" + imageFile.getAbsolutePath();
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues contentValues;
            ContentValues $this$createCameraUri_u24lambda_u2d0 = contentValues = new ContentValues();
            boolean bl = false;
            $this$createCameraUri_u24lambda_u2d0.put("_display_name", imageFile.getName());
            $this$createCameraUri_u24lambda_u2d0.put("mime_type", "image/jpeg");
            ContentValues values = contentValues;
            Uri collection = MediaStore.Images.Media.getContentUri((String)"external_primary");
            return appContext.getContentResolver().insert(collection, values);
        }
        return UriUtils.INSTANCE.uriForFile(appContext, imageFile);
    }

    @Override
    public void getImage(@NotNull Context context, @Nullable Intent intent, @NotNull Function1<? super List<Image>, Unit> imageReadyListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(imageReadyListener, (String)"imageReadyListener");
        if (this.currentImagePath == null) {
            IpLogger.INSTANCE.w("currentImagePath null. This happen if you haven't call #getCameraIntent() or the activity is being recreated");
            imageReadyListener.invoke(null);
            return;
        }
        Uri imageUri = Uri.parse((String)this.currentImagePath);
        if (imageUri != null) {
            String[] stringArray = new String[]{imageUri.getPath()};
            MediaScannerConnection.scanFile((Context)context.getApplicationContext(), (String[])stringArray, null, (arg_0, arg_1) -> DefaultCameraModule.getImage$lambda-1(this, imageReadyListener, context, imageUri, arg_0, arg_1));
        }
    }

    @Override
    public void removeImage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.currentImagePath;
        if (string2 == null) {
            return;
        }
        String imagePath = string2;
        File file = new File(imagePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            Uri uri;
            String string3 = this.currentUri;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                uri = Uri.parse((String)it);
            } else {
                uri = null;
            }
            if (uri == null) {
                return;
            }
            Uri uri2 = uri;
            context.getApplicationContext().getContentResolver().delete(uri2, null, null);
        }
        catch (Exception e) {
            IpLogger.INSTANCE.e("Can't delete cancelled uri");
            e.printStackTrace();
        }
    }

    private static final void getImage$lambda-1(DefaultCameraModule this$0, Function1 $imageReadyListener, Context $context, Uri $imageUri, String path, Uri uri) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$imageReadyListener, (String)"$imageReadyListener");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        IpLogger.INSTANCE.d("File " + path + " was scanned successfully: " + uri);
        if (path == null) {
            IpLogger.INSTANCE.d("This should not happen, go back to Immediate implementation");
        }
        if (uri == null) {
            IpLogger.INSTANCE.d("scanFile is failed. Uri is null");
        }
        if ((string2 = path) == null) {
            String string3 = this$0.currentImagePath;
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        String finalPath = string2;
        Uri uri2 = uri;
        if (uri2 == null) {
            uri2 = Uri.parse((String)this$0.currentUri);
        }
        Uri finalUri = uri2;
        Intrinsics.checkNotNullExpressionValue((Object)finalUri, (String)"finalUri");
        $imageReadyListener.invoke(ImageFactory.singleImage(finalUri, finalPath));
        ImagePickerUtils.INSTANCE.revokeAppPermission($context, $imageUri);
    }
}

