/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.features;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.databinding.EfFragmentImagePickerBinding;
import com.esafirm.imagepicker.features.ContentObserverTrigger;
import com.esafirm.imagepicker.features.ImagePickerConfig;
import com.esafirm.imagepicker.features.ImagePickerInteractionListener;
import com.esafirm.imagepicker.features.ImagePickerPresenter;
import com.esafirm.imagepicker.features.ImagePickerState;
import com.esafirm.imagepicker.features.camera.CameraHelper;
import com.esafirm.imagepicker.features.fileloader.DefaultImageFileLoader;
import com.esafirm.imagepicker.features.recyclers.RecyclerViewManager;
import com.esafirm.imagepicker.helper.ConfigUtils;
import com.esafirm.imagepicker.helper.ImagePickerPreferences;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import com.esafirm.imagepicker.helper.IpLogger;
import com.esafirm.imagepicker.helper.state.SingleEvent;
import com.esafirm.imagepicker.model.Folder;
import com.esafirm.imagepicker.model.Image;
import com.esafirm.imagepicker.view.SnackBarView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010 \u001a\u00020!J.\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010(\u001a\u00020\u000eJ\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002J\"\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0016J\u0012\u00107\u001a\u00020!2\b\u00108\u001a\u0004\u0018\u000109H\u0016J&\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010@\u001a\u00020!H\u0016J\b\u0010A\u001a\u00020!H\u0016J\u0006\u0010B\u001a\u00020!J\b\u0010C\u001a\u00020!H\u0016J\u0010\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u000209H\u0016J\u001a\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020;2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010H\u001a\u00020!H\u0002J\b\u0010I\u001a\u00020!H\u0002J\u0016\u0010J\u001a\u00020!2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020L0&H\u0002J\u0016\u0010M\u001a\u00020!2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u000e\u0010O\u001a\u00020!2\u0006\u0010P\u001a\u00020\fJ\b\u0010Q\u001a\u00020!H\u0002J\u0012\u0010R\u001a\u00020!2\b\u0010S\u001a\u0004\u0018\u00010TH\u0002J\u0010\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020\u000eH\u0002J\b\u0010W\u001a\u00020!H\u0002J\b\u0010X\u001a\u00020!H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\n\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00110\u00110\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/esafirm/imagepicker/features/ImagePickerFragment;", "Landroidx/fragment/app/Fragment;", "()V", "binding", "Lcom/esafirm/imagepicker/databinding/EfFragmentImagePickerBinding;", "config", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "getConfig", "()Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "config$delegate", "Lkotlin/Lazy;", "interactionListener", "Lcom/esafirm/imagepicker/features/ImagePickerInteractionListener;", "isShowDoneButton", "", "()Z", "permission", "", "getPermission", "()Ljava/lang/String;", "preferences", "Lcom/esafirm/imagepicker/helper/ImagePickerPreferences;", "getPreferences", "()Lcom/esafirm/imagepicker/helper/ImagePickerPreferences;", "preferences$delegate", "presenter", "Lcom/esafirm/imagepicker/features/ImagePickerPresenter;", "recyclerViewManager", "Lcom/esafirm/imagepicker/features/recyclers/RecyclerViewManager;", "requestPermissionLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "kotlin.jvm.PlatformType", "captureImage", "", "createRecyclerViewManager", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "passedSelectedImages", "", "Lcom/esafirm/imagepicker/model/Image;", "handleBack", "loadData", "loadDataWithPermission", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onAttach", "context", "Landroid/content/Context;", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onDestroyView", "onDone", "onResume", "onSaveInstanceState", "outState", "onViewCreated", "view", "openAppSettings", "requestWriteExternalOrReadImagesPermission", "setFolderAdapter", "folders", "Lcom/esafirm/imagepicker/model/Folder;", "setImageAdapter", "images", "setInteractionListener", "listener", "showEmpty", "showError", "throwable", "", "showLoading", "isLoading", "subscribeToUiState", "updateTitle", "Companion", "imagepicker_release"})
public final class ImagePickerFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EfFragmentImagePickerBinding binding;
    private RecyclerViewManager recyclerViewManager;
    @NotNull
    private final Lazy preferences$delegate;
    @NotNull
    private final Lazy config$delegate;
    @NotNull
    private final ActivityResultLauncher<String> requestPermissionLauncher;
    private ImagePickerPresenter presenter;
    private ImagePickerInteractionListener interactionListener;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    @NotNull
    private static final String STATE_KEY_RECYCLER = "Key.Recycler";
    @NotNull
    private static final String STATE_KEY_SELECTED_IMAGES = "Key.SelectedImages";
    private static final int RC_CAPTURE = 2000;

    public ImagePickerFragment() {
        this.preferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImagePickerPreferences>(this){
            final /* synthetic */ ImagePickerFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ImagePickerPreferences invoke() {
                Context context = this.this$0.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                return new ImagePickerPreferences(context);
            }
        }));
        this.config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImagePickerConfig>(this){
            final /* synthetic */ ImagePickerFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ImagePickerConfig invoke() {
                Parcelable parcelable = this.this$0.requireArguments().getParcelable(ImagePickerConfig.class.getSimpleName());
                Intrinsics.checkNotNull((Object)parcelable);
                return (ImagePickerConfig)parcelable;
            }
        }));
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> ImagePickerFragment.requestPermissionLauncher$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.requestPermissionLauncher = activityResultLauncher;
    }

    private final ImagePickerPreferences getPreferences() {
        Lazy lazy = this.preferences$delegate;
        return (ImagePickerPreferences)lazy.getValue();
    }

    private final ImagePickerConfig getConfig() {
        Lazy lazy = this.config$delegate;
        return (ImagePickerConfig)lazy.getValue();
    }

    private final String getPermission() {
        return Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.WRITE_EXTERNAL_STORAGE";
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Lifecycle lifecycle = this.getLifecycle();
        ContentResolver contentResolver = this.requireActivity().getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"requireActivity().contentResolver");
        lifecycle.addObserver((LifecycleObserver)new ContentObserverTrigger(contentResolver, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ImagePickerFragment.access$loadData((ImagePickerFragment)((Object)this.receiver));
            }
        })));
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        this.presenter = new ImagePickerPresenter(new DefaultImageFileLoader(context));
        if (this.interactionListener == null) {
            throw new RuntimeException("ImagePickerFragment needs an ImagePickerInteractionListener. This will be set automatically if the activity implements ImagePickerInteractionListener, and can be set manually with fragment.setInteractionListener(listener).");
        }
        ImagePickerInteractionListener imagePickerInteractionListener = this.interactionListener;
        if (imagePickerInteractionListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interactionListener");
            imagePickerInteractionListener = null;
        }
        ImagePickerInteractionListener interactionListener = imagePickerInteractionListener;
        LayoutInflater localInflater = inflater.cloneInContext((Context)new ContextThemeWrapper((Context)this.getActivity(), this.getConfig().getTheme()));
        View view = localInflater.inflate(R.layout.ef_fragment_image_picker, container, false);
        EfFragmentImagePickerBinding efFragmentImagePickerBinding = EfFragmentImagePickerBinding.bind(view);
        Intrinsics.checkNotNullExpressionValue((Object)efFragmentImagePickerBinding, (String)"bind(view)");
        EfFragmentImagePickerBinding viewBinding = efFragmentImagePickerBinding;
        List selectedImages = savedInstanceState == null ? this.getConfig().getSelectedImages() : (List)savedInstanceState.getParcelableArrayList(STATE_KEY_SELECTED_IMAGES);
        RecyclerView recyclerView = viewBinding.recyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"viewBinding.recyclerView");
        ImagePickerConfig imagePickerConfig = this.getConfig();
        List list = selectedImages;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        RecyclerViewManager recyclerViewManager = this.createRecyclerViewManager(recyclerView, imagePickerConfig, list, interactionListener);
        if (savedInstanceState != null) {
            recyclerViewManager.onRestoreState(savedInstanceState.getParcelable(STATE_KEY_RECYCLER));
        }
        interactionListener.selectionChanged(recyclerViewManager.getSelectedImages());
        this.binding = viewBinding;
        this.recyclerViewManager = recyclerViewManager;
        return view;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.subscribeToUiState();
    }

    private final void subscribeToUiState() {
        ImagePickerPresenter imagePickerPresenter = this.presenter;
        if (imagePickerPresenter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            imagePickerPresenter = null;
        }
        imagePickerPresenter.getUiState().observe((LifecycleOwner)this, (Function1<ImagePickerState, Unit>)((Function1)new Function1<ImagePickerState, Unit>(this){
            final /* synthetic */ ImagePickerFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ImagePickerState state) {
                Object value$iv;
                SingleEvent<List<Image>> $this$fetch$iv;
                T value$iv2;
                void $this$fetch$iv2;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                ImagePickerFragment.access$showLoading(this.this$0, state.isLoading());
                SingleEvent<Throwable> singleEvent = state.getError();
                Object object = this.this$0;
                boolean $i$f$fetch = false;
                void v0 = $this$fetch$iv2;
                Object object2 = value$iv2 = v0 != null ? v0.get() : null;
                if (value$iv2 != null) {
                    Throwable $this$invoke_u24lambda_u2d0 = (Throwable)value$iv2;
                    boolean bl = false;
                    ImagePickerFragment.access$showError(object, $this$invoke_u24lambda_u2d0);
                }
                boolean isEmpty = state.getImages().isEmpty();
                if (isEmpty && !state.isLoading()) {
                    ImagePickerFragment.access$showEmpty(this.this$0);
                    return;
                }
                object = state.isFolder();
                ImagePickerFragment imagePickerFragment = this.this$0;
                boolean $i$f$fetch2 = false;
                void v2 = $this$fetch$iv;
                Object object3 = value$iv = v2 != null ? v2.get() : null;
                if (value$iv != null) {
                    boolean $this$invoke_u24lambda_u2d1 = (Boolean)value$iv;
                    boolean bl = false;
                    boolean isFolderMode = $this$invoke_u24lambda_u2d1;
                    if (isFolderMode) {
                        ImagePickerFragment.access$setFolderAdapter(imagePickerFragment, state.getFolders());
                    } else {
                        ImagePickerFragment.access$setImageAdapter(imagePickerFragment, state.getImages());
                    }
                }
                $this$fetch$iv = state.getFinishPickImage();
                imagePickerFragment = this.this$0;
                $i$f$fetch2 = false;
                SingleEvent<List<Image>> singleEvent2 = $this$fetch$iv;
                List<Image> list = value$iv = singleEvent2 != null ? singleEvent2.get() : null;
                if (value$iv != null) {
                    List $this$invoke_u24lambda_u2d2 = (List)value$iv;
                    boolean bl = false;
                    List images = $this$invoke_u24lambda_u2d2;
                    ImagePickerInteractionListener imagePickerInteractionListener = ImagePickerFragment.access$getInteractionListener$p(imagePickerFragment);
                    if (imagePickerInteractionListener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"interactionListener");
                        imagePickerInteractionListener = null;
                    }
                    imagePickerInteractionListener.finishPickImages(ImagePickerUtils.INSTANCE.createResultIntent(images));
                }
                $this$fetch$iv = state.getShowCapturedImage();
                imagePickerFragment = this.this$0;
                $i$f$fetch2 = false;
                SingleEvent<List<Image>> singleEvent3 = $this$fetch$iv;
                List<Image> list2 = value$iv = singleEvent3 != null ? singleEvent3.get() : null;
                if (value$iv != null) {
                    Unit $this$invoke_u24lambda_u2d3 = (Unit)value$iv;
                    boolean bl = false;
                    ImagePickerFragment.access$loadDataWithPermission(imagePickerFragment);
                }
            }
        }));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.binding = null;
        this._$_clearFindViewByIdCache();
    }

    private final RecyclerViewManager createRecyclerViewManager(RecyclerView recyclerView, ImagePickerConfig config2, List<Image> passedSelectedImages, ImagePickerInteractionListener interactionListener) {
        RecyclerViewManager recyclerViewManager;
        RecyclerViewManager $this$createRecyclerViewManager_u24lambda_u2d1 = recyclerViewManager = new RecyclerViewManager(recyclerView, config2, this.getResources().getConfiguration().orientation);
        boolean bl = false;
        Function1 selectListener2 = (Function1)new Function1<Boolean, Boolean>($this$createRecyclerViewManager_u24lambda_u2d1){
            final /* synthetic */ RecyclerViewManager $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(boolean isSelected) {
                return this.$this_apply.selectImage(isSelected);
            }
        };
        Function1 folderClick2 = (Function1)new Function1<Folder, Unit>($this$createRecyclerViewManager_u24lambda_u2d1, this){
            final /* synthetic */ RecyclerViewManager $this_apply;
            final /* synthetic */ ImagePickerFragment this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Folder bucket) {
                Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
                this.$this_apply.setImageAdapter(bucket.getImages());
                ImagePickerFragment.access$updateTitle(this.this$0);
            }
        };
        $this$createRecyclerViewManager_u24lambda_u2d1.setupAdapters(passedSelectedImages, (Function1<? super Boolean, Boolean>)selectListener2, (Function1<? super Folder, Unit>)folderClick2);
        $this$createRecyclerViewManager_u24lambda_u2d1.setImageSelectedListener((Function1<? super List<Image>, Unit>)((Function1)new Function1<List<? extends Image>, Unit>(this, interactionListener, config2){
            final /* synthetic */ ImagePickerFragment this$0;
            final /* synthetic */ ImagePickerInteractionListener $interactionListener;
            final /* synthetic */ ImagePickerConfig $config;
            {
                this.this$0 = $receiver;
                this.$interactionListener = $interactionListener;
                this.$config = $config;
                super(1);
            }

            public final void invoke(@NotNull List<Image> selectedImages) {
                Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
                ImagePickerFragment.access$updateTitle(this.this$0);
                this.$interactionListener.selectionChanged(selectedImages);
                if (ConfigUtils.INSTANCE.shouldReturn(this.$config, false) && !((Collection)selectedImages).isEmpty()) {
                    this.this$0.onDone();
                }
            }
        }));
        return recyclerViewManager;
    }

    public void onResume() {
        super.onResume();
        this.loadDataWithPermission();
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        outState.putParcelable(STATE_KEY_RECYCLER, recyclerViewManager.getRecyclerState());
        RecyclerViewManager recyclerViewManager2 = this.recyclerViewManager;
        if (recyclerViewManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager2 = null;
        }
        outState.putParcelableArrayList(STATE_KEY_SELECTED_IMAGES, (ArrayList)recyclerViewManager2.getSelectedImages());
    }

    private final void setImageAdapter(List<Image> images) {
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        recyclerViewManager.setImageAdapter(images);
        this.updateTitle();
    }

    private final void setFolderAdapter(List<Folder> folders) {
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        recyclerViewManager.setFolderAdapter(folders);
        this.updateTitle();
    }

    private final void updateTitle() {
        RecyclerViewManager recyclerViewManager;
        ImagePickerInteractionListener imagePickerInteractionListener = this.interactionListener;
        if (imagePickerInteractionListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interactionListener");
            imagePickerInteractionListener = null;
        }
        if ((recyclerViewManager = this.recyclerViewManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        imagePickerInteractionListener.setTitle(recyclerViewManager.getTitle());
    }

    public final void onDone() {
        RecyclerViewManager recyclerViewManager;
        ImagePickerPresenter imagePickerPresenter = this.presenter;
        if (imagePickerPresenter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            imagePickerPresenter = null;
        }
        if ((recyclerViewManager = this.recyclerViewManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        imagePickerPresenter.onDoneSelectImages(recyclerViewManager.getSelectedImages(), this.getConfig());
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        recyclerViewManager.changeOrientation(newConfig.orientation);
    }

    private final void loadDataWithPermission() {
        int rc = ActivityCompat.checkSelfPermission((Context)this.requireContext(), (String)this.getPermission());
        if (rc == 0) {
            this.loadData();
        } else {
            this.requestWriteExternalOrReadImagesPermission();
        }
    }

    private final void loadData() {
        ImagePickerPresenter imagePickerPresenter = this.presenter;
        if (imagePickerPresenter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            imagePickerPresenter = null;
        }
        imagePickerPresenter.loadData(this.getConfig());
    }

    private final void requestWriteExternalOrReadImagesPermission() {
        block1: {
            block2: {
                block0: {
                    IpLogger.INSTANCE.w("Write External permission or Read Media Images is not granted. Requesting permission");
                    if (!this.shouldShowRequestPermissionRationale(this.getPermission())) break block0;
                    this.requestPermissionLauncher.launch((Object)this.getPermission());
                    break block1;
                }
                if (this.getPreferences().isPermissionRequested()) break block2;
                this.getPreferences().setPermissionIsRequested();
                this.requestPermissionLauncher.launch((Object)this.getPermission());
                break block1;
            }
            Object object = this.binding;
            if (object == null || (object = ((EfFragmentImagePickerBinding)object).efSnackbar) == null) break block1;
            ((SnackBarView)((Object)object)).show(R.string.ef_msg_no_write_external_permission, arg_0 -> ImagePickerFragment.requestWriteExternalOrReadImagesPermission$lambda-2(this, arg_0));
        }
    }

    private final void openAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)this.requireActivity().getPackageName(), null));
        intent.addFlags(0x10000000);
        this.startActivity(intent);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2000) {
            switch (resultCode) {
                case -1: {
                    ImagePickerPresenter imagePickerPresenter = this.presenter;
                    if (imagePickerPresenter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
                        imagePickerPresenter = null;
                    }
                    Context context = this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    imagePickerPresenter.finishCaptureImage(context, data, this.getConfig());
                    break;
                }
                case 0: {
                    ImagePickerPresenter imagePickerPresenter = this.presenter;
                    if (imagePickerPresenter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
                        imagePickerPresenter = null;
                    }
                    Context context = this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    imagePickerPresenter.abortCaptureImage(context);
                }
            }
        }
    }

    public final void captureImage() {
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        if (!CameraHelper.INSTANCE.checkCameraAvailability((Context)fragmentActivity)) {
            return;
        }
        ImagePickerPresenter imagePickerPresenter = this.presenter;
        if (imagePickerPresenter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            imagePickerPresenter = null;
        }
        imagePickerPresenter.captureImage(this, this.getConfig(), 2000);
    }

    public void onDestroy() {
        super.onDestroy();
        ImagePickerPresenter imagePickerPresenter = this.presenter;
        if (imagePickerPresenter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presenter");
            imagePickerPresenter = null;
        }
        imagePickerPresenter.abortLoad();
    }

    public final boolean handleBack() {
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        if (recyclerViewManager.handleBack()) {
            this.updateTitle();
            return true;
        }
        return false;
    }

    public final boolean isShowDoneButton() {
        RecyclerViewManager recyclerViewManager = this.recyclerViewManager;
        if (recyclerViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerViewManager");
            recyclerViewManager = null;
        }
        return recyclerViewManager.isShowDoneButton();
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        if (context instanceof ImagePickerInteractionListener) {
            this.setInteractionListener((ImagePickerInteractionListener)context);
        }
    }

    public final void setInteractionListener(@NotNull ImagePickerInteractionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.interactionListener = listener;
    }

    private final void showError(Throwable throwable) {
        String message = "Unknown Error";
        if (throwable instanceof NullPointerException) {
            message = "Images do not exist";
        }
        Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)message, (int)0).show();
    }

    private final void showLoading(boolean isLoading) {
        block0: {
            EfFragmentImagePickerBinding efFragmentImagePickerBinding = this.binding;
            if (efFragmentImagePickerBinding == null) break block0;
            EfFragmentImagePickerBinding $this$showLoading_u24lambda_u2d3 = efFragmentImagePickerBinding;
            boolean bl = false;
            $this$showLoading_u24lambda_u2d3.progressBar.setVisibility(isLoading ? 0 : 8);
            $this$showLoading_u24lambda_u2d3.recyclerView.setVisibility(isLoading ? 8 : 0);
            $this$showLoading_u24lambda_u2d3.tvEmptyImages.setVisibility(8);
        }
    }

    private final void showEmpty() {
        block0: {
            EfFragmentImagePickerBinding efFragmentImagePickerBinding = this.binding;
            if (efFragmentImagePickerBinding == null) break block0;
            EfFragmentImagePickerBinding $this$showEmpty_u24lambda_u2d4 = efFragmentImagePickerBinding;
            boolean bl = false;
            $this$showEmpty_u24lambda_u2d4.progressBar.setVisibility(8);
            $this$showEmpty_u24lambda_u2d4.recyclerView.setVisibility(8);
            $this$showEmpty_u24lambda_u2d4.tvEmptyImages.setVisibility(0);
        }
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2;
            View view3 = this.getView();
            if (view3 != null && (view2 = view3.findViewById(id2)) != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void requestPermissionLauncher$lambda-0(ImagePickerFragment this$0, Boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isGranted, (String)"isGranted");
        if (isGranted.booleanValue()) {
            IpLogger.INSTANCE.d("Write External permission granted");
            this$0.loadData();
        } else {
            IpLogger.INSTANCE.e("Permission not granted");
            ImagePickerInteractionListener imagePickerInteractionListener = this$0.interactionListener;
            if (imagePickerInteractionListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"interactionListener");
                imagePickerInteractionListener = null;
            }
            imagePickerInteractionListener.cancel();
        }
    }

    private static final void requestWriteExternalOrReadImagesPermission$lambda-2(ImagePickerFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openAppSettings();
    }

    public static final /* synthetic */ void access$loadData(ImagePickerFragment $this) {
        $this.loadData();
    }

    public static final /* synthetic */ void access$showLoading(ImagePickerFragment $this, boolean isLoading) {
        $this.showLoading(isLoading);
    }

    public static final /* synthetic */ void access$showEmpty(ImagePickerFragment $this) {
        $this.showEmpty();
    }

    public static final /* synthetic */ void access$showError(ImagePickerFragment $this, Throwable throwable) {
        $this.showError(throwable);
    }

    public static final /* synthetic */ void access$setFolderAdapter(ImagePickerFragment $this, List folders) {
        $this.setFolderAdapter(folders);
    }

    public static final /* synthetic */ void access$setImageAdapter(ImagePickerFragment $this, List images) {
        $this.setImageAdapter(images);
    }

    public static final /* synthetic */ ImagePickerInteractionListener access$getInteractionListener$p(ImagePickerFragment $this) {
        return $this.interactionListener;
    }

    public static final /* synthetic */ void access$loadDataWithPermission(ImagePickerFragment $this) {
        $this.loadDataWithPermission();
    }

    public static final /* synthetic */ void access$updateTitle(ImagePickerFragment $this) {
        $this.updateTitle();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/esafirm/imagepicker/features/ImagePickerFragment$Companion;", "", "()V", "RC_CAPTURE", "", "STATE_KEY_RECYCLER", "", "STATE_KEY_SELECTED_IMAGES", "newInstance", "Lcom/esafirm/imagepicker/features/ImagePickerFragment;", "config", "Lcom/esafirm/imagepicker/features/ImagePickerConfig;", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImagePickerFragment newInstance(@NotNull ImagePickerConfig config2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Bundle $this$newInstance_u24lambda_u2d0 = object = new Bundle();
            boolean bl = false;
            $this$newInstance_u24lambda_u2d0.putParcelable(ImagePickerConfig.class.getSimpleName(), (Parcelable)config2);
            Bundle args = object;
            Object $this$newInstance_u24lambda_u2d1 = object = new ImagePickerFragment();
            boolean bl2 = false;
            $this$newInstance_u24lambda_u2d1.setArguments(args);
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

