/*
 * Decompiled with CFR 0.152.
 */
package com.esafirm.imagepicker.adapter;

import android.content.Context;
import android.net.Uri;
import android.provider.MediaStore;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.AsyncListDiffer;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.esafirm.imagepicker.R;
import com.esafirm.imagepicker.adapter.BaseListAdapter;
import com.esafirm.imagepicker.features.imageloader.ImageLoader;
import com.esafirm.imagepicker.features.imageloader.ImageType;
import com.esafirm.imagepicker.helper.ImagePickerUtils;
import com.esafirm.imagepicker.helper.diff.SimpleDiffUtilCallBack;
import com.esafirm.imagepicker.model.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00014B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\"H\u0016J\u0006\u0010/\u001a\u00020\u0010J\u0018\u00100\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u00101\u001a\u00020\u00102\f\u00102\u001a\b\u0012\u0004\u0012\u00020\t0\bJ(\u00103\u001a\u00020\u00102 \u0010\u000f\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000bj\u0004\u0018\u0001`\u0011R(\u0010\u000f\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000bj\u0004\u0018\u0001`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/esafirm/imagepicker/adapter/ImagePickerAdapter;", "Lcom/esafirm/imagepicker/adapter/BaseListAdapter;", "Lcom/esafirm/imagepicker/adapter/ImagePickerAdapter$ImageViewHolder;", "context", "Landroid/content/Context;", "imageLoader", "Lcom/esafirm/imagepicker/features/imageloader/ImageLoader;", "selectedImages", "", "Lcom/esafirm/imagepicker/model/Image;", "itemClickListener", "Lkotlin/Function1;", "", "Lcom/esafirm/imagepicker/listeners/OnImageClickListener;", "(Landroid/content/Context;Lcom/esafirm/imagepicker/features/imageloader/ImageLoader;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "imageSelectedListener", "", "Lcom/esafirm/imagepicker/listeners/OnImageSelectedListener;", "listDiffer", "Landroidx/recyclerview/widget/AsyncListDiffer;", "getListDiffer", "()Landroidx/recyclerview/widget/AsyncListDiffer;", "listDiffer$delegate", "Lkotlin/Lazy;", "", "getSelectedImages", "()Ljava/util/List;", "videoDurationHolder", "Ljava/util/HashMap;", "", "", "addSelected", "image", "position", "", "getItem", "getItemCount", "isSelected", "mutateSelection", "runnable", "Ljava/lang/Runnable;", "onBindViewHolder", "viewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "removeAllSelectedSingleClick", "removeSelectedImage", "setData", "images", "setImageSelectedListener", "ImageViewHolder", "imagepicker_release"})
public final class ImagePickerAdapter
extends BaseListAdapter<ImageViewHolder> {
    @NotNull
    private final Function1<Boolean, Boolean> itemClickListener;
    @NotNull
    private final Lazy listDiffer$delegate;
    @NotNull
    private final List<Image> selectedImages;
    @Nullable
    private Function1<? super List<Image>, Unit> imageSelectedListener;
    @NotNull
    private final HashMap<Long, String> videoDurationHolder;

    public ImagePickerAdapter(@NotNull Context context, @NotNull ImageLoader imageLoader2, @NotNull List<Image> selectedImages, @NotNull Function1<? super Boolean, Boolean> itemClickListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageLoader2, (String)"imageLoader");
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        Intrinsics.checkNotNullParameter(itemClickListener, (String)"itemClickListener");
        super(context, imageLoader2);
        this.itemClickListener = itemClickListener;
        this.listDiffer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AsyncListDiffer<Image>>(this){
            final /* synthetic */ ImagePickerAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AsyncListDiffer<Image> invoke() {
                return new AsyncListDiffer((RecyclerView.Adapter)this.this$0, (DiffUtil.ItemCallback)new SimpleDiffUtilCallBack<T>(null, null, 3, null));
            }
        }));
        this.selectedImages = new ArrayList();
        this.videoDurationHolder = new HashMap();
        if (!((Collection)selectedImages).isEmpty()) {
            this.selectedImages.addAll((Collection<Image>)selectedImages);
        }
    }

    private final AsyncListDiffer<Image> getListDiffer() {
        Lazy lazy = this.listDiffer$delegate;
        return (AsyncListDiffer)lazy.getValue();
    }

    @NotNull
    public final List<Image> getSelectedImages() {
        return this.selectedImages;
    }

    @NotNull
    public ImageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View layout2 = this.getInflater().inflate(R.layout.ef_imagepicker_item_image, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)layout2, (String)"layout");
        return new ImageViewHolder(layout2);
    }

    public void onBindViewHolder(@NotNull ImageViewHolder viewHolder, int position) {
        ImageViewHolder imageViewHolder;
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        Image image = this.getItem(position);
        if (image == null) {
            return;
        }
        Image image2 = image;
        boolean isSelected = this.isSelected(image2);
        this.getImageLoader().loadImage(image2, viewHolder.getImageView(), ImageType.GALLERY);
        boolean showFileTypeIndicator = false;
        String fileTypeLabel = null;
        fileTypeLabel = "";
        if (ImagePickerUtils.INSTANCE.isGifFormat(image2)) {
            fileTypeLabel = this.getContext().getResources().getString(R.string.ef_gif);
            showFileTypeIndicator = true;
        }
        if (ImagePickerUtils.INSTANCE.isVideoFormat(image2)) {
            if (!this.videoDurationHolder.containsKey(image2.getId())) {
                Uri uri = Uri.withAppendedPath((Uri)MediaStore.Files.getContentUri((String)"external"), (String)("" + image2.getId()));
                Map map = this.videoDurationHolder;
                Long l = image2.getId();
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                map.put(l, ImagePickerUtils.INSTANCE.getVideoDurationLabel(context, uri));
            }
            fileTypeLabel = this.videoDurationHolder.get(image2.getId());
            showFileTypeIndicator = true;
        }
        ImageViewHolder $this$onBindViewHolder_u24lambda_u2d1 = imageViewHolder = viewHolder;
        boolean bl = false;
        $this$onBindViewHolder_u24lambda_u2d1.getFileTypeIndicator().setText((CharSequence)fileTypeLabel);
        $this$onBindViewHolder_u24lambda_u2d1.getFileTypeIndicator().setVisibility(showFileTypeIndicator ? 0 : 8);
        $this$onBindViewHolder_u24lambda_u2d1.getAlphaView().setAlpha(isSelected ? 0.5f : 0.0f);
        $this$onBindViewHolder_u24lambda_u2d1.itemView.setOnClickListener(arg_0 -> ImagePickerAdapter.onBindViewHolder$lambda-1$lambda-0(this, isSelected, image2, position, arg_0));
        FrameLayout frameLayout = $this$onBindViewHolder_u24lambda_u2d1.getContainer();
        if (frameLayout != null) {
            frameLayout.setForeground(isSelected ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ef_ic_done_white) : null);
        }
    }

    private final boolean isSelected(Image image) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.selectedImages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Image it = (Image)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)image.getPath())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public int getItemCount() {
        return this.getListDiffer().getCurrentList().size();
    }

    public final void setData(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.getListDiffer().submitList(images);
    }

    private final void addSelected(Image image, int position) {
        this.mutateSelection(() -> ImagePickerAdapter.addSelected$lambda-3(this, image, position));
    }

    private final void removeSelectedImage(Image image, int position) {
        this.mutateSelection(() -> ImagePickerAdapter.removeSelectedImage$lambda-4(this, image, position));
    }

    public final void removeAllSelectedSingleClick() {
        this.mutateSelection(() -> ImagePickerAdapter.removeAllSelectedSingleClick$lambda-5(this));
    }

    private final void mutateSelection(Runnable runnable) {
        block0: {
            runnable.run();
            Function1<? super List<Image>, Unit> function1 = this.imageSelectedListener;
            if (function1 == null) break block0;
            function1.invoke(this.selectedImages);
        }
    }

    public final void setImageSelectedListener(@Nullable Function1<? super List<Image>, Unit> imageSelectedListener) {
        this.imageSelectedListener = imageSelectedListener;
    }

    private final Image getItem(int position) {
        List list = this.getListDiffer().getCurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listDiffer.currentList");
        return (Image)CollectionsKt.getOrNull((List)list, (int)position);
    }

    private static final void onBindViewHolder$lambda-1$lambda-0(ImagePickerAdapter this$0, boolean $isSelected, Image $image, int $position, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        boolean shouldSelect = (Boolean)this$0.itemClickListener.invoke((Object)$isSelected);
        if ($isSelected) {
            this$0.removeSelectedImage($image, $position);
        } else if (shouldSelect) {
            this$0.addSelected($image, $position);
        }
    }

    private static final void addSelected$lambda-3(ImagePickerAdapter this$0, Image $image, int $position) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        this$0.selectedImages.add($image);
        this$0.notifyItemChanged($position);
    }

    private static final void removeSelectedImage$lambda-4(ImagePickerAdapter this$0, Image $image, int $position) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        this$0.selectedImages.remove($image);
        this$0.notifyItemChanged($position);
    }

    private static final void removeAllSelectedSingleClick$lambda-5(ImagePickerAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.selectedImages.clear();
        this$0.notifyDataSetChanged();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/esafirm/imagepicker/adapter/ImagePickerAdapter$ImageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "alphaView", "getAlphaView", "()Landroid/view/View;", "container", "Landroid/widget/FrameLayout;", "getContainer", "()Landroid/widget/FrameLayout;", "fileTypeIndicator", "Landroid/widget/TextView;", "getFileTypeIndicator", "()Landroid/widget/TextView;", "imageView", "Landroid/widget/ImageView;", "getImageView", "()Landroid/widget/ImageView;", "imagepicker_release"})
    public static final class ImageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView imageView;
        @NotNull
        private final View alphaView;
        @NotNull
        private final TextView fileTypeIndicator;
        @Nullable
        private final FrameLayout container;

        public ImageViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            ImageView imageView = (ImageView)itemView.findViewById(R.id.image_view);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"itemView.image_view");
            this.imageView = imageView;
            View view = itemView.findViewById(R.id.view_alpha);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.view_alpha");
            this.alphaView = view;
            TextView textView = (TextView)itemView.findViewById(R.id.ef_item_file_type_indicator);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"itemView.ef_item_file_type_indicator");
            this.fileTypeIndicator = textView;
            this.container = itemView instanceof FrameLayout ? (FrameLayout)itemView : null;
        }

        @NotNull
        public final ImageView getImageView() {
            return this.imageView;
        }

        @NotNull
        public final View getAlphaView() {
            return this.alphaView;
        }

        @NotNull
        public final TextView getFileTypeIndicator() {
            return this.fileTypeIndicator;
        }

        @Nullable
        public final FrameLayout getContainer() {
            return this.container;
        }
    }
}

