/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.Visitor;

class NumberSchemaValidatingVisitor
extends Visitor {
    private static final List<Class<?>> INTEGRAL_TYPES = Arrays.asList(Integer.class, Long.class, BigInteger.class, AtomicInteger.class, AtomicLong.class);
    private final Object subject;
    private final ValidatingVisitor owner;
    private boolean exclusiveMinimum;
    private boolean exclusiveMaximum;
    private double numberSubject;

    NumberSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = owner;
    }

    @Override
    void visitNumberSchema(NumberSchema numberSchema) {
        if (this.owner.passesTypeCheck(Number.class, numberSchema.isRequiresNumber(), numberSchema.isNullable())) {
            if (!INTEGRAL_TYPES.contains(this.subject.getClass()) && numberSchema.requiresInteger()) {
                this.owner.failure(Integer.class, this.subject);
            } else {
                this.numberSubject = ((Number)this.subject).doubleValue();
                super.visitNumberSchema(numberSchema);
            }
        }
    }

    @Override
    void visitExclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    @Override
    void visitMinimum(Number minimum) {
        if (minimum == null) {
            return;
        }
        if (this.exclusiveMinimum && this.numberSubject <= minimum.doubleValue()) {
            this.owner.failure(this.subject + " is not greater than " + minimum, "exclusiveMinimum");
        } else if (this.numberSubject < minimum.doubleValue()) {
            this.owner.failure(this.subject + " is not greater or equal to " + minimum, "minimum");
        }
    }

    @Override
    void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
        if (exclusiveMinimumLimit != null && this.numberSubject <= exclusiveMinimumLimit.doubleValue()) {
            this.owner.failure(this.subject + " is not greater than " + exclusiveMinimumLimit, "exclusiveMinimum");
        }
    }

    @Override
    void visitMaximum(Number maximum) {
        if (maximum == null) {
            return;
        }
        if (this.exclusiveMaximum && maximum.doubleValue() <= this.numberSubject) {
            this.owner.failure(this.subject + " is not less than " + maximum, "exclusiveMaximum");
        } else if (maximum.doubleValue() < this.numberSubject) {
            this.owner.failure(this.subject + " is not less or equal to " + maximum, "maximum");
        }
    }

    @Override
    void visitExclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    @Override
    void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
        if (exclusiveMaximumLimit != null && this.numberSubject >= exclusiveMaximumLimit.doubleValue()) {
            this.owner.failure(this.subject + " is not less than " + exclusiveMaximumLimit, "exclusiveMaximum");
        }
    }

    @Override
    void visitMultipleOf(Number multipleOf) {
        BigDecimal remainder;
        if (multipleOf != null && (remainder = BigDecimal.valueOf(this.numberSubject).remainder(BigDecimal.valueOf(multipleOf.doubleValue()))).compareTo(BigDecimal.ZERO) != 0) {
            this.owner.failure(this.subject + " is not a multiple of " + multipleOf, "multipleOf");
        }
    }
}

