/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;

class LoadingState {
    static final Comparator<Class<?>> CLASS_COMPARATOR = (cl1, cl2) -> cl1.getSimpleName().compareTo(cl2.getSimpleName());
    final LoaderConfig config;
    final URI id;
    final SchemaLocation pointerToCurrentObj;
    final Map<String, ReferenceSchema.Builder> pointerSchemas;
    final JsonValue rootSchemaJson;
    final JsonValue schemaJson;

    static URI extractChildId(URI parentScopeId, Object childJson, String idKeyword) {
        Map<String, Object> child;
        Object childId;
        if (childJson instanceof JsonObject) {
            childJson = ((JsonObject)((Object)childJson)).toMap();
        }
        if (childJson instanceof Map && (childId = (child = childJson).get(idKeyword)) instanceof String) {
            return ReferenceResolver.resolve(parentScopeId, (String)childId);
        }
        return parentScopeId;
    }

    LoadingState(LoaderConfig config, Map<String, ReferenceSchema.Builder> pointerSchemas, Object rootSchemaJson, Object schemaJson, URI parentScopeId, SchemaLocation pointerToCurrentObj) {
        this.config = config;
        this.pointerSchemas = Objects.requireNonNull(pointerSchemas, "pointerSchemas cannot be null");
        this.id = LoadingState.extractChildId(parentScopeId, schemaJson, config.specVersion.idKeyword());
        this.pointerToCurrentObj = Objects.requireNonNull(pointerToCurrentObj, "pointerToCurrentObj cannot be null");
        this.rootSchemaJson = JsonValue.of(rootSchemaJson);
        if (this.rootSchemaJson.ls == null) {
            this.rootSchemaJson.ls = this;
        }
        this.schemaJson = JsonValue.of(schemaJson);
        this.schemaJson.ls = this;
    }

    SchemaLoader.SchemaLoaderBuilder initNewDocumentLoader() {
        return this.config.initLoader().pointerSchemas(this.pointerSchemas);
    }

    private Object getRawChildOfObject(JsonObject obj, String key) {
        Map rawMap = (Map)obj.unwrap();
        if (!rawMap.containsKey(key)) {
            throw this.createSchemaException(String.format("key [%s] not found", key));
        }
        return rawMap.get(key);
    }

    private Object getRawElemOfArray(JsonArray array, String rawIndex) {
        List raw = (List)array.unwrap();
        try {
            int index = Integer.parseInt(rawIndex);
            if (raw.size() <= index) {
                throw this.createSchemaException(String.format("array index [%d] is out of bounds", index));
            }
            return raw.get(index);
        }
        catch (NumberFormatException e) {
            throw this.createSchemaException(String.format("[%s] is not an array index", rawIndex));
        }
    }

    JsonValue childFor(String key) {
        Object rawChild = this.schemaJson.canBeMappedTo(JsonObject.class, obj -> this.getRawChildOfObject((JsonObject)obj, key)).orMappedTo(JsonArray.class, array -> this.getRawElemOfArray((JsonArray)array, key)).requireAny();
        LoadingState childLs = new LoadingState(this.config, this.pointerSchemas, this.rootSchemaJson, rawChild, this.id, this.pointerToCurrentObj.addPointerSegment(key));
        return childLs.schemaJson;
    }

    JsonValue childFor(int arrayIndex) {
        return this.childFor(String.valueOf(arrayIndex));
    }

    JsonObject schemaJson() {
        return this.schemaJson.requireObject();
    }

    JsonObject rootSchemaJson() {
        return this.rootSchemaJson.requireObject();
    }

    String locationOfCurrentObj() {
        return this.pointerToCurrentObj.toString();
    }

    SchemaException createSchemaException(String message) {
        return new SchemaException(this.locationOfCurrentObj(), message);
    }

    SchemaException createSchemaException(Exception cause) {
        return new SchemaException(this.locationOfCurrentObj(), cause);
    }

    SchemaException createSchemaException(Class<?> actualType, Class<?> expectedType, Class<?> ... furtherExpectedTypes) {
        return new SchemaException(this.locationOfCurrentObj(), actualType, expectedType, furtherExpectedTypes);
    }

    SchemaException createSchemaException(Class<?> actualType, Collection<Class<?>> expectedTypes) {
        ArrayList sortedTypes = new ArrayList(expectedTypes);
        Collections.sort(sortedTypes, CLASS_COMPARATOR);
        return new SchemaException(this.locationOfCurrentObj(), actualType, sortedTypes);
    }

    SpecificationVersion specVersion() {
        return this.config.specVersion;
    }
}

