/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$1;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$2;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$3;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$4;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$5;
import org.everit.json.schema.loader.CombinedSchemaLoader$$Lambda$6;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.SchemaExtractor;
import org.everit.json.schema.loader.SchemaLoader;

class CombinedSchemaLoader
implements SchemaExtractor {
    private static final Map<String, CombinedSchemaProvider> COMB_SCHEMA_PROVIDERS = new HashMap<String, CombinedSchemaProvider>(3);
    private final SchemaLoader defaultLoader;

    public CombinedSchemaLoader(SchemaLoader defaultLoader) {
        this.defaultLoader = (SchemaLoader)Objects.requireNonNull((Object)defaultLoader, (String)"defaultLoader cannot be null");
    }

    @Override
    public ExtractionResult extract(JsonObject schemaJson) {
        Stream stream = StreamSupport.stream(COMB_SCHEMA_PROVIDERS.keySet());
        JsonObject jsonObject = schemaJson;
        jsonObject.getClass();
        Set presentKeys = (Set)stream.filter(CombinedSchemaLoader$$Lambda$1.lambdaFactory$(jsonObject)).collect(Collectors.toSet());
        Collection extractedSchemas = (Collection)StreamSupport.stream((Collection)presentKeys).map(CombinedSchemaLoader$$Lambda$2.lambdaFactory$(this, schemaJson)).collect(Collectors.toList());
        return new ExtractionResult(presentKeys, extractedSchemas);
    }

    private CombinedSchema.Builder loadCombinedSchemaForKeyword(JsonObject schemaJson, String key) {
        ArrayList subschemas = new ArrayList();
        schemaJson.require(key).requireArray().forEach(CombinedSchemaLoader$$Lambda$3.lambdaFactory$(this, subschemas));
        return (CombinedSchema.Builder)COMB_SCHEMA_PROVIDERS.get(key).apply(subschemas);
    }

    static /* synthetic */ void lambda$loadCombinedSchemaForKeyword$1(CombinedSchemaLoader this_, Collection subschemas, int i, JsonValue subschema) {
        subschemas.add(this_.defaultLoader.loadChild(subschema).build());
    }

    static /* synthetic */ CombinedSchema.Builder lambda$extract$0(CombinedSchemaLoader this_, JsonObject schemaJson, String key) {
        return this_.loadCombinedSchemaForKeyword(schemaJson, key);
    }

    static {
        COMB_SCHEMA_PROVIDERS.put("allOf", CombinedSchemaLoader$$Lambda$4.lambdaFactory$());
        COMB_SCHEMA_PROVIDERS.put("anyOf", CombinedSchemaLoader$$Lambda$5.lambdaFactory$());
        COMB_SCHEMA_PROVIDERS.put("oneOf", CombinedSchemaLoader$$Lambda$6.lambdaFactory$());
    }

    @FunctionalInterface
    private static interface CombinedSchemaProvider
    extends Function<Collection<Schema>, CombinedSchema.Builder> {
    }
}

