/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java8.util.Optional;
import org.everit.json.schema.internal.AFormatValidator;

public class URIReferenceFormatValidator
extends AFormatValidator {
    @Override
    public Optional<String> validate(String subject) {
        try {
            new URI(subject);
            return Optional.empty();
        }
        catch (URISyntaxException e) {
            return this.failure(subject);
        }
    }

    protected Optional<String> failure(String subject) {
        return Optional.of((Object)String.format("[%s] is not a valid URI reference", subject));
    }

    @Override
    public String formatName() {
        return "uri-reference";
    }
}

