/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import java8.util.Objects;
import java8.util.Optional;
import org.everit.json.schema.internal.AFormatValidator;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class TemporalFormatValidator
extends AFormatValidator {
    static final DateTimeFormatter SECONDS_FRACTION_FORMATTER = new DateTimeFormatterBuilder().appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter();
    static final String ZONE_OFFSET_PATTERN = "XXX";
    private final DateTimeFormatter formatter;
    private final String formatsAccepted;

    TemporalFormatValidator(DateTimeFormatter formatter, String formatsAccepted) {
        this.formatter = (DateTimeFormatter)Objects.requireNonNull((Object)formatter, (String)"formatter cannot be null");
        this.formatsAccepted = formatsAccepted;
    }

    @Override
    public Optional<String> validate(String subject) {
        try {
            this.formatter.parse((CharSequence)subject);
            return Optional.empty();
        }
        catch (DateTimeParseException e) {
            return Optional.of((Object)String.format("[%s] is not a valid %s. Expected %s", subject, this.formatName(), this.formatsAccepted));
        }
    }
}

