/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java8.util.Objects;
import java8.util.function.Function;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;
import org.everit.json.schema.ObjectSchema$$Lambda$1;
import org.everit.json.schema.ObjectSchema$$Lambda$2;
import org.everit.json.schema.ObjectSchema$$Lambda$3;
import org.everit.json.schema.ObjectSchema$$Lambda$4;
import org.everit.json.schema.ObjectSchema$$Lambda$5;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.Regexp;
import org.everit.json.schema.regexp.RegexpFactory;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final Schema propertyNameSchema;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Regexp, Schema> patternProperties;

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = ObjectSchema.copyMap(builder.propertyDependencies);
        this.schemaDependencies = ObjectSchema.copyMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = ObjectSchema.copyMap(builder.patternProperties);
        this.propertyNameSchema = builder.propertyNameSchema;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    Map<Regexp, Schema> getRegexpPatternProperties() {
        return this.patternProperties;
    }

    @Deprecated
    public Map<Pattern, Schema> getPatternProperties() {
        return (Map)StreamSupport.stream(this.patternProperties.entrySet()).map(ObjectSchema$$Lambda$1.lambdaFactory$()).collect(Collectors.toMap((Function)ObjectSchema$$Lambda$2.lambdaFactory$(), (Function)ObjectSchema$$Lambda$3.lambdaFactory$()));
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    public Schema getPropertyNameSchema() {
        return this.propertyNameSchema;
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitObjectSchema(this);
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    @Override
    public boolean definesProperty(String field) {
        String remaining;
        String nextToken;
        int firstSlashIdx = (field = field.replaceFirst("^#", "").replaceFirst("^/", "")).indexOf(47);
        if (firstSlashIdx == -1) {
            nextToken = field;
            remaining = null;
        } else {
            nextToken = field.substring(0, firstSlashIdx);
            remaining = field.substring(firstSlashIdx + 1);
        }
        return !field.isEmpty() && (this.definesSchemaProperty(nextToken, remaining) || this.definesPatternProperty(nextToken, remaining) || this.definesSchemaDependencyProperty(field));
    }

    private boolean definesSchemaProperty(String current, String remaining) {
        boolean hasSuffix;
        current = this.unescape(current);
        boolean bl = hasSuffix = remaining != null;
        if (this.propertySchemas.containsKey(current)) {
            if (hasSuffix) {
                return this.propertySchemas.get(current).definesProperty(remaining);
            }
            return true;
        }
        return false;
    }

    private boolean definesPatternProperty(String current, String remaining) {
        for (Map.Entry<Regexp, Schema> entry : this.patternProperties.entrySet()) {
            Regexp pattern = entry.getKey();
            if (pattern.patternMatchingFailure(current).isPresent() || remaining != null && !entry.getValue().definesProperty(remaining)) continue;
            return true;
        }
        return false;
    }

    private boolean definesSchemaDependencyProperty(String field) {
        if (this.schemaDependencies.containsKey(field)) {
            return true;
        }
        for (Schema schema : this.schemaDependencies.values()) {
            if (!schema.definesProperty(field)) continue;
            return true;
        }
        return false;
    }

    private String unescape(String value) {
        return value.replace("~1", "/").replace("~0", "~");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)o;
            return that.canEqual(this) && this.additionalProperties == that.additionalProperties && this.requiresObject == that.requiresObject && Objects.equals(this.propertySchemas, that.propertySchemas) && Objects.equals((Object)this.schemaOfAdditionalProperties, (Object)that.schemaOfAdditionalProperties) && Objects.equals(this.requiredProperties, that.requiredProperties) && Objects.equals((Object)this.minProperties, (Object)that.minProperties) && Objects.equals((Object)this.maxProperties, (Object)that.maxProperties) && Objects.equals(this.propertyDependencies, that.propertyDependencies) && Objects.equals(this.schemaDependencies, that.schemaDependencies) && Objects.equals(this.patternProperties, that.patternProperties) && Objects.equals((Object)this.propertyNameSchema, (Object)that.propertyNameSchema) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash((Object[])new Object[]{super.hashCode(), this.propertySchemas, this.propertyNameSchema, this.additionalProperties, this.schemaOfAdditionalProperties, this.requiredProperties, this.minProperties, this.maxProperties, this.propertyDependencies, this.schemaDependencies, this.requiresObject, this.patternProperties});
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresObject) {
            writer.key("type").value("object");
        }
        if (!this.propertySchemas.isEmpty()) {
            writer.key("properties");
            writer.printSchemaMap(this.propertySchemas);
        }
        writer.ifPresent("minProperties", this.minProperties);
        writer.ifPresent("maxProperties", this.maxProperties);
        if (!this.requiredProperties.isEmpty()) {
            writer.key("required").value(this.requiredProperties);
        }
        if (this.schemaOfAdditionalProperties != null) {
            writer.key("additionalProperties");
            this.schemaOfAdditionalProperties.describeTo(writer);
        }
        if (this.propertyNameSchema != null) {
            writer.key("propertyNames");
            this.propertyNameSchema.describeTo(writer);
        }
        if (!this.propertyDependencies.isEmpty()) {
            this.describePropertyDependenciesTo(writer);
        }
        if (!this.schemaDependencies.isEmpty()) {
            writer.key("dependencies");
            writer.printSchemaMap(this.schemaDependencies);
        }
        if (!this.patternProperties.isEmpty()) {
            writer.key("patternProperties");
            writer.printSchemaMap(this.patternProperties);
        }
        writer.ifFalse("additionalProperties", this.additionalProperties);
    }

    private void describePropertyDependenciesTo(JSONPrinter writer) {
        writer.key("dependencies");
        writer.object();
        this.propertyDependencies.forEach(ObjectSchema$$Lambda$4.lambdaFactory$(writer));
        writer.endObject();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectSchema;
    }

    static /* synthetic */ void lambda$describePropertyDependenciesTo$3(JSONPrinter writer, String key, Set value) {
        writer.key(key);
        writer.array();
        JSONPrinter jSONPrinter = writer;
        jSONPrinter.getClass();
        value.forEach(ObjectSchema$$Lambda$5.lambdaFactory$(jSONPrinter));
        writer.endArray();
    }

    static /* synthetic */ Schema lambda$getPatternProperties$2(Map.Entry entry) {
        return (Schema)entry.getValue();
    }

    static /* synthetic */ Pattern lambda$getPatternProperties$1(Map.Entry entry) {
        return (Pattern)entry.getKey();
    }

    static /* synthetic */ AbstractMap.SimpleEntry lambda$getPatternProperties$0(Map.Entry entry) {
        return new AbstractMap.SimpleEntry(Pattern.compile(((Regexp)entry.getKey()).toString()), entry.getValue());
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private static final RegexpFactory DEFAULT_REGEXP_FACTORY = new JavaUtilRegexpFactory();
        private final Map<Regexp, Schema> patternProperties = new HashMap<Regexp, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new HashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();
        private Schema propertyNameSchema;

        private static final Regexp toRegexp(String pattern) {
            return DEFAULT_REGEXP_FACTORY.createHandler(pattern);
        }

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull((Object)propName, (String)"propName cannot be null");
            Objects.requireNonNull((Object)schema, (String)"schema cannot be null");
            this.propertySchemas.put(propName, schema);
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        @Deprecated
        public Builder patternProperty(Pattern pattern, Schema schema) {
            Regexp handler = Builder.toRegexp(pattern.toString());
            return this.patternProperty(handler, schema);
        }

        @Deprecated
        public Builder patternProperty(String pattern, Schema schema) {
            Regexp handler = Builder.toRegexp(pattern);
            return this.patternProperty(handler, schema);
        }

        public Builder patternProperty(Regexp pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new HashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }

        public Builder propertyNameSchema(Schema propertyNameSchema) {
            this.propertyNameSchema = propertyNameSchema;
            return this;
        }
    }
}

