/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.media.Image;
import androidx.core.content.ContextCompat;
import com.jiangdg.ausbc.R;
import com.jiangdg.usb.DeviceFilter;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012\u00a8\u0006\u0018"}, d2={"Lcom/jiangdg/ausbc/utils/CameraUtils;", "", "<init>", "()V", "transferYUV420ToNV21", "", "image", "Landroid/media/Image;", "width", "", "height", "isUsbCamera", "", "device", "Landroid/hardware/usb/UsbDevice;", "isCameraContainsMic", "isFilterDevice", "context", "Landroid/content/Context;", "usbDevice", "hasAudioPermission", "ctx", "hasStoragePermission", "hasCameraPermission", "libausbc_release"})
public final class CameraUtils {
    @NotNull
    public static final CameraUtils INSTANCE = new CameraUtils();

    private CameraUtils() {
    }

    @NotNull
    public final byte[] transferYUV420ToNV21(@NotNull Image image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        byte[] nv21 = new byte[width * height * 3 / 2];
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer yBuffer = planes[0].getBuffer();
        int yLen = width * height;
        yBuffer.get(nv21, 0, yLen);
        ByteBuffer vBuffer = planes[2].getBuffer();
        int vPixelStride = planes[2].getPixelStride();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)vBuffer.remaining())), (int)vPixelStride);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = 0;
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            while (true) {
                int index = n4++;
                int i = n;
                int vIndex = yLen + 2 * index;
                if (vIndex >= nv21.length) break;
                nv21[vIndex] = vBuffer.get(i);
                if (i == n2) break;
                n += n3;
            }
        }
        ByteBuffer uBuffer = planes[1].getBuffer();
        int uPixelStride = planes[1].getPixelStride();
        IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)uBuffer.remaining())), (int)uPixelStride);
        n3 = intProgression2.getFirst();
        n4 = intProgression2.getLast();
        int n5 = intProgression2.getStep();
        int n6 = 0;
        if (n5 > 0 && n3 <= n4 || n5 < 0 && n4 <= n3) {
            while (true) {
                int index = n6++;
                int i = n3;
                int uIndex = yLen + (2 * index + 1);
                if (uIndex >= nv21.length) break;
                nv21[yLen + (2 * index + 1)] = uBuffer.get(i);
                if (i == n4) break;
                n3 += n5;
            }
        }
        return nv21;
    }

    public final boolean isUsbCamera(@Nullable UsbDevice device) {
        int n;
        Integer n2;
        UsbDevice usbDevice = device;
        Integer n3 = n2 = usbDevice != null ? Integer.valueOf(usbDevice.getDeviceClass()) : null;
        int n4 = 14;
        if (n3 != null && n3 == n4) {
            n = 1;
        } else {
            Integer n5 = n2;
            n4 = 239;
            if (n5 != null && n5 == n4) {
                boolean isVideo = false;
                int n6 = device.getInterfaceCount();
                for (int i = 0; i < n6; ++i) {
                    int cls = device.getInterface(i).getInterfaceClass();
                    if (cls != 14) continue;
                    isVideo = true;
                    break;
                }
                n = n4;
            } else {
                n = 0;
            }
        }
        return n != 0;
    }

    public final boolean isCameraContainsMic(@Nullable UsbDevice device) {
        if (device == null) {
            return false;
        }
        boolean hasMic = false;
        int n = device.getInterfaceCount();
        for (int i = 0; i < n; ++i) {
            int cls = device.getInterface(i).getInterfaceClass();
            if (cls != 1) continue;
            hasMic = true;
            break;
        }
        return hasMic;
    }

    public final boolean isFilterDevice(@Nullable Context context, @Nullable UsbDevice usbDevice) {
        Object v2;
        block1: {
            List list = DeviceFilter.getDeviceFilters((Context)context, (int)R.xml.default_device_filter);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDeviceFilters(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DeviceFilter devFilter = (DeviceFilter)t;
                boolean bl = false;
                boolean bl2 = usbDevice != null ? devFilter.mProductId == usbDevice.getProductId() : false;
                if (!(bl2 && devFilter.mVendorId == usbDevice.getVendorId())) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        DeviceFilter dev = v2;
        boolean bl = false;
        return dev != null;
    }

    public final boolean hasAudioPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.RECORD_AUDIO");
        return locPermission == 0;
    }

    public final boolean hasStoragePermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return locPermission == 0;
    }

    public final boolean hasCameraPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.CAMERA");
        return locPermission == 0;
    }
}

