/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.app.Activity;
import com.jiangdg.ausbc.utils.Logger;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jiangdg/ausbc/utils/ActivityStackUtils;", "", "<init>", "()V", "TAG", "", "mStack", "Ljava/util/Stack;", "Landroid/app/Activity;", "pushActivity", "", "activity", "popActivity", "removeActivity", "getStackTop", "popAllActivity", "hasActivity", "", "libausbc_release"})
public final class ActivityStackUtils {
    @NotNull
    public static final ActivityStackUtils INSTANCE = new ActivityStackUtils();
    @NotNull
    private static final String TAG = "ActivityStackUtils";
    @NotNull
    private static final Stack<Activity> mStack = new Stack();

    private ActivityStackUtils() {
    }

    public final void pushActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        mStack.push(activity);
        Logger.INSTANCE.d(TAG, "push stack: " + activity.getLocalClassName());
    }

    public final void popActivity() {
        if (!mStack.empty()) {
            Activity activity = mStack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"pop(...)");
            Activity activity2 = activity;
            activity2.finish();
            Logger.INSTANCE.d(TAG, "pop stack: " + activity2.getLocalClassName());
        }
    }

    public final void removeActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!mStack.empty()) {
            mStack.remove(activity);
            Logger.INSTANCE.d(TAG, "remove stack: " + activity.getLocalClassName());
        }
    }

    @Nullable
    public final Activity getStackTop() {
        Activity activity = null;
        if (!mStack.empty()) {
            activity = mStack.peek();
            Logger.INSTANCE.d(TAG, "stack top: " + activity.getLocalClassName());
        }
        return activity;
    }

    public final void popAllActivity() {
        if (!mStack.empty()) {
            int size = mStack.size();
            for (int i = 0; i < size; ++i) {
                this.popActivity();
            }
        }
    }

    public final boolean hasActivity() {
        return !mStack.isEmpty();
    }
}

