/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.bus.EventBus;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0001A\b'\u0018\u0000 v2\u00020\u0001:\u0001vB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J%\u0010G\u001a\u00020H\"\u0004\b\u0000\u0010I2\b\u0010J\u001a\u0004\u0018\u00010\u000f2\b\u0010K\u001a\u0004\u0018\u0001HI\u00a2\u0006\u0002\u0010LJ\u0006\u0010M\u001a\u00020HJ\u0018\u0010N\u001a\u00020H2\u0006\u0010O\u001a\u00020\u00192\b\u0010P\u001a\u0004\u0018\u00010<J\u0012\u0010Q\u001a\u00020H2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010<J\u0010\u0010S\u001a\u00020H2\u0006\u0010T\u001a\u00020\u000bH\u0002J\u0010\u0010U\u001a\u00020H2\u0006\u0010V\u001a\u00020\rH\u0002J!\u0010W\u001a\n\u0012\u0004\u0012\u00020Y\u0018\u00010X2\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010[H&\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u0004\u0018\u00010\u000bJ\b\u0010^\u001a\u0004\u0018\u00010\rJ\n\u0010_\u001a\u0004\u0018\u00010\u0003H\u0004J\n\u0010`\u001a\u0004\u0018\u00010\u000fH\u0004J\n\u0010a\u001a\u0004\u0018\u00010\tH\u0004J\b\u0010b\u001a\u00020'H\u0004J\u0010\u0010c\u001a\u00020H2\u0006\u0010d\u001a\u00020eH\u0004J\b\u0010f\u001a\u00020HH\u0016J\b\u0010g\u001a\u00020HH\u0016J\b\u0010h\u001a\u00020HH$J\b\u0010i\u001a\u00020HH$J\b\u0010j\u001a\u00020HH$J\u0012\u0010k\u001a\u00020H2\b\u0010P\u001a\u0004\u0018\u00010<H$J\u0012\u0010l\u001a\u00020H2\b\u0010R\u001a\u0004\u0018\u00010<H$J\u0018\u0010m\u001a\u00020H2\u0006\u0010n\u001a\u00020'2\u0006\u0010o\u001a\u00020'H$J\b\u0010p\u001a\u00020DH\u0004J\b\u0010q\u001a\u00020DH\u0004J\u0010\u0010r\u001a\u00020H2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010s\u001a\u00020H2\u0006\u0010O\u001a\u00020\u0013J\u000e\u0010t\u001a\u00020H2\u0006\u0010O\u001a\u00020\u0013J\u0006\u0010u\u001a\u00020DR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R0\u0010%\u001a\u001e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&j\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(`)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010/\"\u0004\b4\u00101R\u001b\u00105\u001a\u0002068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b7\u00108R\u001b\u0010;\u001a\u00020<8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010:\u001a\u0004\b=\u0010>R\u0010\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010B\u00a8\u0006w"}, d2={"Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "Landroid/os/Handler$Callback;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mThread", "Landroid/os/HandlerThread;", "mCameraHandler", "Landroid/os/Handler;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mSurfaceHolder", "Landroid/view/SurfaceHolder;", "mCameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "mContext", "mPreviewDataCbList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "getMPreviewDataCbList", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "setMPreviewDataCbList", "(Ljava/util/concurrent/CopyOnWriteArrayList;)V", "mCaptureDataCb", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "getMCaptureDataCb", "()Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "setMCaptureDataCb", "(Lcom/jiangdg/ausbc/callback/ICaptureCallBack;)V", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "mSaveImageExecutor", "Ljava/util/concurrent/ExecutorService;", "getMSaveImageExecutor", "()Ljava/util/concurrent/ExecutorService;", "mCameraInfoMap", "Ljava/util/HashMap;", "", "Lcom/jiangdg/ausbc/camera/bean/CameraInfo;", "Lkotlin/collections/HashMap;", "getMCameraInfoMap", "()Ljava/util/HashMap;", "mIsCapturing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMIsCapturing", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setMIsCapturing", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "mIsPreviewing", "getMIsPreviewing", "setMIsPreviewing", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "Lkotlin/Lazy;", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "mDeviceOrientation", "com/jiangdg/ausbc/camera/ICameraStrategy$mDeviceOrientation$1", "Lcom/jiangdg/ausbc/camera/ICameraStrategy$mDeviceOrientation$1;", "handleMessage", "", "msg", "Landroid/os/Message;", "startPreview", "", "T", "request", "renderSurface", "(Lcom/jiangdg/ausbc/camera/bean/CameraRequest;Ljava/lang/Object;)V", "stopPreview", "captureImage", "callBack", "savePath", "switchCamera", "cameraId", "setSurfaceTexture", "surfaceTexture", "setSurfaceHolder", "holder", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getSurfaceTexture", "getSurfaceHolder", "getContext", "getRequest", "getCameraHandler", "getDeviceOrientation", "postCameraStatus", "status", "Lcom/jiangdg/ausbc/camera/bean/CameraStatus;", "register", "unRegister", "loadCameraInfo", "startPreviewInternal", "stopPreviewInternal", "captureImageInternal", "switchCameraInternal", "updateResolutionInternal", "width", "height", "hasCameraPermission", "hasStoragePermission", "addLifecycleObserver", "addPreviewDataCallBack", "removePreviewDataCallBack", "isCameraOpened", "Companion", "libausbc_release"})
public abstract class ICameraStrategy
implements Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HandlerThread mThread;
    @Nullable
    private Handler mCameraHandler;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private SurfaceHolder mSurfaceHolder;
    @Nullable
    private CameraRequest mCameraRequest;
    @Nullable
    private Context mContext;
    @NotNull
    private CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList;
    @Nullable
    private ICaptureCallBack mCaptureDataCb;
    @NotNull
    private final Handler mMainHandler;
    @NotNull
    private final ExecutorService mSaveImageExecutor;
    @NotNull
    private final HashMap<Integer, CameraInfo> mCameraInfoMap;
    @NotNull
    private AtomicBoolean mIsCapturing;
    @NotNull
    private AtomicBoolean mIsPreviewing;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private final mDeviceOrientation.1 mDeviceOrientation;
    @NotNull
    private static final String TAG = "ICameraStrategy";
    @NotNull
    private static final String THREAD_NAME = "camera_manager";
    private static final int MSG_INIT = 0;
    private static final int MSG_START_PREVIEW = 1;
    private static final int MSG_STOP_PREVIEW = 2;
    private static final int MSG_CAPTURE_IMAGE = 3;
    private static final int MSG_SWITCH_CAMERA = 4;
    public static final int TYPE_FRONT = 0;
    public static final int TYPE_BACK = 1;
    public static final int TYPE_OTHER = 2;

    public ICameraStrategy(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mPreviewDataCbList = new CopyOnWriteArrayList();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.mSaveImageExecutor = executorService;
        this.mCameraInfoMap = new HashMap();
        this.mIsCapturing = new AtomicBoolean(false);
        this.mIsPreviewing = new AtomicBoolean(false);
        this.mDateFormat$delegate = LazyKt.lazy(ICameraStrategy::mDateFormat_delegate$lambda$0);
        this.mCameraDir$delegate = LazyKt.lazy(ICameraStrategy::mCameraDir_delegate$lambda$1);
        this.mDeviceOrientation = new OrientationEventListener(context){
            private int orientation;

            public final int getOrientation() {
                return this.orientation;
            }

            public void onOrientationChanged(int orientation) {
                this.orientation = orientation;
            }
        };
        this.mContext = context.getApplicationContext();
        this.addLifecycleObserver(context);
    }

    @NotNull
    protected final CopyOnWriteArrayList<IPreviewDataCallBack> getMPreviewDataCbList() {
        return this.mPreviewDataCbList;
    }

    protected final void setMPreviewDataCbList(@NotNull CopyOnWriteArrayList<IPreviewDataCallBack> copyOnWriteArrayList) {
        Intrinsics.checkNotNullParameter(copyOnWriteArrayList, (String)"<set-?>");
        this.mPreviewDataCbList = copyOnWriteArrayList;
    }

    @Nullable
    protected final ICaptureCallBack getMCaptureDataCb() {
        return this.mCaptureDataCb;
    }

    protected final void setMCaptureDataCb(@Nullable ICaptureCallBack iCaptureCallBack) {
        this.mCaptureDataCb = iCaptureCallBack;
    }

    @NotNull
    protected final Handler getMMainHandler() {
        return this.mMainHandler;
    }

    @NotNull
    protected final ExecutorService getMSaveImageExecutor() {
        return this.mSaveImageExecutor;
    }

    @NotNull
    protected final HashMap<Integer, CameraInfo> getMCameraInfoMap() {
        return this.mCameraInfoMap;
    }

    @NotNull
    protected final AtomicBoolean getMIsCapturing() {
        return this.mIsCapturing;
    }

    protected final void setMIsCapturing(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.mIsCapturing = atomicBoolean;
    }

    @NotNull
    protected final AtomicBoolean getMIsPreviewing() {
        return this.mIsPreviewing;
    }

    protected final void setMIsPreviewing(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.mIsPreviewing = atomicBoolean;
    }

    @NotNull
    protected final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        return (SimpleDateFormat)lazy.getValue();
    }

    @NotNull
    protected final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        return (String)lazy.getValue();
    }

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        switch (msg.what) {
            case 0: {
                this.loadCameraInfo();
                break;
            }
            case 1: {
                CameraRequest cameraRequest;
                if (msg.obj == null) {
                    return true;
                }
                Object object = msg.obj;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jiangdg.ausbc.camera.bean.CameraRequest");
                CameraRequest $this$handleMessage_u24lambda_u242 = cameraRequest = (CameraRequest)object;
                boolean bl = false;
                if (this.mIsPreviewing.get()) {
                    this.mDeviceOrientation.disable();
                    this.stopPreviewInternal();
                }
                this.mDeviceOrientation.enable();
                this.mCameraRequest = $this$handleMessage_u24lambda_u242;
                this.startPreviewInternal();
                break;
            }
            case 2: {
                this.mCameraInfoMap.clear();
                this.mDeviceOrientation.disable();
                this.stopPreviewInternal();
                break;
            }
            case 3: {
                Object object = msg.obj;
                this.captureImageInternal(object instanceof String ? (String)object : null);
                break;
            }
            case 4: {
                Object object = msg.obj;
                this.switchCameraInternal(object instanceof String ? (String)object : null);
            }
        }
        return true;
    }

    public final synchronized <T> void startPreview(@Nullable CameraRequest request, @Nullable T renderSurface) {
        HandlerThread thread;
        Handler handler;
        HandlerThread handlerThread;
        block15: {
            block14: {
                if (this.mIsPreviewing.get()) break block14;
                HandlerThread handlerThread2 = this.mThread;
                boolean bl = handlerThread2 != null ? handlerThread2.isAlive() : false;
                if (!bl) break block15;
            }
            this.stopPreview();
        }
        if (this.mCameraRequest == null && request == null) {
            throw new IllegalStateException("camera request can't be null");
        }
        if (this.mSurfaceHolder == null && this.mSurfaceTexture == null && renderSurface == null) {
            throw new IllegalStateException("render surface can't be null");
        }
        Object object = renderSurface;
        if (object instanceof SurfaceTexture) {
            this.setSurfaceTexture((SurfaceTexture)renderSurface);
        } else if (object instanceof SurfaceHolder) {
            this.setSurfaceHolder((SurfaceHolder)renderSurface);
        }
        Object it = object = Unit.INSTANCE;
        boolean bl = false;
        HandlerThread $this$startPreview_u24lambda_u245_u24lambda_u243 = handlerThread = new HandlerThread(THREAD_NAME);
        boolean bl2 = false;
        $this$startPreview_u24lambda_u245_u24lambda_u243.start();
        HandlerThread it2 = handlerThread;
        boolean bl3 = false;
        this.mCameraHandler = new Handler(it2.getLooper(), (Handler.Callback)this);
        Handler handler2 = this.mCameraHandler;
        if (handler2 != null && (handler2 = handler2.obtainMessage(0)) != null) {
            handler2.sendToTarget();
        }
        if ((handler = this.mCameraHandler) != null) {
            CameraRequest cameraRequest = request;
            if (cameraRequest == null) {
                cameraRequest = this.mCameraRequest;
            }
            if ((handler = handler.obtainMessage(1, (Object)cameraRequest)) != null) {
                handler.sendToTarget();
            }
        }
        this.mThread = thread = handlerThread;
    }

    public final synchronized void stopPreview() {
        if (this.mThread == null) {
            return;
        }
        if (this.mCameraHandler == null) {
            return;
        }
        Handler handler = this.mCameraHandler;
        if (handler != null && (handler = handler.obtainMessage(2)) != null) {
            handler.sendToTarget();
        }
        HandlerThread handlerThread = this.mThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        this.mThread = null;
        this.mCameraHandler = null;
    }

    public final synchronized void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String savePath) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            this.mCaptureDataCb = callBack;
            Handler handler = this.mCameraHandler;
            if (handler == null || (handler = handler.obtainMessage(3, (Object)savePath)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final synchronized void switchCamera(@Nullable String cameraId) {
        block0: {
            Handler handler = this.mCameraHandler;
            if (handler == null || (handler = handler.obtainMessage(4, (Object)cameraId)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public static /* synthetic */ void switchCamera$default(ICameraStrategy iCameraStrategy, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchCamera");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        iCameraStrategy.switchCamera(string);
    }

    private final void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.mSurfaceTexture = surfaceTexture;
    }

    private final void setSurfaceHolder(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
    }

    @Nullable
    public abstract List<PreviewSize> getAllPreviewSizes(@Nullable Double var1);

    public static /* synthetic */ List getAllPreviewSizes$default(ICameraStrategy iCameraStrategy, Double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllPreviewSizes");
        }
        if ((n & 1) != 0) {
            d = null;
        }
        return iCameraStrategy.getAllPreviewSizes(d);
    }

    @Nullable
    public final SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @Nullable
    public final SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    @Nullable
    protected final Context getContext() {
        return this.mContext;
    }

    @Nullable
    protected final CameraRequest getRequest() {
        return this.mCameraRequest;
    }

    @Nullable
    protected final Handler getCameraHandler() {
        return this.mCameraHandler;
    }

    protected final int getDeviceOrientation() {
        return this.mDeviceOrientation.getOrientation();
    }

    protected final void postCameraStatus(@NotNull CameraStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        EventBus.INSTANCE.with("camera-status").postMessage(status);
    }

    public void register() {
    }

    public void unRegister() {
    }

    protected abstract void loadCameraInfo();

    protected abstract void startPreviewInternal();

    protected abstract void stopPreviewInternal();

    protected abstract void captureImageInternal(@Nullable String var1);

    protected abstract void switchCameraInternal(@Nullable String var1);

    protected abstract void updateResolutionInternal(int var1, int var2);

    protected final boolean hasCameraPermission() {
        if (this.getContext() == null) {
            return false;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        int locPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA");
        return locPermission == 0;
    }

    protected final boolean hasStoragePermission() {
        if (this.getContext() == null) {
            return false;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        int locPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return locPermission == 0;
    }

    private final void addLifecycleObserver(Context context) {
        if (!(context instanceof LifecycleOwner)) {
            return;
        }
        ((LifecycleOwner)context).getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ ICameraStrategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                switch (addLifecycleObserver.WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 1: {
                        this.this$0.register();
                        break;
                    }
                    case 2: {
                        this.this$0.stopPreview();
                        this.this$0.unRegister();
                    }
                }
            }
        });
    }

    public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (this.mPreviewDataCbList.contains(callBack)) {
            return;
        }
        this.mPreviewDataCbList.add(callBack);
    }

    public final void removePreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (!this.mPreviewDataCbList.contains(callBack)) {
            return;
        }
        this.mPreviewDataCbList.remove(callBack);
    }

    public final boolean isCameraOpened() {
        return this.mIsPreviewing.get();
    }

    private static final SimpleDateFormat mDateFormat_delegate$lambda$0() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault());
    }

    private static final String mCameraDir_delegate$lambda$1() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/Camera";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jiangdg/ausbc/camera/ICameraStrategy$Companion;", "", "<init>", "()V", "TAG", "", "THREAD_NAME", "MSG_INIT", "", "MSG_START_PREVIEW", "MSG_STOP_PREVIEW", "MSG_CAPTURE_IMAGE", "MSG_SWITCH_CAMERA", "TYPE_FRONT", "TYPE_BACK", "TYPE_OTHER", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

