/*
 * Decompiled with CFR 0.152.
 */
package com.erif.readmoretextview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.erif.readmoretextview.R;
import com.erif.readmoretextview.ToggleListener;

public class TextViewReadMore
extends AppCompatTextView {
    private static final String DEFAULT_EXPAND_TEXT = "Read More";
    private static final String DEFAULT_COLLAPSE_TEXT = "Close";
    private static final String DOTS_CODE = "\u2026";
    private static final String SPACE_CODE = "\u00a0";
    private static final int ELLIPSIS_TYPE_DOTS = 0;
    private static final int ELLIPSIS_TYPE_NONE = 1;
    private String text;
    private String expandText = "Read More";
    private int expandTextColor;
    private int expandTextStyle = 0;
    private boolean expandTextUnderline = false;
    private String collapseText = "Close";
    private int collapseTextColor;
    private int collapseTextStyle = 0;
    private boolean collapseTextUnderline = false;
    private boolean collapsed;
    private boolean rebuild = true;
    private int lineWidth = 0;
    private int maxLines = 1;
    private int halfHeight = 0;
    private int fullHeight = 0;
    private boolean isAnimate = false;
    private boolean isEllipsized = false;
    private int durationExpand = 300;
    private int durationCollapse = 300;
    private ToggleListener toggleListener;
    private View.OnClickListener onClickExpand;
    private View.OnClickListener onClickCollapse;
    private int actionClickColor = 0;
    private int ellipsisType = 0;
    private SpannableStringBuilder spanCollapsed;
    private SpannableStringBuilder spanExpanded;
    private static long mLastClickTime = 0L;
    private int interpolatorExpand = 0;
    private int interpolatorCollapse = 0;

    public TextViewReadMore(@NonNull Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public TextViewReadMore(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public TextViewReadMore(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources.Theme theme = context.getTheme();
        if (theme != null) {
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.TextViewReadMore, defStyleAttr, 0);
            try {
                this.text = typedArray.getString(R.styleable.TextViewReadMore_android_text);
                int getMaxLines = typedArray.getInt(R.styleable.TextViewReadMore_readMoreMaxLines, this.maxLines);
                this.maxLines = Math.max(getMaxLines, this.maxLines);
                this.collapsed = typedArray.getBoolean(R.styleable.TextViewReadMore_collapsed, true);
                String getExpandText = typedArray.getString(R.styleable.TextViewReadMore_expandText);
                this.expandText = TextUtils.isEmpty((CharSequence)getExpandText) ? DEFAULT_EXPAND_TEXT : getExpandText;
                this.expandTextColor = typedArray.getColor(R.styleable.TextViewReadMore_expandTextColor, -16776961);
                this.expandTextStyle = typedArray.getInt(R.styleable.TextViewReadMore_expandTextStyle, 0);
                this.expandTextUnderline = typedArray.getBoolean(R.styleable.TextViewReadMore_expandTextUnderline, this.expandTextUnderline);
                String getCollapseText = typedArray.getString(R.styleable.TextViewReadMore_collapseText);
                this.collapseText = getCollapseText == null ? DEFAULT_COLLAPSE_TEXT : getCollapseText;
                this.collapseTextColor = typedArray.getColor(R.styleable.TextViewReadMore_collapseTextColor, -16776961);
                this.collapseTextStyle = typedArray.getInt(R.styleable.TextViewReadMore_collapseTextStyle, 0);
                this.collapseTextUnderline = typedArray.getBoolean(R.styleable.TextViewReadMore_collapseTextUnderline, this.collapseTextUnderline);
                int defaultActionClickColor = ContextCompat.getColor((Context)context, (int)R.color.text_view_read_more_button_hover_color);
                this.actionClickColor = typedArray.getColor(R.styleable.TextViewReadMore_actionClickColor, defaultActionClickColor);
                int getDuration = typedArray.getInt(R.styleable.TextViewReadMore_duration, 300);
                this.durationExpand = typedArray.getInt(R.styleable.TextViewReadMore_durationExpand, getDuration);
                this.durationCollapse = typedArray.getInt(R.styleable.TextViewReadMore_durationCollapse, getDuration);
                this.ellipsisType = typedArray.getInt(R.styleable.TextViewReadMore_ellipsisType, 0);
                int interpolator = typedArray.getInt(R.styleable.TextViewReadMore_interpolator, 0);
                this.interpolatorExpand = typedArray.getInt(R.styleable.TextViewReadMore_interpolatorExpand, interpolator);
                this.interpolatorCollapse = typedArray.getInt(R.styleable.TextViewReadMore_interpolatorCollapse, interpolator);
            }
            finally {
                typedArray.recycle();
            }
            this.setHighlightColor(0);
        }
    }

    public void collapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.rebuild = true;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.isAnimate) {
            this.rebuild = false;
        } else if (text instanceof Spanned) {
            this.rebuild = false;
        } else {
            this.text = text != null ? text.toString() : null;
            this.rebuild = true;
        }
        if (this.isEllipsized(text)) {
            if (this.spanExpanded != null && !this.collapsed) {
                super.setText((CharSequence)this.spanExpanded, type);
            } else if (this.spanCollapsed != null && this.collapsed) {
                super.setText((CharSequence)this.spanCollapsed, type);
            } else {
                super.setText(text, type);
            }
        } else {
            super.setText(text, type);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int givenWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sidePadding = this.getCompoundPaddingStart() + this.getCompoundPaddingEnd();
        this.lineWidth = givenWidth - sidePadding;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.rebuild) {
            this.buildSpan();
        }
    }

    private void buildSpan() {
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            this.isEllipsized = this.isEllipsized(this.text);
            if (this.isEllipsized) {
                if (this.rebuild) {
                    if (this.collapsed) {
                        StaticLayout layoutDefault = this.getStaticLayoutCollapsed(this.text);
                        int sumLineWidth = 0;
                        for (int i = 0; i < this.maxLines; ++i) {
                            int count = (int)layoutDefault.getLineWidth(i);
                            sumLineWidth += count;
                        }
                        float expandActionWidth = this.getPaint().measureText(" " + this.expandText);
                        float doubleExpandWith = expandActionWidth * 2.0f;
                        float truncatedTextWidth = (float)sumLineWidth - expandActionWidth;
                        if ((float)sumLineWidth < doubleExpandWith) {
                            truncatedTextWidth = sumLineWidth;
                        }
                        CharSequence truncatedText = TextUtils.ellipsize((CharSequence)this.text, (TextPaint)this.getPaint(), (float)truncatedTextWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                        Log.d((String)"Collapse", (String)truncatedText.toString());
                        String exp = this.expandText.replaceAll(" ", SPACE_CODE);
                        String finalText = truncatedText.toString();
                        if (this.ellipsisType == 1) {
                            finalText = truncatedText.toString().replace(DOTS_CODE, "");
                        }
                        String collapsedText = finalText + SPACE_CODE + exp;
                        StaticLayout layout = this.getStaticLayoutCollapsed(collapsedText);
                        this.spanCollapsed = this.spanCollapsed(collapsedText);
                        if (this.spanCollapsed != null) {
                            this.updateParam(layout.getHeight());
                            this.setText((CharSequence)this.spanCollapsed);
                        }
                        this.spanExpanded = this.spanExpanded();
                    } else {
                        this.spanExpanded = this.spanExpanded();
                        StaticLayout layout = this.getStaticLayout(this.spanExpanded.toString());
                        this.updateParam(layout.getHeight());
                        this.setText((CharSequence)this.spanExpanded);
                    }
                    if (this.isJustified()) {
                        this.setOnTouchListener(this.onTouchEvent());
                    } else {
                        this.setMovementMethod(LinkMovementMethod.getInstance());
                    }
                    this.rebuild = false;
                }
            } else {
                this.rebuild = false;
                StaticLayout layout = this.getStaticLayout(this.text);
                this.post(() -> this.updateParam(layout.getHeight()));
            }
        }
    }

    private boolean isEllipsized(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        StaticLayout layout = this.getStaticLayout(charSequence.toString());
        return layout.getLineCount() > this.maxLines;
    }

    private boolean isEllipsized(@Nullable String text) {
        if (text == null) {
            return false;
        }
        StaticLayout layout = this.getStaticLayout(text);
        return layout.getLineCount() > this.maxLines;
    }

    private SpannableStringBuilder spanCollapsed(String text) {
        if (text == null) {
            return null;
        }
        SpannableStringBuilder span = new SpannableStringBuilder((CharSequence)text);
        int start = text.length() - this.expandText.length();
        int end = text.length();
        span.setSpan((Object)new ForegroundColorSpan(this.expandTextColor), start, end, 17);
        if (this.expandTextStyle == 1) {
            this.boldText(span, start, end);
        } else if (this.expandTextStyle == 2) {
            this.italicText(span, start, end);
        } else if (this.expandTextStyle == 3) {
            this.boldText(span, start, end);
            this.italicText(span, start, end);
        }
        if (this.expandTextUnderline) {
            this.underlineText(span, start, end);
        }
        span.setSpan((Object)new ClickableSpan(){

            public void onClick(@NonNull View widget) {
                if (TextViewReadMore.this.onClickExpand != null) {
                    new Handler(Looper.getMainLooper()).postDelayed(() -> TextViewReadMore.this.onClickExpand.onClick(widget), 100L);
                }
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                if (!TextViewReadMore.this.expandTextUnderline) {
                    ds.setUnderlineText(false);
                }
                if (TextViewReadMore.this.isPressed()) {
                    ds.setColor(TextViewReadMore.this.actionClickColor);
                } else {
                    ds.setColor(TextViewReadMore.this.expandTextColor);
                }
                TextViewReadMore.this.invalidate();
            }
        }, start, end, 17);
        return span;
    }

    private SpannableStringBuilder spanExpanded() {
        String collapsedTextSpace = this.collapseText.replaceAll(" ", SPACE_CODE);
        String fullText = this.text + SPACE_CODE + collapsedTextSpace;
        this.spanExpanded = this.spanExpanded(fullText);
        return this.spanExpanded;
    }

    private SpannableStringBuilder spanExpanded(String text) {
        SpannableStringBuilder span = new SpannableStringBuilder((CharSequence)text);
        int start = text.length() - this.collapseText.length();
        int end = text.length();
        span.setSpan((Object)new ForegroundColorSpan(this.collapseTextColor), start, end, 17);
        if (this.collapseTextStyle == 1) {
            this.boldText(span, start, end);
        } else if (this.collapseTextStyle == 2) {
            this.italicText(span, start, end);
        } else if (this.collapseTextStyle == 3) {
            this.boldText(span, start, end);
            this.italicText(span, start, end);
        }
        if (this.collapseTextUnderline) {
            this.underlineText(span, start, end);
        }
        span.setSpan((Object)new ClickableSpan(){

            public void onClick(@NonNull View widget) {
                if (!TextViewReadMore.this.collapseText.isEmpty() && !TextViewReadMore.this.collapseText.equals(" ") && TextViewReadMore.this.onClickCollapse != null) {
                    new Handler(Looper.getMainLooper()).postDelayed(() -> TextViewReadMore.this.onClickCollapse.onClick(widget), 100L);
                }
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                if (!TextViewReadMore.this.collapseTextUnderline) {
                    ds.setUnderlineText(false);
                }
                if (TextViewReadMore.this.isPressed()) {
                    ds.setColor(TextViewReadMore.this.actionClickColor);
                } else {
                    ds.setColor(TextViewReadMore.this.collapseTextColor);
                }
                TextViewReadMore.this.invalidate();
            }
        }, start, end, 17);
        return span;
    }

    @SuppressLint(value={"RestrictedApi"})
    public void toggle() {
        int limitDuration = this.collapsed ? this.durationExpand : this.durationCollapse;
        int limit = Math.max(limitDuration, 1000);
        if (SystemClock.elapsedRealtime() - mLastClickTime <= (long)limit) {
            return;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        this.setMovementMethod(null);
        if (this.collapsed) {
            String collapsedTextSpace = this.collapseText.replaceAll(" ", SPACE_CODE);
            String fullText = this.text + SPACE_CODE + collapsedTextSpace;
            StaticLayout layoutFull = this.getStaticLayout(fullText);
            this.fullHeight = layoutFull.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
        } else {
            StaticLayout layoutCollapsed = this.getStaticLayoutCollapsed(this.text);
            this.halfHeight = layoutCollapsed.getHeight() + this.getPaddingTop() + this.getPaddingTop();
        }
        int end = this.collapsed ? this.fullHeight : this.halfHeight;
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{this.getHeight(), end});
        anim.setInterpolator(this.collapsed ? this.animationExpand() : this.animationCollapse());
        anim.setDuration(this.collapsed ? (long)this.durationExpand : (long)this.durationCollapse);
        ViewGroup.LayoutParams params = this.getLayoutParams();
        anim.addUpdateListener(animation -> {
            Object value = animation.getAnimatedValue();
            params.height = (Integer)value;
            this.setLayoutParams(params);
        });
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                TextViewReadMore.this.isAnimate = true;
                if (TextViewReadMore.this.collapsed) {
                    TextViewReadMore.this.collapsed = false;
                    TextViewReadMore.this.setText((CharSequence)TextViewReadMore.this.spanExpanded);
                    TextViewReadMore.this.collapsed = true;
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                TextViewReadMore.this.isAnimate = false;
                TextViewReadMore.this.collapsed = !TextViewReadMore.this.collapsed;
                TextViewReadMore.this.rebuild = true;
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    if (TextViewReadMore.this.toggleListener != null) {
                        TextViewReadMore.this.toggleListener.onToggle(TextViewReadMore.this.collapsed);
                    }
                }, 0L);
            }
        });
        if (this.isEllipsized) {
            anim.start();
        }
    }

    public void setInterpolator(int interpolator) {
        this.interpolatorExpand = interpolator;
        this.interpolatorCollapse = interpolator;
    }

    public void setInterpolatorExpand(int interpolator) {
        this.interpolatorExpand = interpolator;
    }

    public void setInterpolatorCollapse(int interpolator) {
        this.interpolatorCollapse = interpolator;
    }

    private TimeInterpolator animationExpand() {
        return this.animation(this.interpolatorExpand);
    }

    private TimeInterpolator animationCollapse() {
        return this.animation(this.interpolatorCollapse);
    }

    private TimeInterpolator animation(int value) {
        return switch (value) {
            case 1 -> new AccelerateInterpolator();
            case 2 -> new AnticipateOvershootInterpolator();
            case 3 -> new AnticipateInterpolator();
            case 4 -> new BounceInterpolator();
            case 5 -> new FastOutLinearInInterpolator();
            case 6 -> new FastOutSlowInInterpolator();
            case 7 -> new LinearOutSlowInInterpolator();
            default -> new DecelerateInterpolator();
        };
    }

    private void italicText(SpannableStringBuilder builder, int start, int end) {
        builder.setSpan((Object)new StyleSpan(2), start, end, 17);
    }

    private void boldText(SpannableStringBuilder builder, int start, int end) {
        builder.setSpan((Object)new StyleSpan(1), start, end, 17);
    }

    private void underlineText(SpannableStringBuilder builder, int start, int end) {
        builder.setSpan((Object)new UnderlineSpan(), start, end, 17);
    }

    public void toggleListener(ToggleListener toggleListener) {
        this.toggleListener = toggleListener;
    }

    public void onClickExpand(View.OnClickListener onClickExpand) {
        this.onClickExpand = onClickExpand;
    }

    public void onClickCollapse(View.OnClickListener onClickCollapse) {
        this.onClickCollapse = onClickCollapse;
    }

    public void setDuration(long millis) {
        int value;
        this.durationExpand = value = (int)millis;
        this.durationCollapse = value;
    }

    public void setDuration(double seconds) {
        int value;
        this.durationExpand = value = (int)seconds * 1000;
        this.durationCollapse = value;
    }

    public void setDurationExpand(long millis) {
        this.durationExpand = (int)millis;
    }

    public void setDurationExpand(double seconds) {
        this.durationExpand = (int)seconds * 1000;
    }

    public void setDurationCollapse(long millis) {
        this.durationCollapse = (int)millis;
    }

    public void setDurationCollapse(double seconds) {
        this.durationCollapse = (int)seconds * 1000;
    }

    private String ellipsize(String text, int size) {
        if (text.isEmpty() || size <= 0) {
            return "";
        }
        if (text.length() <= size) {
            return text;
        }
        return text.substring(0, Math.max(size - 1, 0)) + "...";
    }

    private void updateParam(int height) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        int paddings = this.getPaddingTop() + this.getPaddingBottom();
        params.height = height + paddings;
        this.setLayoutParams(params);
    }

    private StaticLayout getStaticLayout(@Nullable String source) {
        String mSource = source == null ? "" : source;
        StaticLayout layout = Build.VERSION.SDK_INT >= 23 ? StaticLayout.Builder.obtain((CharSequence)mSource, (int)0, (int)mSource.length(), (TextPaint)this.getPaint(), (int)this.lineWidth).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setAlignment(Layout.Alignment.ALIGN_NORMAL).build() : new StaticLayout((CharSequence)mSource, this.getPaint(), this.lineWidth, Layout.Alignment.ALIGN_NORMAL, this.getLineSpacingMultiplier(), this.getLineSpacingExtra(), this.getIncludeFontPadding());
        return layout;
    }

    private StaticLayout getStaticLayoutCollapsed(@Nullable String source) {
        StaticLayout layout;
        String mSource;
        String string = mSource = source == null ? "" : source;
        if (Build.VERSION.SDK_INT >= 23) {
            layout = StaticLayout.Builder.obtain((CharSequence)mSource, (int)0, (int)mSource.length(), (TextPaint)this.getPaint(), (int)this.lineWidth).setMaxLines(this.maxLines).setEllipsize(TextUtils.TruncateAt.END).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setAlignment(Layout.Alignment.ALIGN_NORMAL).build();
        } else {
            int maxLength = mSource.length();
            do {
                layout = new StaticLayout((CharSequence)this.ellipsize(mSource, maxLength), this.getPaint(), this.lineWidth, Layout.Alignment.ALIGN_NORMAL, this.getLineSpacingMultiplier(), this.getLineSpacingExtra(), this.getIncludeFontPadding());
                maxLength -= 10;
            } while (layout.getLineCount() > 2);
        }
        return layout;
    }

    private boolean isJustified() {
        boolean isJustified = false;
        if (Build.VERSION.SDK_INT >= 26 && this.getJustificationMode() == 1) {
            isJustified = true;
        }
        return isJustified;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private View.OnTouchListener onTouchEvent() {
        return (v, event) -> {
            if (v instanceof TextView) {
                TextView tv = (TextView)v;
                if (event.getAction() == 1) {
                    Spanned spannable;
                    ClickableSpan[] links;
                    int x = (int)(event.getX() - (float)tv.getTotalPaddingLeft() + (float)tv.getScrollX());
                    int y = (int)(event.getY() - (float)tv.getTotalPaddingTop() + (float)tv.getScrollY());
                    int line = tv.getLayout().getLineForVertical(y);
                    int offset = tv.getLayout().getOffsetForHorizontal(line, (float)x);
                    CharSequence patt25928$temp = tv.getText();
                    if (patt25928$temp instanceof Spanned && (links = (ClickableSpan[])(spannable = (Spanned)patt25928$temp).getSpans(offset, offset, ClickableSpan.class)).length > 0) {
                        links[0].onClick((View)tv);
                    }
                }
            }
            return true;
        };
    }
}

