/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.engine;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.view.Surface;
import net.ypresto.androidtranscoder.engine.TextureRender;

class OutputSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "OutputSurface";
    private static final boolean VERBOSE = false;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private Object mFrameSyncObject = new Object();
    private boolean mFrameAvailable;
    private TextureRender mTextureRender;

    public OutputSurface(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        this.eglSetup(width, height);
        this.makeCurrent();
        this.setup();
    }

    public OutputSurface() {
        this.setup();
    }

    private void setup() {
        this.mTextureRender = new TextureRender();
        this.mTextureRender.surfaceCreated();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureRender.getTextureId());
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mSurface = new Surface(this.mSurfaceTexture);
    }

    private void eglSetup(int width, int height) {
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12339, 1, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new RuntimeException("unable to find RGB888+recordable ES2 EGL config");
        }
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attrib_list, (int)0);
        this.checkEglError("eglCreateContext");
        if (this.mEGLContext == null) {
            throw new RuntimeException("null context");
        }
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        this.mEGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreatePbufferSurface");
        if (this.mEGLSurface == null) {
            throw new RuntimeException("surface was null");
        }
    }

    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mSurface.release();
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mTextureRender = null;
        this.mSurface = null;
        this.mSurfaceTexture = null;
    }

    public void makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public void changeFragmentShader(String fragmentShader) {
        this.mTextureRender.changeFragmentShader(fragmentShader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitNewImage() {
        int TIMEOUT_MS = 10000;
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    this.mFrameSyncObject.wait(10000L);
                    if (this.mFrameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            this.mFrameAvailable = false;
        }
        this.mTextureRender.checkGlError("before updateTexImage");
        this.mSurfaceTexture.updateTexImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForNewImage(int timeoutMs) {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    this.mFrameSyncObject.wait(timeoutMs);
                    if (this.mFrameAvailable) continue;
                    return false;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            this.mFrameAvailable = false;
        }
        this.mTextureRender.checkGlError("before updateTexImage");
        this.mSurfaceTexture.updateTexImage();
        return true;
    }

    public void drawImage() {
        this.mTextureRender.drawFrame(this.mSurfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            if (this.mFrameAvailable) {
                throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
            }
            this.mFrameAvailable = true;
            this.mFrameSyncObject.notifyAll();
        }
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

