/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder;

import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.ypresto.androidtranscoder.engine.MediaTranscoderEngine;
import net.ypresto.androidtranscoder.format.MediaFormatPresets;
import net.ypresto.androidtranscoder.format.MediaFormatStrategy;

public class MediaTranscoder {
    private static final String TAG = "MediaTranscoder";
    private static final int MAXIMUM_THREAD = 1;
    private static volatile MediaTranscoder sMediaTranscoder;
    private ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "MediaTranscoder-Worker");
        }
    });

    private MediaTranscoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaTranscoder getInstance() {
        if (sMediaTranscoder != null) return sMediaTranscoder;
        Class<MediaTranscoder> clazz = MediaTranscoder.class;
        synchronized (MediaTranscoder.class) {
            if (sMediaTranscoder != null) return sMediaTranscoder;
            sMediaTranscoder = new MediaTranscoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMediaTranscoder;
        }
    }

    @Deprecated
    public Future<Void> transcodeVideo(FileDescriptor inFileDescriptor, String outPath, Listener listener, long maxVideoDuration) {
        return this.transcodeVideo(inFileDescriptor, outPath, new MediaFormatStrategy(){

            @Override
            public MediaFormat createVideoOutputFormat(MediaFormat inputFormat) {
                return MediaFormatPresets.getExportPreset960x540();
            }

            @Override
            public MediaFormat createAudioOutputFormat(MediaFormat inputFormat) {
                return null;
            }
        }, listener, maxVideoDuration);
    }

    public Future<Void> transcodeVideo(String inPath, String outPath, MediaFormatStrategy outFormatStrategy, final Listener listener, long maxVideoDuration) throws IOException {
        FileDescriptor inFileDescriptor;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(inPath);
            inFileDescriptor = fileInputStream.getFD();
        }
        catch (IOException e) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException eClose) {
                    Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)eClose);
                }
            }
            throw e;
        }
        final FileInputStream finalFileInputStream = fileInputStream;
        return this.transcodeVideo(inFileDescriptor, outPath, outFormatStrategy, new Listener(){

            @Override
            public void onTranscodeProgress(double progress) {
                listener.onTranscodeProgress(progress);
            }

            @Override
            public void onTranscodeCompleted() {
                this.closeStream();
                listener.onTranscodeCompleted();
            }

            @Override
            public void onTranscodeCanceled() {
                this.closeStream();
                listener.onTranscodeCanceled();
            }

            @Override
            public void onTranscodeFailed(Exception exception) {
                this.closeStream();
                listener.onTranscodeFailed(exception);
            }

            private void closeStream() {
                try {
                    finalFileInputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)MediaTranscoder.TAG, (String)"Can't close input stream: ", (Throwable)e);
                }
            }
        }, maxVideoDuration);
    }

    public Future<Void> transcodeVideo(final FileDescriptor inFileDescriptor, final String outPath, final MediaFormatStrategy outFormatStrategy, final Listener listener, final long maxVideoDuration) {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        final Handler handler = new Handler(looper);
        final AtomicReference<Future<Void>> futureReference = new AtomicReference<Future<Void>>();
        Future<Void> createdFuture = this.mExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Exception caughtException = null;
                try {
                    MediaTranscoderEngine engine = new MediaTranscoderEngine();
                    engine.setProgressCallback(new MediaTranscoderEngine.ProgressCallback(){

                        @Override
                        public void onProgress(final double progress) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onTranscodeProgress(progress);
                                }
                            });
                        }
                    });
                    engine.setDataSource(inFileDescriptor);
                    engine.setMaxVideoDuration(maxVideoDuration);
                    engine.transcodeVideo(outPath, outFormatStrategy);
                }
                catch (IOException e) {
                    Log.w((String)MediaTranscoder.TAG, (String)("Transcode failed: input file (fd: " + inFileDescriptor.toString() + ") not found or could not open output file ('" + outPath + "') ."), (Throwable)e);
                    caughtException = e;
                }
                catch (InterruptedException e) {
                    Log.i((String)MediaTranscoder.TAG, (String)"Cancel transcode video file.", (Throwable)e);
                    caughtException = e;
                }
                catch (RuntimeException e) {
                    Log.e((String)MediaTranscoder.TAG, (String)"Fatal error while transcoding, this might be invalid format or bug in engine or Android.", (Throwable)e);
                    caughtException = e;
                }
                final Exception exception = caughtException;
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (exception == null) {
                            listener.onTranscodeCompleted();
                        } else {
                            Future future = (Future)futureReference.get();
                            if (future != null && future.isCancelled()) {
                                listener.onTranscodeCanceled();
                            } else {
                                listener.onTranscodeFailed(exception);
                            }
                        }
                    }
                });
                if (exception != null) {
                    throw exception;
                }
                return null;
            }
        });
        futureReference.set(createdFuture);
        return createdFuture;
    }

    public static interface Listener {
        public void onTranscodeProgress(double var1);

        public void onTranscodeCompleted();

        public void onTranscodeCanceled();

        public void onTranscodeFailed(Exception var1);
    }
}

