/*
 * Decompiled with CFR 0.152.
 */
package com.eralp.circleprogressview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.eralp.circleprogressview.ProgressAnimationListener;
import com.eralp.circleprogressview.R;

public class CircleProgressView
extends View {
    private float mProgress;
    private float mCircleWidth;
    private float backgroundStrokeWidth;
    private int mCircleColor;
    private int mBackgroundColor;
    private int mTextColor;
    private RectF mRectF;
    private Paint mBackgroundPaint;
    private Paint mCirclePaint;
    private Interpolator mInterpolator;
    private boolean mIsTextEnabled;
    private String mTextPrefix;
    private String mTextSuffix;
    private float mStartAngle;
    private TextView mTextView;
    private int mTextSize;
    LinearLayout mLayout;
    private ProgressAnimationListener progressAnimationListener;

    public CircleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mRectF = new RectF();
        this.setDefaultValues();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, 0, 0);
        try {
            this.mProgress = typedArray.getFloat(R.styleable.CircularProgressView_cpv_progress, this.mProgress);
            this.mCircleWidth = typedArray.getDimension(R.styleable.CircularProgressView_cpv_circle_width, this.mCircleWidth);
            this.backgroundStrokeWidth = typedArray.getDimension(R.styleable.CircularProgressView_cpv_background_circle_width, this.backgroundStrokeWidth);
            this.mCircleColor = typedArray.getInt(R.styleable.CircularProgressView_cpv_circle_color, this.mCircleColor);
            this.mBackgroundColor = typedArray.getInt(R.styleable.CircularProgressView_cpv_background_circle_color, this.mBackgroundColor);
            this.mTextColor = typedArray.getInt(R.styleable.CircularProgressView_cpv_text_color, this.mTextColor);
            this.mTextSize = typedArray.getInt(R.styleable.CircularProgressView_cpv_text_size, this.mTextSize);
            this.mTextPrefix = typedArray.getString(R.styleable.CircularProgressView_cpv_text_prefix);
            this.mTextSuffix = typedArray.getString(R.styleable.CircularProgressView_cpv_text_suffix);
        }
        finally {
            typedArray.recycle();
        }
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setStrokeWidth(this.backgroundStrokeWidth);
        this.mCirclePaint = new Paint(1);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setStrokeWidth(this.mCircleWidth);
        this.mTextView = new TextView(context);
        this.mTextView.setVisibility(0);
        this.mTextView.setTextSize((float)this.mTextSize);
        this.mTextView.setTextColor(this.mTextColor);
        this.mLayout = new LinearLayout(context);
        this.mLayout.addView((View)this.mTextView);
        this.showTextView(this.mIsTextEnabled);
    }

    private void showTextView(boolean mIsTextEnabled) {
        this.mTextView.setText((CharSequence)(this.getTextPrefix() + String.valueOf(Math.round(this.mProgress)) + this.getTextSuffix()));
        this.mTextView.setVisibility(mIsTextEnabled ? 0 : 8);
        this.invalidate();
    }

    private void setDefaultValues() {
        this.mProgress = 0.0f;
        this.mCircleWidth = this.getResources().getDimension(R.dimen.default_circle_width);
        this.backgroundStrokeWidth = this.getResources().getDimension(R.dimen.default_circle_background_width);
        this.mCircleColor = -16777216;
        this.mTextColor = -16777216;
        this.mBackgroundColor = -7829368;
        this.mStartAngle = -90.0f;
        this.mIsTextEnabled = true;
        this.mTextSize = 20;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawOval(this.mRectF, this.mBackgroundPaint);
        float angle = 360.0f * this.mProgress / 100.0f;
        canvas.drawArc(this.mRectF, this.mStartAngle, angle, false, this.mCirclePaint);
        this.mLayout.measure(canvas.getWidth(), canvas.getHeight());
        this.mLayout.layout(0, 0, canvas.getWidth(), canvas.getHeight());
        canvas.translate((float)(canvas.getWidth() / 2 - this.mTextView.getWidth() / 2), (float)(canvas.getHeight() / 2 - this.mTextView.getHeight() / 2));
        this.mLayout.draw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = CircleProgressView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = CircleProgressView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        float stroke = this.mCircleWidth > this.backgroundStrokeWidth ? this.mCircleWidth : this.backgroundStrokeWidth;
        this.mRectF.set(0.0f + stroke / 2.0f, 0.0f + stroke / 2.0f, (float)min - stroke / 2.0f, (float)min - stroke / 2.0f);
    }

    public float getCircleWidth() {
        return this.mCircleWidth;
    }

    public void setCirclerWidth(float circleWidth) {
        this.mCircleWidth = circleWidth;
        this.mCirclePaint.setStrokeWidth(circleWidth);
        this.requestLayout();
        this.invalidate();
    }

    public int getCircleColor() {
        return this.mCircleColor;
    }

    public void setCircleColor(int circleColor) {
        this.mCircleColor = circleColor;
        this.mCirclePaint.setColor(circleColor);
        this.invalidate();
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public String getTextPrefix() {
        return this.mTextPrefix != null ? this.mTextPrefix : "";
    }

    public void setTextPrefix(String textPrefix) {
        this.mTextPrefix = textPrefix;
        this.showTextView(this.mIsTextEnabled);
    }

    public String getTextSuffix() {
        return this.mTextSuffix != null ? this.mTextSuffix : "";
    }

    public void setTextSuffix(String textSuffix) {
        this.mTextSuffix = textSuffix;
        this.showTextView(this.mIsTextEnabled);
    }

    public float getProgress() {
        return this.mProgress;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
        this.mTextView.setTextSize((float)textSize);
        this.invalidate();
    }

    public boolean isTextEnabled() {
        return this.mIsTextEnabled;
    }

    public void setTextEnabled(boolean isTextEnabled) {
        this.mIsTextEnabled = isTextEnabled;
        this.showTextView(isTextEnabled);
    }

    public float getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(float startAngle) {
        this.mStartAngle = startAngle;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mTextView.setTextColor(textColor);
        this.invalidate();
    }

    public void setProgress(float progress) {
        this.mProgress = progress <= 100.0f ? progress : 100.0f;
        this.mTextView.setText((CharSequence)(this.mTextPrefix + String.valueOf(Math.round(this.mProgress)) + this.mTextSuffix));
        this.showTextView(this.mIsTextEnabled);
        this.invalidate();
        if (this.progressAnimationListener != null) {
            this.progressAnimationListener.onValueChanged(progress);
        }
    }

    public void setProgressWithAnimation(final float progress, int duration) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{progress});
        objectAnimator.setDuration((long)duration);
        objectAnimator.setInterpolator((TimeInterpolator)(this.mInterpolator != null ? this.mInterpolator : new DecelerateInterpolator()));
        objectAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                CircleProgressView.this.mProgress = progress <= 100.0f ? progress : 100.0f;
                if (CircleProgressView.this.progressAnimationListener != null) {
                    CircleProgressView.this.progressAnimationListener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircleProgressView.this.mTextView.setText((CharSequence)(CircleProgressView.this.mTextPrefix + String.valueOf(Math.round(((Float)animation.getAnimatedValue()).floatValue())) + CircleProgressView.this.mTextSuffix));
            }
        });
        objectAnimator.start();
        if (this.progressAnimationListener != null) {
            this.progressAnimationListener.onValueChanged(progress);
        }
    }

    public ProgressAnimationListener getProgressAnimationListener() {
        return this.progressAnimationListener;
    }

    public void addAnimationListener(ProgressAnimationListener progressAnimationListener) {
        this.progressAnimationListener = progressAnimationListener;
    }
}

