/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import org.phoenixframework.channels.Channel;
import org.phoenixframework.channels.ChannelEvent;
import org.phoenixframework.channels.Envelope;
import org.phoenixframework.channels.IErrorCallback;
import org.phoenixframework.channels.IMessageCallback;
import org.phoenixframework.channels.ISocketCloseCallback;
import org.phoenixframework.channels.ISocketOpenCallback;

public class Socket {
    private static final Logger LOG = Logger.getLogger(Socket.class.getName());
    public static final int RECONNECT_INTERVAL_MS = 5000;
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 7000;
    private final List<Channel> channels = new ArrayList<Channel>();
    private String endpointUri = null;
    private final Set<IErrorCallback> errorCallbacks = Collections.newSetFromMap(new HashMap());
    private final int heartbeatInterval;
    private TimerTask heartbeatTimerTask = null;
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Set<IMessageCallback> messageCallbacks = Collections.newSetFromMap(new HashMap());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean reconnectOnFailure = true;
    private TimerTask reconnectTimerTask = null;
    private int refNo = 1;
    private final LinkedBlockingQueue<RequestBody> sendBuffer = new LinkedBlockingQueue();
    private final Set<ISocketCloseCallback> socketCloseCallbacks = Collections.newSetFromMap(new HashMap());
    private final Set<ISocketOpenCallback> socketOpenCallbacks = Collections.newSetFromMap(new HashMap());
    private Timer timer = null;
    private WebSocket webSocket = null;
    private final PhoenixWSListener wsListener = new PhoenixWSListener();

    public Socket(String endpointUri) throws IOException {
        this(endpointUri, 7000);
    }

    public Socket(String endpointUri, int heartbeatIntervalInMs) {
        LOG.log(Level.FINE, "PhoenixSocket({0})", endpointUri);
        this.endpointUri = endpointUri;
        this.heartbeatInterval = heartbeatIntervalInMs;
        this.timer = new Timer("Reconnect Timer for " + endpointUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel chan(String topic, JsonNode payload) {
        LOG.log(Level.FINE, "chan: {0}, {1}", new Object[]{topic, payload});
        Channel channel = new Channel(topic, payload, this);
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.add(channel);
        }
        return channel;
    }

    public void connect() throws IOException {
        LOG.log(Level.FINE, "connect");
        this.disconnect();
        String httpUrl = this.endpointUri.replaceFirst("^ws:", "http:").replaceFirst("^wss:", "https:");
        Request request = new Request.Builder().url(httpUrl).build();
        WebSocketCall wsCall = WebSocketCall.create((OkHttpClient)this.httpClient, (Request)request);
        wsCall.enqueue((WebSocketListener)this.wsListener);
    }

    public void disconnect() throws IOException {
        LOG.log(Level.FINE, "disconnect");
        if (this.webSocket != null) {
            this.webSocket.close(1001, "Disconnected by client");
        }
        this.cancelHeartbeatTimer();
        this.cancelReconnectTimer();
    }

    public boolean isConnected() {
        return this.webSocket != null;
    }

    public Socket onClose(ISocketCloseCallback callback) {
        this.socketCloseCallbacks.add(callback);
        return this;
    }

    public Socket onError(IErrorCallback callback) {
        this.errorCallbacks.add(callback);
        return this;
    }

    public Socket onMessage(IMessageCallback callback) {
        this.messageCallbacks.add(callback);
        return this;
    }

    public Socket onOpen(ISocketOpenCallback callback) {
        this.cancelReconnectTimer();
        this.socketOpenCallbacks.add(callback);
        return this;
    }

    public Socket push(Envelope envelope) throws IOException {
        LOG.log(Level.FINE, "Pushing envelope: {0}", envelope);
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("topic", envelope.getTopic());
        node.put("event", envelope.getEvent());
        node.put("ref", envelope.getRef());
        node.set("payload", (JsonNode)(envelope.getPayload() == null ? this.objectMapper.createObjectNode() : envelope.getPayload()));
        String json = this.objectMapper.writeValueAsString((Object)node);
        LOG.log(Level.FINE, "Sending JSON: {0}", json);
        RequestBody body = RequestBody.create((MediaType)WebSocket.TEXT, (String)json);
        if (this.isConnected()) {
            try {
                this.webSocket.sendMessage(body);
            }
            catch (IllegalStateException e) {
                LOG.log(Level.SEVERE, "Attempted to send push when socket is not open", e);
            }
        } else {
            this.sendBuffer.add(body);
        }
        return this;
    }

    public void reconectOnFailure(boolean reconnectOnFailure) {
        this.reconnectOnFailure = reconnectOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Channel channel) {
        List<Channel> list = this.channels;
        synchronized (list) {
            Iterator<Channel> chanIter = this.channels.iterator();
            while (chanIter.hasNext()) {
                if (chanIter.next() != channel) continue;
                chanIter.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChannels() {
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.clear();
        }
    }

    public String toString() {
        return "PhoenixSocket{endpointUri='" + this.endpointUri + '\'' + ", channels=" + this.channels + ", refNo=" + this.refNo + ", webSocket=" + this.webSocket + '}';
    }

    synchronized String makeRef() {
        int val = this.refNo++;
        if (this.refNo == Integer.MAX_VALUE) {
            this.refNo = 0;
        }
        return Integer.toString(val);
    }

    private void cancelHeartbeatTimer() {
        if (this.heartbeatTimerTask != null) {
            this.heartbeatTimerTask.cancel();
        }
    }

    private void cancelReconnectTimer() {
        if (this.reconnectTimerTask != null) {
            this.reconnectTimerTask.cancel();
        }
    }

    private void flushSendBuffer() {
        while (this.isConnected() && !this.sendBuffer.isEmpty()) {
            RequestBody body = (RequestBody)this.sendBuffer.remove();
            try {
                this.webSocket.sendMessage(body);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to send payload {0}", body);
            }
        }
    }

    private void scheduleReconnectTimer() {
        this.cancelReconnectTimer();
        this.cancelHeartbeatTimer();
        this.reconnectTimerTask = new TimerTask(){

            @Override
            public void run() {
                LOG.log(Level.FINE, "reconnectTimerTask run");
                try {
                    Socket.this.connect();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to reconnect to " + Socket.this.wsListener, e);
                }
            }
        };
        this.timer.schedule(this.reconnectTimerTask, 5000L);
    }

    private void startHeartbeatTimer() {
        this.heartbeatTimerTask = new TimerTask(){

            @Override
            public void run() {
                LOG.log(Level.FINE, "heartbeatTimerTask run");
                if (Socket.this.isConnected()) {
                    try {
                        Envelope envelope = new Envelope("phoenix", "heartbeat", (JsonNode)new ObjectNode(JsonNodeFactory.instance), Socket.this.makeRef());
                        Socket.this.push(envelope);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to send heartbeat", e);
                    }
                }
            }
        };
        this.timer.schedule(this.heartbeatTimerTask, this.heartbeatInterval, (long)this.heartbeatInterval);
    }

    private void triggerChannelError() {
        for (Channel channel : this.channels) {
            channel.trigger(ChannelEvent.ERROR.getPhxEvent(), null);
        }
    }

    static String replyEventName(String ref) {
        return "chan_reply_" + ref;
    }

    public class PhoenixWSListener
    implements WebSocketListener {
        public void onClose(int code, String reason) {
            LOG.log(Level.FINE, "WebSocket onClose {0}/{1}", new Object[]{code, reason});
            Socket.this.webSocket = null;
            for (ISocketCloseCallback callback : Socket.this.socketCloseCallbacks) {
                callback.onClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(IOException e, Response response) {
            LOG.log(Level.WARNING, "WebSocket connection error", e);
            try {
                for (IErrorCallback callback : Socket.this.errorCallbacks) {
                    Socket.this.triggerChannelError();
                    callback.onError(e.toString());
                }
            }
            finally {
                if (Socket.this.webSocket != null) {
                    try {
                        Socket.this.webSocket.close(1001, "EOF received");
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, "Failed to explicitly close following failure");
                    }
                    finally {
                        Socket.this.webSocket = null;
                    }
                }
                if (Socket.this.reconnectOnFailure) {
                    Socket.this.scheduleReconnectTimer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ResponseBody payload) throws IOException {
            block10: {
                LOG.log(Level.FINE, "Envelope received: {0}", payload);
                try {
                    if (payload.contentType() != WebSocket.TEXT) break block10;
                    Envelope envelope = (Envelope)Socket.this.objectMapper.readValue(payload.byteStream(), Envelope.class);
                    List list = Socket.this.channels;
                    synchronized (list) {
                        for (Channel channel : Socket.this.channels) {
                            if (!channel.isMember(envelope.getTopic())) continue;
                            channel.trigger(envelope.getEvent(), envelope);
                        }
                    }
                    for (IMessageCallback callback : Socket.this.messageCallbacks) {
                        callback.onMessage(envelope);
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to read message payload", e);
                }
                finally {
                    payload.close();
                }
            }
        }

        public void onOpen(WebSocket webSocket, Response response) {
            LOG.log(Level.FINE, "WebSocket onOpen: {0}", webSocket);
            Socket.this.webSocket = webSocket;
            Socket.this.cancelReconnectTimer();
            Socket.this.startHeartbeatTimer();
            for (ISocketOpenCallback callback : Socket.this.socketOpenCallbacks) {
                callback.onOpen();
            }
            Socket.this.flushSendBuffer();
        }

        public void onPong(Buffer payload) {
            LOG.log(Level.INFO, "PONG received: {0}", payload);
        }
    }
}

