/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.logging.Logger;
import org.phoenixframework.channels.Socket;

public class Envelope {
    private static final Logger LOG = Logger.getLogger(Socket.class.getName());
    @JsonProperty
    private String topic;
    @JsonProperty
    private String event;
    @JsonProperty(value="payload")
    private JsonNode payload;
    @JsonProperty
    private String ref;

    public Envelope() {
    }

    public Envelope(String topic, String event, JsonNode payload, String ref) {
        this.topic = topic;
        this.event = event;
        this.payload = payload;
        this.ref = ref;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getEvent() {
        return this.event;
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    public String getRef() {
        if (this.ref != null) {
            return this.ref;
        }
        JsonNode refNode = this.payload.get("ref");
        return refNode != null ? refNode.textValue() : null;
    }

    public String getResponseStatus() {
        JsonNode statusNode = this.payload.get("status");
        return statusNode == null ? null : statusNode.textValue();
    }

    public String getReason() {
        JsonNode reasonNode = this.payload.get("reason");
        return reasonNode == null ? null : reasonNode.textValue();
    }

    public String toString() {
        return "Envelope{topic='" + this.topic + '\'' + ", event='" + this.event + '\'' + ", payload=" + this.payload + '}';
    }
}

