/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework.channels;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.phoenixframework.channels.Channel;
import org.phoenixframework.channels.Envelope;
import org.phoenixframework.channels.IMessageCallback;
import org.phoenixframework.channels.ITimeoutCallback;
import org.phoenixframework.channels.Socket;

public class Push {
    private static final Logger LOG = Logger.getLogger(Push.class.getName());
    private Channel channel = null;
    private String event = null;
    private String refEvent = null;
    private JsonNode payload = null;
    private Envelope receivedEnvelope = null;
    private Map<String, List<IMessageCallback>> recHooks = new HashMap<String, List<IMessageCallback>>();
    private boolean sent = false;
    private TimeoutHook timeoutHook;

    Push(Channel channel, String event, JsonNode payload, long timeout) {
        this.channel = channel;
        this.event = event;
        this.payload = payload;
        this.timeoutHook = new TimeoutHook(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Push receive(String status, IMessageCallback callback) {
        String receivedStatus;
        if (this.receivedEnvelope != null && (receivedStatus = this.receivedEnvelope.getResponseStatus()) != null && receivedStatus.equals(status)) {
            callback.onMessage(this.receivedEnvelope);
        }
        Map<String, List<IMessageCallback>> map = this.recHooks;
        synchronized (map) {
            List<IMessageCallback> statusHooks = this.recHooks.get(status);
            if (statusHooks == null) {
                statusHooks = new ArrayList<IMessageCallback>();
                this.recHooks.put(status, statusHooks);
            }
            statusHooks.add(callback);
        }
        return this;
    }

    public Push timeout(ITimeoutCallback callback) {
        if (this.timeoutHook.hasCallback()) {
            throw new IllegalStateException("Only a single after hook can be applied to a Push");
        }
        this.timeoutHook.setCallback(callback);
        return this;
    }

    void send() throws IOException {
        String ref = this.channel.getSocket().makeRef();
        LOG.log(Level.FINE, "Push send, ref={0}", ref);
        this.refEvent = Socket.replyEventName(ref);
        this.receivedEnvelope = null;
        this.channel.on(this.refEvent, new IMessageCallback(){

            @Override
            public void onMessage(Envelope envelope) {
                Push.this.receivedEnvelope = envelope;
                Push.this.matchReceive(Push.this.receivedEnvelope.getResponseStatus(), envelope);
                Push.this.cancelRefEvent();
                Push.this.cancelTimeout();
            }
        });
        this.startTimeout();
        this.sent = true;
        Envelope envelope = new Envelope(this.channel.getTopic(), this.event, this.payload, ref);
        this.channel.getSocket().push(envelope);
    }

    private void cancelTimeout() {
        this.timeoutHook.getTimerTask().cancel();
        this.timeoutHook.setTimerTask(null);
    }

    private void startTimeout() {
        this.timeoutHook.setTimerTask(this.createTimerTask());
        this.channel.scheduleTask(this.timeoutHook.getTimerTask(), this.timeoutHook.getMs());
    }

    private TimerTask createTimerTask() {
        final Runnable callback = new Runnable(){

            @Override
            public void run() {
                Push.this.cancelRefEvent();
                if (Push.this.timeoutHook.hasCallback()) {
                    Push.this.timeoutHook.getCallback().onTimeout();
                }
            }
        };
        return new TimerTask(){

            @Override
            public void run() {
                callback.run();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchReceive(String status, Envelope envelope) {
        Map<String, List<IMessageCallback>> map = this.recHooks;
        synchronized (map) {
            List<IMessageCallback> statusCallbacks = this.recHooks.get(status);
            if (statusCallbacks != null) {
                for (IMessageCallback callback : statusCallbacks) {
                    callback.onMessage(envelope);
                }
            }
        }
    }

    Channel getChannel() {
        return this.channel;
    }

    String getEvent() {
        return this.event;
    }

    JsonNode getPayload() {
        return this.payload;
    }

    Envelope getReceivedEnvelope() {
        return this.receivedEnvelope;
    }

    Map<String, List<IMessageCallback>> getRecHooks() {
        return this.recHooks;
    }

    boolean isSent() {
        return this.sent;
    }

    private void cancelRefEvent() {
        this.channel.off(this.refEvent);
    }

    private class TimeoutHook {
        private final long ms;
        private ITimeoutCallback callback;
        private TimerTask timerTask;

        public TimeoutHook(long ms) {
            this.ms = ms;
        }

        public long getMs() {
            return this.ms;
        }

        public ITimeoutCallback getCallback() {
            return this.callback;
        }

        public TimerTask getTimerTask() {
            return this.timerTask;
        }

        public void setTimerTask(TimerTask timerTask) {
            this.timerTask = timerTask;
        }

        public boolean hasCallback() {
            return this.callback != null;
        }

        public void setCallback(ITimeoutCallback callback) {
            this.callback = callback;
        }
    }
}

