/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.input;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.alimuzaffar.lib.pin.PinEntryEditText;
import com.google.android.material.textfield.TextInputLayout;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.input.SimpleInputDialog;

public class SimplePinDialog
extends CustomViewDialog<SimplePinDialog> {
    public static final String TAG = "SimplePinDialog.";
    public static final String PIN = "SimplePinDialog.pin";
    protected static final String MASK = "SimplePinDialog.mask";
    protected static final String LENGTH = "SimplePinDialog.length";
    protected static final String CHECK_PIN = "SimplePinDialog.checkPin";
    private PinEntryEditText mInput;
    private TextInputLayout mInputLayout;

    public static SimplePinDialog build() {
        return new SimplePinDialog();
    }

    public SimplePinDialog length(int length) {
        return (SimplePinDialog)((Object)this.setArg(LENGTH, length));
    }

    public SimplePinDialog pin(String pin) {
        if (pin != null) {
            this.length(pin.length());
        }
        return (SimplePinDialog)((Object)this.setArg(CHECK_PIN, pin));
    }

    public SimplePinDialog() {
        this.title(R.string.pin);
        this.pos(null);
    }

    protected String onValidateInput(@Nullable String input) {
        String pin = this.getArguments().getString(CHECK_PIN);
        if (pin != null && !pin.equals(this.getText())) {
            return this.getString(R.string.wrong_pin);
        }
        Bundle extras = this.getExtras();
        if (this.getTargetFragment() instanceof SimpleInputDialog.InputValidator) {
            return ((SimpleInputDialog.InputValidator)this.getTargetFragment()).validate(this.getTag(), input, extras);
        }
        if (this.getActivity() instanceof SimpleInputDialog.InputValidator) {
            return ((SimpleInputDialog.InputValidator)this.getActivity()).validate(this.getTag(), input, extras);
        }
        return null;
    }

    @Nullable
    public String getText() {
        return this.mInput.getText() != null ? this.mInput.getText().toString() : null;
    }

    public void openKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput((View)this.mInput, 1);
        }
    }

    @Override
    public View onCreateContentView(Bundle savedInstanceState) {
        View view = this.inflate(R.layout.simpledialogfragment_pin);
        this.mInput = (PinEntryEditText)view.findViewById(R.id.pinEntry);
        this.mInputLayout = (TextInputLayout)view.findViewById(R.id.inputLayout);
        this.mInput.setMaxLength(this.getArguments().getInt(LENGTH, 4));
        if (savedInstanceState != null) {
            this.mInput.setText((CharSequence)savedInstanceState.getString(PIN));
        }
        this.mInput.setImeOptions(6);
        this.mInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    if (SimplePinDialog.this.posEnabled()) {
                        SimplePinDialog.this.pressPositiveButton();
                    }
                    return true;
                }
                return false;
            }
        });
        this.mInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SimplePinDialog.this.mInputLayout.setErrorEnabled(false);
                SimplePinDialog.this.setPositiveButtonEnabled(SimplePinDialog.this.posEnabled());
            }
        });
        this.mInput.setOnPinEnteredListener(new PinEntryEditText.OnPinEnteredListener(){

            public void onPinEntered(CharSequence str) {
                SimplePinDialog.this.pressPositiveButton();
            }
        });
        return view;
    }

    protected boolean posEnabled() {
        return this.getText() != null && this.getText().length() == this.getArguments().getInt(LENGTH, 4);
    }

    @Override
    protected void onDialogShown() {
        this.setPositiveButtonEnabled(this.posEnabled());
        this.mInput.requestFocus();
        this.openKeyboard();
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        String input = this.getText();
        String error = this.onValidateInput(input);
        if (error == null) {
            return true;
        }
        this.mInputLayout.setError((CharSequence)error);
        this.mInputLayout.setErrorEnabled(true);
        return false;
    }

    @Override
    public Bundle onResult(int which) {
        Bundle result = new Bundle();
        result.putString(PIN, this.getText());
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(PIN, this.getText());
    }
}

