/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.color.ColorView;
import eltos.simpledialogfragment.color.SimpleColorWheelDialog;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;

public class SimpleColorDialog
extends CustomListDialog<SimpleColorDialog>
implements SimpleDialog.OnDialogResultListener {
    public static final String TAG = "SimpleColorDialog.";
    public static final String COLOR = "SimpleColorDialog.color";
    public static final String COLORS = "SimpleColorDialog.colors";
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET = R.array.material_pallet;
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET_LIGHT = R.array.material_pallet_light;
    @ArrayRes
    public static final int MATERIAL_COLOR_PALLET_DARK = R.array.material_pallet_dark;
    @ArrayRes
    public static final int BEIGE_COLOR_PALLET = R.array.beige_pallet;
    @ArrayRes
    public static final int COLORFUL_COLOR_PALLET = R.array.colorful_pallet;
    public static final int NONE = 0;
    public static final int AUTO = 0xFFFFFF;
    @ColorInt
    public static final int[] DEFAULT_COLORS = new int[]{-769226, -1499549, -6543440, -10011977, -12627531, -14575885, -16537100, -16728876, -16738680, -11751600, -7617718, -3285959, -5317, -16121, -26624, -43230, -8825528, -6381922, -10453621};
    protected static final int PICKER = 12245589;
    protected static final String PICKER_DIALOG_TAG = "SimpleColorDialog.picker";
    protected static final String CUSTOM = "SimpleColorDialog.custom";
    protected static final String CUSTOM_ALPHA = "SimpleColorDialog.custom_alpha";
    protected static final String CUSTOM_HIDE_HEX = "SimpleColorDialog.custom_hide_hex";
    protected static final String CUSTOM_TITLE = "SimpleColorDialog.custom_title";
    protected static final String CUSTOM_POS = "SimpleColorDialog.custom_pos";
    protected static final String CUSTOM_NEUT = "SimpleColorDialog.custom_neut";
    private static final String SELECTED = "SimpleColorDialog.selected";
    private static final String OUTLINE = "SimpleColorDialog.outline";
    @ColorInt
    private int mCustomColor = 0;
    @ColorInt
    private int mSelectedColor = 0;

    public static SimpleColorDialog build() {
        return new SimpleColorDialog();
    }

    public SimpleColorDialog colors(@ColorInt int[] colors) {
        this.getArguments().putIntArray(COLORS, colors);
        return this;
    }

    public SimpleColorDialog colors(Context context, @ArrayRes int colorArrayRes) {
        return this.colors(context.getResources().getIntArray(colorArrayRes));
    }

    public SimpleColorDialog colorPreset(@ColorInt int color2) {
        this.getArguments().putInt(COLOR, color2);
        return this;
    }

    public SimpleColorDialog allowCustom(boolean allow) {
        return (SimpleColorDialog)this.setArg(CUSTOM, allow);
    }

    public SimpleColorDialog setupColorWheelAlpha(boolean alpha) {
        return (SimpleColorDialog)this.setArg(CUSTOM_ALPHA, alpha);
    }

    public SimpleColorDialog setupColorWheelHideHex(boolean hideHex) {
        return (SimpleColorDialog)this.setArg(CUSTOM_HIDE_HEX, hideHex);
    }

    public SimpleColorDialog setupColorWheelTitle(String text) {
        return (SimpleColorDialog)this.setArg(CUSTOM_TITLE, text);
    }

    public SimpleColorDialog setupColorWheelPosButton(String text) {
        return (SimpleColorDialog)this.setArg(CUSTOM_POS, text);
    }

    public SimpleColorDialog setupColorWheelNeutButton(String text) {
        return (SimpleColorDialog)this.setArg(CUSTOM_NEUT, text);
    }

    public SimpleColorDialog showOutline(@ColorInt int color2) {
        return (SimpleColorDialog)this.setArg(OUTLINE, color2);
    }

    public SimpleColorDialog() {
        this.grid();
        this.gridColumnWidth(R.dimen.dialog_color_item_size);
        this.choiceMode(1);
        this.choiceMin(1);
        this.colors(DEFAULT_COLORS);
        this.setArg(CUSTOM_POS, 17039370);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mCustomColor = savedInstanceState.getInt(CUSTOM, this.mCustomColor);
            this.mSelectedColor = savedInstanceState.getInt(SELECTED, this.mCustomColor);
        }
    }

    @Override
    protected AdvancedAdapter onCreateAdapter() {
        int[] colors = this.getArguments().getIntArray(COLORS);
        if (colors == null) {
            colors = new int[]{};
        }
        boolean custom = this.getArguments().getBoolean(CUSTOM);
        if (this.mSelectedColor == 0 && this.getArguments().containsKey(COLOR)) {
            int preset = this.getArguments().getInt(COLOR, 0);
            int index = this.indexOf(colors, preset);
            if (index < 0) {
                this.mSelectedColor = this.mCustomColor = preset;
                if (custom) {
                    this.choicePreset(colors.length);
                }
            } else {
                this.choicePreset(index);
                this.mSelectedColor = preset;
            }
        }
        this.getListView().setSelector((Drawable)new ColorDrawable(0));
        return new ColorAdapter(colors, custom);
    }

    private int indexOf(int[] array2, int item) {
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(CUSTOM, this.mCustomColor);
        outState.putInt(SELECTED, this.mSelectedColor);
        super.onSaveInstanceState(outState);
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        if (this.getArguments().getInt("CustomListDialogchoiceMode") == 11) {
            return this.mSelectedColor != 0;
        }
        return true;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (id2 == 12245589L) {
            SimpleColorWheelDialog dialog = ((SimpleColorWheelDialog)((Object)((SimpleColorWheelDialog)((Object)((SimpleColorWheelDialog)((Object)((SimpleColorWheelDialog)((Object)SimpleColorWheelDialog.build().theme(this.getTheme()))).title(this.getArgString(CUSTOM_TITLE)))).pos(this.getArgString(CUSTOM_POS)))).neut(this.getArgString(CUSTOM_NEUT)))).alpha(this.getArguments().getBoolean(CUSTOM_ALPHA)).hideHexInput(this.getArguments().getBoolean(CUSTOM_HIDE_HEX));
            if (this.mCustomColor != 0) {
                dialog.color(this.mCustomColor);
            } else if (this.mSelectedColor != 0) {
                dialog.color(this.mSelectedColor);
                this.mCustomColor = this.mSelectedColor;
            }
            dialog.show((Fragment)this, PICKER_DIALOG_TAG);
            this.mSelectedColor = 0;
        } else {
            this.mSelectedColor = (int)id2;
        }
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        if (PICKER_DIALOG_TAG.equals(dialogTag) && which == -1) {
            this.mSelectedColor = this.mCustomColor = extras.getInt("SimpleColorWheelDialog.color");
            this.notifyDataSetChanged();
            if (this.getArguments().getInt("CustomListDialogchoiceMode") == 11) {
                this.pressPositiveButton();
            }
            return true;
        }
        return false;
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle b = super.onResult(which);
        int color2 = (int)b.getLong("CustomListDialogselectedSingleId");
        if (color2 == 12245589) {
            b.putInt(COLOR, this.mCustomColor);
        } else {
            b.putInt(COLOR, color2);
        }
        long[] ids = b.getLongArray("CustomListDialogselectedIds");
        if (ids != null) {
            int[] colors = new int[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                colors[i] = ids[i] == 12245589L ? this.mCustomColor : (int)ids[i];
            }
            b.putIntArray(COLORS, colors);
        }
        return b;
    }

    protected class ColorAdapter
    extends AdvancedAdapter<Integer> {
        public ColorAdapter(int[] colors, boolean addCustomField) {
            if (colors == null) {
                colors = new int[]{};
            }
            Integer[] cs = new Integer[colors.length + (addCustomField ? 1 : 0)];
            for (int i = 0; i < colors.length; ++i) {
                cs[i] = colors[i];
            }
            if (addCustomField) {
                cs[cs.length - 1] = 12245589;
            }
            this.setData(cs, new AdvancedAdapter.ItemIdentifier<Integer>(){

                @Override
                @Nullable
                public Long getIdForItem(Integer color2) {
                    return (long)color2;
                }
            });
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ColorView item = convertView instanceof ColorView ? (ColorView)convertView : new ColorView(SimpleColorDialog.this.getContext());
            int color2 = (Integer)this.getItem(position);
            if (color2 == 12245589) {
                item.setColor(SimpleColorDialog.this.mCustomColor);
                item.setStyle(ColorView.Style.PALETTE);
            } else {
                item.setColor((Integer)this.getItem(position));
                item.setStyle(ColorView.Style.CHECK);
            }
            int outline = SimpleColorDialog.this.getArguments().getInt(SimpleColorDialog.OUTLINE, 0);
            if (outline != 0) {
                float width = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)SimpleColorDialog.this.getResources().getDisplayMetrics());
                item.setOutlineWidth((int)width);
                item.setOutlineColor(outline);
            }
            return super.getView(position, (View)item, parent);
        }
    }
}

