/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.app.Dialog;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import java.lang.ref.WeakReference;

public class SimpleImageDialog
extends CustomViewDialog<SimpleImageDialog> {
    public static final String TAG = "SimpleImageDialog.";
    protected static final String DRAWABLE_RESOURCE = "SimpleImageDialog.drawableRes";
    protected static final String BITMAP = "SimpleImageDialog.bitmap";
    protected static final String IMAGE_URI = "SimpleImageDialog.uri";
    protected static final String SCALE_TYPE = "SimpleImageDialog.scale";
    private static final String CREATOR_CLASS = "SimpleImageDialog.creatorClass";
    private boolean customTheme = false;

    public static SimpleImageDialog build() {
        return new SimpleImageDialog();
    }

    public SimpleImageDialog image(@DrawableRes int resourceId) {
        return (SimpleImageDialog)((Object)this.setArg(DRAWABLE_RESOURCE, resourceId));
    }

    @Deprecated
    public SimpleImageDialog image(Bitmap image) {
        this.getArguments().putParcelable(BITMAP, (Parcelable)image);
        return this;
    }

    public SimpleImageDialog image(Class<? extends Creator> builderClass) {
        this.getArguments().putSerializable(CREATOR_CLASS, builderClass);
        return this;
    }

    public SimpleImageDialog image(Uri imageUri) {
        this.getArguments().putParcelable(IMAGE_URI, (Parcelable)imageUri);
        return this;
    }

    public SimpleImageDialog scaleType(Scale scale) {
        return (SimpleImageDialog)((Object)this.setArg(SCALE_TYPE, scale.nativeInt));
    }

    public SimpleImageDialog() {
        this.pos(null);
    }

    @Override
    public SimpleImageDialog theme(@StyleRes int theme) {
        this.customTheme = true;
        return (SimpleImageDialog)((Object)super.theme(theme));
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (!this.customTheme) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(R.attr.imageDialogTheme, outValue, true);
            if (outValue.type == 1) {
                this.theme(outValue.resourceId);
            } else {
                this.theme(R.style.ImageDialogTheme);
            }
        }
        return super.onCreateDialog(savedInstanceState);
    }

    @Override
    protected View onCreateContentView(Bundle savedInstanceState) {
        View view;
        int scale = this.getArguments().getInt(SCALE_TYPE, Scale.FIT.nativeInt);
        if (scale == Scale.FIT.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image);
        } else if (scale == Scale.SCROLL_VERTICAL.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image_vert_scroll);
        } else if (scale == Scale.SCROLL_HORIZONTAL.nativeInt) {
            view = this.inflate(R.layout.simpledialogfragment_image_hor_scroll);
        } else {
            return null;
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.image);
        ProgressBar loading = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.getArguments().containsKey(IMAGE_URI)) {
            imageView.setImageURI((Uri)this.getArguments().getParcelable(IMAGE_URI));
        } else if (this.getArguments().containsKey(DRAWABLE_RESOURCE)) {
            imageView.setImageResource(this.getArguments().getInt(DRAWABLE_RESOURCE));
        } else if (this.getArguments().containsKey(CREATOR_CLASS)) {
            Bundle args = this.getArguments();
            args.putString(TAG, this.getTag());
            new ImageCreator(imageView, (View)loading).execute(new Bundle[]{args});
        } else if (this.getArguments().containsKey(BITMAP)) {
            imageView.setImageBitmap((Bitmap)this.getArguments().getParcelable(BITMAP));
        }
        return view;
    }

    public static enum Scale {
        FIT(3),
        SCROLL_HORIZONTAL(10),
        SCROLL_VERTICAL(11);

        final int nativeInt;

        private Scale(int ni) {
            this.nativeInt = ni;
        }
    }

    private static class ImageCreator
    extends AsyncTask<Bundle, Void, Object> {
        WeakReference<ImageView> mView;
        WeakReference<View> mLoading;

        ImageCreator(ImageView view, View loading) {
            this.mView = new WeakReference<ImageView>(view);
            this.mLoading = new WeakReference<View>(loading);
        }

        protected void onPreExecute() {
            ((ImageView)this.mView.get()).setVisibility(8);
            ((View)this.mLoading.get()).setVisibility(0);
            super.onPreExecute();
        }

        protected Object doInBackground(Bundle ... args) {
            if (args.length == 0 || args[0] == null) {
                return null;
            }
            Class c = (Class)args[0].getSerializable(SimpleImageDialog.CREATOR_CLASS);
            if (c != null) {
                try {
                    Bundle extras = args[0].getBundle("SimpleDialog.bundle");
                    if (extras == null) {
                        extras = new Bundle();
                    }
                    String tag = args[0].getString(SimpleImageDialog.TAG);
                    Creator builder = (Creator)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return builder.create(tag, extras);
                }
                catch (Exception e) {
                    Log.e((String)SimpleImageDialog.TAG, (String)("Error: Instantiation of " + c.getName() + " failed. Make sure the class is public and has a public default constructor. Also, nested classes should be static"), (Throwable)e);
                }
            }
            return null;
        }

        protected void onPostExecute(Object image) {
            if (image != null) {
                if (image instanceof Bitmap) {
                    ((ImageView)this.mView.get()).setImageBitmap((Bitmap)image);
                } else if (image instanceof Drawable) {
                    ((ImageView)this.mView.get()).setImageDrawable((Drawable)image);
                } else if (Build.VERSION.SDK_INT >= 23 && image instanceof Icon) {
                    ((ImageView)this.mView.get()).setImageIcon((Icon)image);
                }
            }
            ((ImageView)this.mView.get()).setVisibility(0);
            ((View)this.mLoading.get()).setVisibility(8);
            super.onPostExecute(image);
        }
    }

    public static interface IconCreator
    extends Creator<Icon> {
    }

    public static interface DrawableCreator
    extends Creator<Drawable> {
    }

    public static interface BitmapCreator
    extends Creator<Bitmap> {
    }

    private static interface Creator<T> {
        public T create(@Nullable String var1, @NonNull Bundle var2);
    }
}

