/*
 * Decompiled with CFR 0.152.
 */
package eltos.lintchecks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

public class DialogExtendLintDetector
extends Detector
implements Detector.UastScanner {
    private static String BUILD_OVERWRITE_MESSAGE = "Class extends SimpleDialog but does not implement a static `build` method.";
    public static final Issue BUILD_OVERWRITE = Issue.create((String)"BuildOverwrite", (String)"Missing build method", (String)"This check checks for classes that extend a `SimpleDialog` but do not implement a static `build` method.\n\nImplementing the method is required, as a call to the inherited build method would otherwise unintentionally create an instance of the parent class.\n", (Category)Category.USABILITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(DialogExtendLintDetector.class, Scope.JAVA_FILE_SCOPE));
    private static String TAG_MESSAGE = "Class extends SimpleDialog but does not have a `public static String TAG` field.";
    public static final Issue TAG = Issue.create((String)"DialogTag", (String)"Missing TAG field", (String)"This check checks for classes that extend a `SimpleDialog` but do not have a public static String `TAG` field.\n\nThis field is required, as it is used as default identifier for resultreceiving. If not given, the parent classes TAG would unintentionally be used.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(DialogExtendLintDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("eltos.simpledialogfragment.SimpleDialog");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        PsiModifierList classModifiers = declaration.getModifierList();
        if (classModifiers == null || !classModifiers.hasModifierProperty("abstract")) {
            boolean hasBuildMethod = false;
            for (UMethod method : declaration.getMethods()) {
                if (!"build".equals(method.getName()) || !method.getModifierList().hasModifierProperty("static")) continue;
                hasBuildMethod = true;
                break;
            }
            if (!hasBuildMethod) {
                context.report(BUILD_OVERWRITE, context.getLocation((PsiElement)declaration.getExtendsList()), BUILD_OVERWRITE_MESSAGE);
            }
            boolean hasTag = false;
            for (UField field : declaration.getFields()) {
                PsiModifierList modifiers = field.getModifierList();
                if (!"TAG".equals(field.getName()) || !LintUtils.isString((PsiType)field.getType()) || modifiers == null || !modifiers.hasModifierProperty("public") || !modifiers.hasModifierProperty("static")) continue;
                hasTag = true;
                break;
            }
            if (!hasTag) {
                context.report(TAG, context.getLocation((PsiElement)declaration.getExtendsList()), TAG_MESSAGE);
            }
        }
    }
}

