/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.form.Check;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.SimpleFormDialog;

class CheckViewHolder
extends FormElementViewHolder<Check> {
    protected static final String SAVED_CHECK_STATE = "checked";
    private CheckBox checkBox;

    public CheckViewHolder(Check field) {
        super(field);
    }

    @Override
    protected int getContentViewLayout() {
        return R.layout.simpledialogfragment_form_item_check;
    }

    @Override
    protected void setUpView(View view, Context context, Bundle savedInstanceState, final SimpleFormDialog.DialogActions actions) {
        this.checkBox = (CheckBox)view.findViewById(R.id.checkBox);
        this.checkBox.setText((CharSequence)((Check)this.field).getText(context));
        if (savedInstanceState != null) {
            this.checkBox.setChecked(savedInstanceState.getBoolean(SAVED_CHECK_STATE));
        } else {
            this.checkBox.setChecked(((Check)this.field).getInitialState(context));
        }
        if (actions.isOnlyFocusableElement()) {
            this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    actions.updatePosButtonState();
                }
            });
        }
    }

    @Override
    protected void saveState(Bundle outState) {
        outState.putBoolean(SAVED_CHECK_STATE, this.checkBox.isChecked());
    }

    @Override
    protected void putResults(Bundle results, String key) {
        results.putBoolean(key, this.checkBox.isChecked());
    }

    @Override
    protected boolean focus(final SimpleFormDialog.FocusActions actions) {
        actions.hideKeyboard();
        this.checkBox.setFocusableInTouchMode(true);
        this.checkBox.postDelayed(new Runnable(){

            @Override
            public void run() {
                CheckViewHolder.this.checkBox.setFocusable(false);
                actions.clearCurrentFocus();
            }
        }, 100L);
        return this.checkBox.requestFocus();
    }

    @Override
    protected boolean posButtonEnabled(Context context) {
        return !((Check)this.field).required || this.checkBox.isChecked();
    }

    @Override
    protected boolean validate(Context context) {
        boolean valid = this.posButtonEnabled(context);
        if (valid) {
            TypedValue value = new TypedValue();
            this.checkBox.getContext().getTheme().resolveAttribute(16842860, value, true);
            int[] attr2 = new int[]{16842904};
            TypedArray a = context.obtainStyledAttributes(value.data, attr2);
            this.checkBox.setTextColor(a.getColor(0, -16777216));
            a.recycle();
        } else {
            this.checkBox.setTextColor(context.getResources().getColor(R.color.simpledialogfragment_error_color));
        }
        return valid;
    }
}

