/*
 * Decompiled with CFR 0.152.
 */
package eltos.lintchecks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class DialogMethodCallLintDetector
extends Detector
implements Detector.UastScanner {
    private static String BUILD_CALL_MESSAGE = "%1$s does not implement a `build` method. A **%2$s will be created**\nImplement the method in %1$s or call `%2$s.build()` instead.";
    public static final Issue BUILD_CALL = Issue.create((String)"BuildNotImplemented", (String)"Calling not implemented build", (String)"This check checks for calls to static build methods on classes extending `SimpleDialog` that do not implement the build method itself.\n\nThis will create an instance of the superclass instead of the intended dialog.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(DialogMethodCallLintDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("build");
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        if (context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "eltos.simpledialogfragment.SimpleDialog", false)) {
            PsiClass definingClass = method.getContainingClass();
            UExpression callingExpression = node.getReceiver();
            if (definingClass != null && callingExpression != null) {
                PsiType type = TypeEvaluator.evaluate((UElement)callingExpression);
                if (type instanceof PsiClassType) {
                    PsiClass callingClass = ((PsiClassType)type).resolve();
                    if (callingClass != null && !Objects.equals(callingClass, definingClass)) {
                        context.report(BUILD_CALL, context.getLocation((UElement)node), String.format(BUILD_CALL_MESSAGE, callingClass.getName(), definingClass.getName()));
                    }
                } else if (!Objects.equals(definingClass.getName(), callingExpression.toString())) {
                    context.report(BUILD_CALL, context.getLocation((UElement)node), String.format(BUILD_CALL_MESSAGE, callingExpression, definingClass.getName()));
                }
            }
        }
    }
}

