/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.Html;

public class SimpleDialog<This extends SimpleDialog<This>>
extends DialogFragment {
    protected static final String TITLE = "simpleDialog.title";
    protected static final String MESSAGE = "simpleDialog.message";
    protected static final String POSITIVE_BUTTON_TEXT = "simpleDialog.positiveButtonText";
    protected static final String NEGATIVE_BUTTON_TEXT = "simpleDialog.negativeButtonText";
    protected static final String NEUTRAL_BUTTON_TEXT = "simpleDialog.neutralButtonText";
    protected static final String ICON_RESOURCE = "simpleDialog.iconResource";
    protected static final String CANCELABLE = "simpleDialog.cancelable";
    protected static final String THEME = "simpleDialog.theme";
    protected static final String HTML = "simpleDialog.html";
    protected static final String BUNDLE = "simpleDialog.bundle";
    private DialogInterface.OnClickListener forwardOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            SimpleDialog.this.callResultListener(which, null);
        }
    };
    private AlertDialog dialog;
    private Context context;

    @CallSuper
    protected boolean callResultListener(int which, Bundle extras) {
        if (extras == null) {
            extras = new Bundle();
        }
        if (this.getArguments().getBundle(BUNDLE) != null) {
            extras.putAll(this.getArguments().getBundle(BUNDLE));
        }
        boolean handled = false;
        if (this.getTag() != null) {
            if (this.getTargetFragment() instanceof OnDialogResultListener) {
                handled = ((OnDialogResultListener)this.getTargetFragment()).onResult(this.getTag(), which, extras);
            }
            if (!handled && this.getActivity() instanceof OnDialogResultListener) {
                handled = ((OnDialogResultListener)this.getActivity()).onResult(this.getTag(), which, extras);
            }
        }
        return handled;
    }

    public SimpleDialog() {
        Bundle args = this.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        this.setArguments(args);
        this.pos(17039370);
    }

    public static SimpleDialog build() {
        return new SimpleDialog();
    }

    protected final This setArg(String key, boolean value) {
        this.getArguments().putBoolean(key, value);
        return (This)((Object)this);
    }

    protected final This setArg(String key, String value) {
        this.getArguments().putString(key, value);
        return (This)((Object)this);
    }

    protected final This setArg(String key, int value) {
        this.getArguments().putInt(key, value);
        return (This)((Object)this);
    }

    protected final This setArg(String key, long value) {
        this.getArguments().putLong(key, value);
        return (This)((Object)this);
    }

    @Nullable
    protected final String getArgString(String key) {
        Object value = this.getArguments().get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return this.getString((Integer)value);
        }
        return null;
    }

    public This title(String title) {
        return this.setArg(TITLE, title);
    }

    public This title(@StringRes int titleResourceId) {
        return this.setArg(TITLE, titleResourceId);
    }

    public This msg(String message) {
        return this.setArg(MESSAGE, message);
    }

    public This msg(@StringRes int messageResourceId) {
        return this.setArg(MESSAGE, messageResourceId);
    }

    public This msgHtml(String message) {
        this.setArg(HTML, true);
        return this.setArg(MESSAGE, message);
    }

    public This msgHtml(@StringRes int messageResourceId) {
        this.setArg(HTML, true);
        return this.setArg(MESSAGE, messageResourceId);
    }

    public This pos(String positiveButton) {
        return this.setArg(POSITIVE_BUTTON_TEXT, positiveButton);
    }

    public This pos(@StringRes int positiveButtonResourceId) {
        return this.setArg(POSITIVE_BUTTON_TEXT, positiveButtonResourceId);
    }

    public This neg(String negativeButton) {
        return this.setArg(NEGATIVE_BUTTON_TEXT, negativeButton);
    }

    public This neg(@StringRes int negativeButtonResourceId) {
        return this.setArg(NEGATIVE_BUTTON_TEXT, negativeButtonResourceId);
    }

    public This neg() {
        return this.neg(17039369);
    }

    public This neut(String neutralButton) {
        return this.setArg(NEUTRAL_BUTTON_TEXT, neutralButton);
    }

    public This neut(@StringRes int neutralButtonResourceId) {
        return this.setArg(NEUTRAL_BUTTON_TEXT, neutralButtonResourceId);
    }

    public This neut() {
        return this.neut(0x1040000);
    }

    public This icon(@DrawableRes int iconResourceId) {
        return this.setArg(ICON_RESOURCE, iconResourceId);
    }

    public This cancelable(boolean cancelable) {
        return this.setArg(CANCELABLE, cancelable);
    }

    public This extra(Bundle extras) {
        this.getArguments().putBundle(BUNDLE, extras);
        return (This)((Object)this);
    }

    public This theme(@StyleRes int theme) {
        return this.setArg(THEME, theme);
    }

    public void show(Fragment fragment) {
        this.show(fragment, null);
    }

    public void show(Fragment fragment, String tag) {
        this.setTargetFragment(fragment, -1);
        try {
            super.show(fragment.getFragmentManager(), tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void show(AppCompatActivity activity) {
        this.show(activity, null);
    }

    public void show(AppCompatActivity activity, String tag) {
        try {
            super.show(activity.getSupportFragmentManager(), tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @CallSuper
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.setCancelable(this.getArguments().getBoolean(CANCELABLE, true));
    }

    public Context getContext() {
        return this.context != null ? this.context : super.getContext();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String neutralButtonText;
        String negativeButtonText;
        String positiveButtonText;
        if (this.getArguments().containsKey(THEME)) {
            this.dialog = new AlertDialog.Builder(this.getContext(), this.getArguments().getInt(THEME)).create();
            this.setStyle(0, this.getArguments().getInt(THEME));
        } else {
            this.dialog = new AlertDialog.Builder(this.getContext()).create();
        }
        this.context = this.dialog.getContext();
        this.dialog.setTitle((CharSequence)this.getArgString(TITLE));
        String msg = this.getArgString(MESSAGE);
        if (msg != null) {
            if (this.getArguments().getBoolean(HTML)) {
                if (Build.VERSION.SDK_INT >= 24) {
                    this.dialog.setMessage((CharSequence)Html.fromHtml((String)msg, (int)0));
                } else {
                    this.dialog.setMessage((CharSequence)Html.fromHtml((String)msg));
                }
            } else {
                this.dialog.setMessage((CharSequence)msg);
            }
        }
        if ((positiveButtonText = this.getArgString(POSITIVE_BUTTON_TEXT)) != null) {
            this.dialog.setButton(-1, (CharSequence)positiveButtonText, this.forwardOnClickListener);
        }
        if ((negativeButtonText = this.getArgString(NEGATIVE_BUTTON_TEXT)) != null) {
            this.dialog.setButton(-2, (CharSequence)negativeButtonText, this.forwardOnClickListener);
        }
        if ((neutralButtonText = this.getArgString(NEUTRAL_BUTTON_TEXT)) != null) {
            this.dialog.setButton(-3, (CharSequence)neutralButtonText, this.forwardOnClickListener);
        }
        if (this.getArguments().containsKey(ICON_RESOURCE)) {
            this.dialog.setIcon(this.getArguments().getInt(ICON_RESOURCE));
        }
        this.dialog.setCancelable(this.getArguments().getBoolean(CANCELABLE, true));
        return this.dialog;
    }

    @Deprecated
    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Deprecated
    public int show(FragmentTransaction transaction, String tag) {
        try {
            return super.show(transaction, tag);
        }
        catch (IllegalStateException ignored) {
            return -1;
        }
    }

    @CallSuper
    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.callResultListener(0, null);
    }

    @CallSuper
    public void onDestroyView() {
        if (this.dialog != null && this.getRetainInstance()) {
            this.dialog.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    public static interface OnDialogResultListener {
        public static final int CANCELED = 0;
        public static final int BUTTON_POSITIVE = -1;
        public static final int BUTTON_NEGATIVE = -2;
        public static final int BUTTON_NEUTRAL = -3;

        public boolean onResult(@NonNull String var1, int var2, @NonNull Bundle var3);
    }
}

