/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.input;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.TextInputLayout;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import android.widget.TextView;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;

public class SimpleInputDialog
extends CustomViewDialog<SimpleInputDialog> {
    private static final String TAG = "simpleInputDialog";
    public static final String TEXT = "simpleInputDialogtext";
    private static final String HINT = "simpleInputDialoghint";
    private static final String INPUT_TYPE = "simpleInputDialoginput_type";
    private static final String ALLOW_EMPTY = "simpleInputDialogallow_empty";
    private static final String MAX_LENGTH = "simpleInputDialogmax_length";
    private static final String SUGGESTIONS = "simpleInputDialogsuggestions";
    private AutoCompleteTextView mInput;
    private TextInputLayout mInputLayout;

    public static SimpleInputDialog build() {
        return new SimpleInputDialog();
    }

    public SimpleInputDialog hint(String hint) {
        return (SimpleInputDialog)((Object)this.setArg(HINT, hint));
    }

    public SimpleInputDialog hint(@StringRes int hintResourceId) {
        return (SimpleInputDialog)((Object)this.setArg(HINT, hintResourceId));
    }

    public SimpleInputDialog text(String text) {
        return (SimpleInputDialog)((Object)this.setArg(TEXT, text));
    }

    public SimpleInputDialog text(@StringRes int textResourceId) {
        return (SimpleInputDialog)((Object)this.setArg(TEXT, textResourceId));
    }

    public SimpleInputDialog inputType(int inputType) {
        return (SimpleInputDialog)((Object)this.setArg(INPUT_TYPE, inputType));
    }

    public SimpleInputDialog allowEmpty(boolean allow) {
        return (SimpleInputDialog)((Object)this.setArg(ALLOW_EMPTY, allow));
    }

    public SimpleInputDialog max(int maxLength) {
        return (SimpleInputDialog)((Object)this.setArg(MAX_LENGTH, maxLength));
    }

    public SimpleInputDialog suggest(Context context, int[] stringResourceIds) {
        String[] strings = new String[stringResourceIds.length];
        for (int i = 0; i < stringResourceIds.length; ++i) {
            strings[i] = context.getString(stringResourceIds[i]);
        }
        return this.suggest(strings);
    }

    public SimpleInputDialog suggest(String[] strings) {
        this.getArguments().putStringArray(SUGGESTIONS, strings);
        return this;
    }

    protected String onValidateInput(@Nullable String input) {
        Bundle extras = this.getArguments().getBundle("simpleDialog.bundle");
        if (extras == null) {
            extras = new Bundle();
        }
        if (this.getTargetFragment() instanceof InputValidator) {
            return ((InputValidator)this.getTargetFragment()).validate(this.getTag(), input, extras);
        }
        if (this.getActivity() instanceof InputValidator) {
            return ((InputValidator)this.getActivity()).validate(this.getTag(), input, extras);
        }
        return null;
    }

    @Nullable
    public String getText() {
        return this.mInput.getText() != null ? this.mInput.getText().toString() : null;
    }

    public boolean isInputEmpty() {
        return this.getText() == null || this.getText().trim().isEmpty();
    }

    public void openKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.showSoftInput((View)this.mInput, 1);
    }

    @Override
    public View onCreateContentView(Bundle savedInstanceState) {
        View view = this.inflate(R.layout.dialog_input);
        this.mInput = (AutoCompleteTextView)view.findViewById(R.id.editText);
        this.mInputLayout = (TextInputLayout)view.findViewById(R.id.inputLayout);
        this.mInput.setInputType(this.getArguments().getInt(INPUT_TYPE, 1));
        if ((this.getArguments().getInt(INPUT_TYPE) & 0xF) == 3) {
            this.mInput.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
        }
        this.mInputLayout.setHint((CharSequence)this.getArgString(HINT));
        if (this.getArguments().getInt(MAX_LENGTH) > 0) {
            this.mInputLayout.setCounterMaxLength(this.getArguments().getInt(MAX_LENGTH));
            this.mInputLayout.setCounterEnabled(true);
        }
        if (savedInstanceState != null) {
            this.mInput.setText((CharSequence)savedInstanceState.getString(TEXT));
        } else {
            this.mInput.setText((CharSequence)this.getArgString(TEXT));
            this.mInput.setSelection(0, this.mInput.length());
        }
        this.mInput.setImeOptions(6);
        this.mInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    SimpleInputDialog.this.pressPositiveButton();
                    return true;
                }
                return false;
            }
        });
        this.mInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SimpleInputDialog.this.setPositiveButtonEnabled(SimpleInputDialog.this.posEnabled());
            }
        });
        Object[] suggestionList = this.getArguments().getStringArray(SUGGESTIONS);
        if (suggestionList != null) {
            ArrayAdapter adapter = new ArrayAdapter(this.getContext(), 17367043, suggestionList);
            this.mInput.setAdapter((ListAdapter)adapter);
            this.mInput.setThreshold(1);
        }
        return view;
    }

    private boolean posEnabled() {
        return !(this.isInputEmpty() && !this.getArguments().getBoolean(ALLOW_EMPTY) || this.getText() != null && this.getText().length() > this.getArguments().getInt(MAX_LENGTH, this.getText().length()));
    }

    @Override
    protected void onDialogShown() {
        this.setPositiveButtonEnabled(this.posEnabled());
        this.openKeyboard();
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        String input = this.getText();
        String error = this.onValidateInput(input);
        if (error == null) {
            return true;
        }
        this.mInputLayout.setError((CharSequence)error);
        this.mInputLayout.setErrorEnabled(true);
        return false;
    }

    @Override
    public Bundle onResult(int which) {
        Bundle result = new Bundle();
        result.putString(TEXT, this.getText());
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(TEXT, this.getText());
    }

    public static interface InputValidator {
        public String validate(String var1, @Nullable String var2, @NonNull Bundle var3);
    }
}

