/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.form;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import eltos.simpledialogfragment.CustomViewDialog;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.form.FormElement;
import eltos.simpledialogfragment.form.FormElementViewHolder;
import eltos.simpledialogfragment.form.Input;
import eltos.simpledialogfragment.form.InputViewHolder;
import java.util.ArrayList;
import java.util.Collections;

public class SimpleFormDialog
extends CustomViewDialog<SimpleFormDialog> {
    private static final String TAG = "SimpleFormDialog";
    private static final String INPUT_FIELDS = "SimpleFormDialoginputFields";
    private static final String SAVE_TAG = "form.";
    private FocusActions mFocusActions = new FocusActions();
    ArrayList<FormElementViewHolder<?>> mViews = new ArrayList(0);
    ViewGroup mFormContainer;

    public static SimpleFormDialog build() {
        return new SimpleFormDialog();
    }

    public static SimpleFormDialog buildEmailInput(String emailFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.email(emailFieldKey).required()});
    }

    public static SimpleFormDialog buildPasswordInput(String passwordFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.password(passwordFieldKey).required()});
    }

    public static SimpleFormDialog buildNumberInput(String numberFieldKey) {
        return SimpleFormDialog.build().fields(new FormElement[]{Input.phone(numberFieldKey).required()});
    }

    public static SimpleFormDialog buildLoginEmail(String emailFieldKey, String passwordFieldKey) {
        return ((SimpleFormDialog)((Object)((SimpleFormDialog)((Object)SimpleFormDialog.build().title(R.string.login))).pos(R.string.login))).fields(new FormElement[]{Input.email(emailFieldKey).required(), Input.password(passwordFieldKey).required()});
    }

    public static SimpleFormDialog buildLogin(String userFieldKey, String passwordFieldKey) {
        return ((SimpleFormDialog)((Object)((SimpleFormDialog)((Object)SimpleFormDialog.build().title(R.string.login))).pos(R.string.login))).fields(new FormElement[]{Input.plain(userFieldKey).hint(R.string.user).required(), Input.password(passwordFieldKey).required()});
    }

    public SimpleFormDialog fields(FormElement ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        this.getArguments().putParcelableArrayList(INPUT_FIELDS, list);
        return this;
    }

    private String onValidateInput(String fieldKey, @Nullable String input) {
        Bundle extras = this.getArguments().getBundle("simpleDialog.bundle");
        if (extras == null) {
            extras = new Bundle();
        }
        if (this.getTargetFragment() instanceof InputValidator) {
            return ((InputValidator)this.getTargetFragment()).validate(this.getTag(), fieldKey, input, extras);
        }
        if (this.getActivity() instanceof InputValidator) {
            return ((InputValidator)this.getActivity()).validate(this.getTag(), fieldKey, input, extras);
        }
        return null;
    }

    @Override
    protected void onDialogShown() {
        if (this.getDialog().getWindow() != null) {
            this.getDialog().getWindow().setSoftInputMode(16);
        }
        this.setPositiveButtonEnabled(this.posButtonEnabled());
        this.requestFocus(0);
    }

    @Override
    protected boolean acceptsPositiveButtonPress() {
        boolean okay = true;
        for (FormElementViewHolder<?> holder : this.mViews) {
            String error;
            if (!holder.validate(this.getContext())) {
                if (okay) {
                    holder.focus(this.mFocusActions);
                }
                okay = false;
                continue;
            }
            if (!(holder instanceof InputViewHolder) || (error = this.onValidateInput(((FormElement)holder.field).resultKey, ((InputViewHolder)holder).getText())) == null) continue;
            ((InputViewHolder)holder).setError(true, error);
            if (okay) {
                holder.focus(this.mFocusActions);
            }
            okay = false;
        }
        return okay;
    }

    private boolean posButtonEnabled() {
        return this.mViews.size() != 1 || this.mViews.get(0).posButtonEnabled(this.getContext());
    }

    private void requestFocus(int viewIndex) {
        if (viewIndex < this.mViews.size() && viewIndex >= 0) {
            this.mViews.get(viewIndex).focus(this.mFocusActions);
        }
    }

    @Override
    public View onCreateContentView(Bundle savedInstanceState) {
        View view = this.inflate(R.layout.dialog_form);
        this.mFormContainer = (ViewGroup)view.findViewById(R.id.container);
        ArrayList fields = this.getArguments().getParcelableArrayList(INPUT_FIELDS);
        if (fields != null) {
            this.mViews = new ArrayList(fields.size());
            int lastI = fields.size() - 1;
            for (int i = 0; i <= lastI; ++i) {
                Object viewHolder = ((FormElement)fields.get(i)).getViewHolder();
                View child = this.inflate(((FormElementViewHolder)viewHolder).getContentViewLayout(), this.mFormContainer, false);
                Bundle savedState = savedInstanceState == null ? null : savedInstanceState.getBundle(SAVE_TAG + i);
                ((FormElementViewHolder)viewHolder).setUpView(child, this.getContext(), savedState, new DialogActions(i, lastI), i == lastI, lastI == 0);
                this.mFormContainer.addView(child);
                this.mViews.add((FormElementViewHolder<?>)viewHolder);
            }
        }
        return view;
    }

    @Override
    public Bundle onResult(int which) {
        Bundle result = new Bundle();
        for (FormElementViewHolder<?> holder : this.mViews) {
            holder.putResults(result, ((FormElement)holder.field).resultKey);
        }
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        for (int i = 0; i < this.mViews.size(); ++i) {
            Bundle viewState = new Bundle();
            this.mViews.get(i).saveState(viewState);
            outState.putBundle(SAVE_TAG + i, viewState);
        }
        super.onSaveInstanceState(outState);
    }

    public class DialogActions {
        private int index;
        private int lastIndex;

        private DialogActions(int index, int lastIndex) {
            this.index = index;
            this.lastIndex = lastIndex;
        }

        public void updatePosButtonState() {
            SimpleFormDialog.this.setPositiveButtonEnabled(SimpleFormDialog.this.posButtonEnabled());
        }

        public void continueWithNextElement() {
            if (this.index == this.lastIndex) {
                SimpleFormDialog.this.pressPositiveButton();
            } else {
                SimpleFormDialog.this.requestFocus(this.index + 1);
            }
        }
    }

    public class FocusActions {
        public void hideKeyboard() {
            View view = SimpleFormDialog.this.getDialog().getCurrentFocus();
            if (view != null) {
                InputMethodManager imm = (InputMethodManager)SimpleFormDialog.this.getContext().getSystemService("input_method");
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }

        public void clearCurrentFocus() {
            SimpleFormDialog.this.mFormContainer.requestFocus();
        }
    }

    public static interface InputValidator {
        public String validate(String var1, String var2, @Nullable String var3, @NonNull Bundle var4);
    }
}

