/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;

public class SimpleDialog<This extends SimpleDialog<This>>
extends DialogFragment {
    private static final String TITLE = "simpleDialog.title";
    private static final String MESSAGE = "simpleDialog.message";
    private static final String POSITIVE_BUTTON_TEXT = "simpleDialog.positiveButtonText";
    private static final String NEGATIVE_BUTTON_TEXT = "simpleDialog.negativeButtonText";
    private static final String NEUTRAL_BUTTON_TEXT = "simpleDialog.neutralButtonText";
    private static final String ICON_RESOURCE = "simpleDialog.iconResource";
    private static final String CANCELABLE = "simpleDialog.cancelable";
    private static final String THEME = "simpleDialog.theme";
    protected static final String BUNDLE = "simpleDialog.bundle";
    private DialogInterface.OnClickListener forwardOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            SimpleDialog.this.callResultListener(which, null);
        }
    };
    private AlertDialog dialog;

    boolean callResultListener(int which, Bundle extras) {
        if (extras == null) {
            extras = new Bundle();
        }
        if (this.getArguments().getBundle(BUNDLE) != null) {
            extras.putAll(this.getArguments().getBundle(BUNDLE));
        }
        boolean handled = false;
        if (this.getTag() != null) {
            if (this.getTargetFragment() instanceof OnDialogResultListener) {
                handled = ((OnDialogResultListener)this.getTargetFragment()).onResult(this.getTag(), which, extras);
            }
            if (!handled && this.getActivity() instanceof OnDialogResultListener) {
                handled = ((OnDialogResultListener)this.getActivity()).onResult(this.getTag(), which, extras);
            }
        }
        return handled;
    }

    public SimpleDialog() {
        Bundle args = this.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        this.setArguments(args);
        this.pos(17039370);
    }

    public static SimpleDialog build() {
        return new SimpleDialog();
    }

    protected This setArg(String key, boolean value) {
        this.getArguments().putBoolean(key, value);
        return (This)((Object)this);
    }

    protected This setArg(String key, String value) {
        this.getArguments().putString(key, value);
        return (This)((Object)this);
    }

    protected This setArg(String key, int value) {
        this.getArguments().putInt(key, value);
        return (This)((Object)this);
    }

    protected String getArgString(String key) {
        Object value = this.getArguments().get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return this.getString((Integer)value);
        }
        return null;
    }

    public This title(String title) {
        return this.setArg(TITLE, title);
    }

    public This title(int titleResourceId) {
        return this.setArg(TITLE, titleResourceId);
    }

    public This msg(String message) {
        return this.setArg(MESSAGE, message);
    }

    public This msg(int messageResourceId) {
        return this.setArg(MESSAGE, messageResourceId);
    }

    public This pos(String positiveButton) {
        return this.setArg(POSITIVE_BUTTON_TEXT, positiveButton);
    }

    public This pos(int positiveButtonResourceId) {
        return this.setArg(POSITIVE_BUTTON_TEXT, positiveButtonResourceId);
    }

    public This neg(String negativeButton) {
        return this.setArg(NEGATIVE_BUTTON_TEXT, negativeButton);
    }

    public This neg(int negativeButtonResourceId) {
        return this.setArg(NEGATIVE_BUTTON_TEXT, negativeButtonResourceId);
    }

    public This neg() {
        return this.neg(17039369);
    }

    public This neut(String neutralButton) {
        return this.setArg(NEUTRAL_BUTTON_TEXT, neutralButton);
    }

    public This neut(int neutralButtonResourceId) {
        return this.setArg(NEUTRAL_BUTTON_TEXT, neutralButtonResourceId);
    }

    public This neut() {
        return this.neut(0x1040000);
    }

    public This icon(int iconResourceId) {
        return this.setArg(ICON_RESOURCE, iconResourceId);
    }

    public This cancelable(boolean cancelable) {
        return this.setArg(CANCELABLE, cancelable);
    }

    public This extra(Bundle extras) {
        this.getArguments().putBundle(BUNDLE, extras);
        return (This)((Object)this);
    }

    public This theme(int theme) {
        return this.setArg(THEME, theme);
    }

    public void show(Fragment fragment) {
        this.show(fragment, null);
    }

    public void show(Fragment fragment, String tag) {
        this.setTargetFragment(fragment, -1);
        try {
            super.show(fragment.getFragmentManager(), tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void show(AppCompatActivity activity) {
        this.show(activity, null);
    }

    public void show(AppCompatActivity activity, String tag) {
        try {
            super.show(activity.getSupportFragmentManager(), tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.setCancelable(this.getArguments().getBoolean(CANCELABLE, true));
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int iconResourceId;
        String neutralButtonText;
        String negativeButtonText;
        int theme = this.getArguments().getInt(THEME, -1);
        this.dialog = theme < 0 ? new AlertDialog.Builder((Context)this.getActivity()).create() : new AlertDialog.Builder((Context)this.getActivity(), theme).create();
        this.dialog.setTitle((CharSequence)this.getArgString(TITLE));
        this.dialog.setMessage((CharSequence)this.getArgString(MESSAGE));
        String positiveButtonText = this.getArgString(POSITIVE_BUTTON_TEXT);
        if (positiveButtonText != null) {
            this.dialog.setButton(-1, (CharSequence)positiveButtonText, this.forwardOnClickListener);
        }
        if ((negativeButtonText = this.getArgString(NEGATIVE_BUTTON_TEXT)) != null) {
            this.dialog.setButton(-2, (CharSequence)negativeButtonText, this.forwardOnClickListener);
        }
        if ((neutralButtonText = this.getArgString(NEUTRAL_BUTTON_TEXT)) != null) {
            this.dialog.setButton(-3, (CharSequence)neutralButtonText, this.forwardOnClickListener);
        }
        if ((iconResourceId = this.getArguments().getInt(ICON_RESOURCE)) != 0) {
            this.dialog.setIcon(iconResourceId);
        }
        this.dialog.setCancelable(this.getArguments().getBoolean(CANCELABLE, true));
        return this.dialog;
    }

    @Deprecated
    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Deprecated
    public int show(FragmentTransaction transaction, String tag) {
        try {
            return super.show(transaction, tag);
        }
        catch (IllegalStateException ignored) {
            return -1;
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.callResultListener(0, null);
    }

    public void onDestroyView() {
        if (this.dialog != null && this.getRetainInstance()) {
            this.dialog.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    public static interface OnDialogResultListener {
        public static final int CANCELED = 0;
        public static final int BUTTON_POSITIVE = -1;
        public static final int BUTTON_NEGATIVE = -2;
        public static final int BUTTON_NEUTRAL = -3;

        public boolean onResult(@NonNull String var1, int var2, @NonNull Bundle var3);
    }
}

