/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.ISpan;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

public abstract class SpanImplBase
implements ISpan {
    private Node implementation;
    private HtmlNotesContentImpl owner;

    public SpanImplBase(Node implementation, HtmlNotesContentImpl owner) {
        this.implementation = implementation;
        this.owner = owner;
    }

    public String getStyleType() {
        return "text";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SpanImplBase)) {
            return false;
        }
        SpanImplBase that = (SpanImplBase)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return this.implementation.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class && this.implementation instanceof Element) {
            return this.implementation;
        }
        return null;
    }

    public Node getImplementation() {
        return this.implementation;
    }

    protected void setImplementation(Node implementation) {
        this.owner.getAdaptableRegistry().unregister((IAdaptable)this, this.implementation);
        this.implementation = implementation;
        this.owner.getAdaptableRegistry().register((IAdaptable)this, this.implementation);
    }

    public HtmlNotesContentImpl getOwner() {
        return this.owner;
    }

    public String getStyleId() {
        if (this.implementation instanceof Element) {
            return DOMUtils.getAttribute((Element)this.implementation, "style-id");
        }
        return null;
    }

    public void setStyleId(String styleId) {
        if (this.implementation instanceof Element) {
            WorkbookImpl workbook = this.owner.getRealizedWorkbook();
            WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
            DOMUtils.setAttribute((Element)this.implementation, "style-id", styleId);
            WorkbookUtilsImpl.increaseStyleRef(workbook, this);
            this.getOwner().updateModifiedTime();
        }
    }

    public IWorkbook getOwnedWorkbook() {
        return this.owner.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    protected void addNotify(WorkbookImpl workbook) {
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
    }

    protected void removeNotify(WorkbookImpl workbook) {
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
    }
}

