/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.ele.uetool.R;
import me.ele.uetool.base.DimenUtil;

public class UETSubMenu
extends LinearLayout {
    private final int padding = DimenUtil.dip2px((float)5.0f);
    private ImageView vImage;
    private TextView vTitle;

    public UETSubMenu(Context context) {
        this(context, null);
    }

    public UETSubMenu(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UETSubMenu(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        UETSubMenu.inflate((Context)context, (int)R.layout.uet_sub_menu_layout, (ViewGroup)this);
        this.setGravity(17);
        this.setOrientation(1);
        this.setPadding(this.padding, 0, this.padding, 0);
        this.setTranslationY(DimenUtil.dip2px((float)2.0f));
        this.vImage = (ImageView)this.findViewById(R.id.image);
        this.vTitle = (TextView)this.findViewById(R.id.title);
    }

    public void update(SubMenu subMenu) {
        this.vImage.setImageResource(subMenu.getImageRes());
        this.vTitle.setText((CharSequence)subMenu.getTitle());
        this.setOnClickListener(subMenu.getOnClickListener());
    }

    public static class SubMenu {
        private String title;
        private int imageRes;
        private View.OnClickListener onClickListener;

        public SubMenu(String title, int imageRes, View.OnClickListener onClickListener) {
            this.title = title;
            this.imageRes = imageRes;
            this.onClickListener = onClickListener;
        }

        public String getTitle() {
            return this.title;
        }

        public int getImageRes() {
            return this.imageRes;
        }

        public View.OnClickListener getOnClickListener() {
            return this.onClickListener;
        }
    }
}

