/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Activity;
import android.graphics.Bitmap;
import android.util.Pair;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.ele.uetool.FragmentListTreeDialog;
import me.ele.uetool.TransparentActivity;
import me.ele.uetool.Util;
import me.ele.uetool.base.DimenUtil;
import me.ele.uetool.base.Element;
import me.ele.uetool.base.IAttrs;
import me.ele.uetool.base.item.AddMinusEditItem;
import me.ele.uetool.base.item.BitmapItem;
import me.ele.uetool.base.item.EditTextItem;
import me.ele.uetool.base.item.Item;
import me.ele.uetool.base.item.SwitchItem;
import me.ele.uetool.base.item.TextItem;
import me.ele.uetool.base.item.TitleItem;

public class UETCore
implements IAttrs {
    public List<Item> getAttrs(Element element) {
        ArrayList<Item> items = new ArrayList<Item>();
        View view = element.getView();
        items.add((Item)new TextItem("Fragment", Util.getCurrentFragmentName(element.getView()), new View.OnClickListener(){

            public void onClick(View v) {
                Activity activity = Util.getCurrentActivity();
                if (activity instanceof TransparentActivity) {
                    ((TransparentActivity)activity).dismissAttrsDialog();
                }
                new FragmentListTreeDialog(v.getContext()).show();
            }
        }));
        items.add((Item)new TextItem("ViewHolder", Util.getViewHolderName(element.getView())));
        items.add((Item)new SwitchItem("Move", element, 2));
        items.add((Item)new SwitchItem("ValidViews", element, 3));
        IAttrs iAttrs = AttrsManager.createAttrs(view);
        if (iAttrs != null) {
            items.addAll(iAttrs.getAttrs(element));
        }
        items.add((Item)new TitleItem("COMMON"));
        items.add((Item)new TextItem("Class", view.getClass().getName()));
        items.add((Item)new TextItem("Id", Util.getResId(view)));
        items.add((Item)new TextItem("ResName", Util.getResourceName(view.getId())));
        items.add((Item)new TextItem("Tag", Util.getViewTag(view)));
        items.add((Item)new TextItem("Clickable", Boolean.toString(view.isClickable()).toUpperCase()));
        items.add((Item)new TextItem("OnClickListener", Util.getViewClickListener(view)));
        items.add((Item)new TextItem("Focused", Boolean.toString(view.isFocused()).toUpperCase()));
        items.add((Item)new AddMinusEditItem("Width\uff08dp\uff09", element, 4, DimenUtil.px2dip((float)view.getWidth())));
        items.add((Item)new AddMinusEditItem("Height\uff08dp\uff09", element, 5, DimenUtil.px2dip((float)view.getHeight())));
        items.add((Item)new TextItem("Alpha", String.valueOf(view.getAlpha())));
        Object background = Util.getBackground(view);
        if (background instanceof String) {
            items.add((Item)new TextItem("Background", (String)background));
        } else if (background instanceof Bitmap) {
            items.add((Item)new BitmapItem("Background", (Bitmap)background));
        }
        items.add((Item)new AddMinusEditItem("PaddingLeft\uff08dp\uff09", element, 6, DimenUtil.px2dip((float)view.getPaddingLeft())));
        items.add((Item)new AddMinusEditItem("PaddingRight\uff08dp\uff09", element, 7, DimenUtil.px2dip((float)view.getPaddingRight())));
        items.add((Item)new AddMinusEditItem("PaddingTop\uff08dp\uff09", element, 8, DimenUtil.px2dip((float)view.getPaddingTop())));
        items.add((Item)new AddMinusEditItem("PaddingBottom\uff08dp\uff09", element, 9, DimenUtil.px2dip((float)view.getPaddingBottom())));
        return items;
    }

    static class UETImageView
    implements IAttrs {
        UETImageView() {
        }

        public List<Item> getAttrs(Element element) {
            ArrayList<Item> items = new ArrayList<Item>();
            ImageView imageView = (ImageView)element.getView();
            items.add((Item)new TitleItem("ImageView"));
            items.add((Item)new BitmapItem("Bitmap", Util.getImageViewBitmap(imageView)));
            items.add((Item)new TextItem("ScaleType", Util.getImageViewScaleType(imageView)));
            return items;
        }
    }

    static class UETTextView
    implements IAttrs {
        UETTextView() {
        }

        public List<Item> getAttrs(Element element) {
            ArrayList<Item> items = new ArrayList<Item>();
            TextView textView = (TextView)element.getView();
            items.add((Item)new TitleItem("TextView"));
            items.add((Item)new EditTextItem("Text", element, 1, textView.getText().toString()));
            items.add((Item)new AddMinusEditItem("TextSize\uff08sp\uff09", element, 2, DimenUtil.px2sp((float)textView.getTextSize())));
            items.add((Item)new EditTextItem("TextColor", element, 3, Util.intToHexColor(textView.getCurrentTextColor())));
            List<Pair<String, Bitmap>> pairs = Util.getTextViewBitmap(textView);
            for (Pair<String, Bitmap> pair : pairs) {
                items.add((Item)new BitmapItem((String)pair.first, (Bitmap)pair.second));
            }
            items.add((Item)new SwitchItem("IsBold", element, 1, textView.getTypeface() != null ? textView.getTypeface().isBold() : false));
            return items;
        }
    }

    static class AttrsManager {
        AttrsManager() {
        }

        public static IAttrs createAttrs(View view) {
            if (view instanceof TextView) {
                return new UETTextView();
            }
            if (view instanceof ImageView) {
                return new UETImageView();
            }
            return null;
        }
    }
}

