/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import me.ele.uetool.CollectViewsLayout;
import me.ele.uetool.base.DimenUtil;
import me.ele.uetool.base.Element;

public class RelativePositionLayout
extends CollectViewsLayout {
    private final int elementsNum = 2;
    private Paint areaPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-65536);
            this.setStyle(Paint.Style.STROKE);
            this.setStrokeWidth(DimenUtil.dip2px((float)1.0f));
        }
    };
    private Element[] relativeElements = new Element[2];
    private int searchCount = 0;

    public RelativePositionLayout(Context context) {
        this(context, null);
    }

    public RelativePositionLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RelativePositionLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 1: {
                Element element = this.getTargetElement(event.getX(), event.getY());
                if (element == null) break;
                this.relativeElements[this.searchCount % 2] = element;
                ++this.searchCount;
                this.invalidate();
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.relativeElements == null) {
            return;
        }
        boolean doubleNotNull = true;
        for (Element element : this.relativeElements) {
            if (element != null) {
                Rect rect = element.getRect();
                canvas.drawLine(0.0f, (float)rect.top, (float)this.screenWidth, (float)rect.top, this.dashLinePaint);
                canvas.drawLine(0.0f, (float)rect.bottom, (float)this.screenWidth, (float)rect.bottom, this.dashLinePaint);
                canvas.drawLine((float)rect.left, 0.0f, (float)rect.left, (float)this.screenHeight, this.dashLinePaint);
                canvas.drawLine((float)rect.right, 0.0f, (float)rect.right, (float)this.screenHeight, this.dashLinePaint);
                canvas.drawRect(rect, this.areaPaint);
                continue;
            }
            doubleNotNull = false;
        }
        if (doubleNotNull) {
            int y;
            int x;
            Rect firstRect = this.relativeElements[this.searchCount % 2].getRect();
            Rect secondRect = this.relativeElements[(this.searchCount - 1) % 2].getRect();
            if (secondRect.top > firstRect.bottom) {
                x = secondRect.left + secondRect.width() / 2;
                this.drawLineWithText(canvas, x, firstRect.bottom, x, secondRect.top);
            }
            if (firstRect.top > secondRect.bottom) {
                x = secondRect.left + secondRect.width() / 2;
                this.drawLineWithText(canvas, x, secondRect.bottom, x, firstRect.top);
            }
            if (secondRect.left > firstRect.right) {
                y = secondRect.top + secondRect.height() / 2;
                this.drawLineWithText(canvas, secondRect.left, y, firstRect.right, y);
            }
            if (firstRect.left > secondRect.right) {
                y = secondRect.top + secondRect.height() / 2;
                this.drawLineWithText(canvas, secondRect.right, y, firstRect.left, y);
            }
            this.drawNestedAreaLine(canvas, firstRect, secondRect);
            this.drawNestedAreaLine(canvas, secondRect, firstRect);
        }
    }

    private void drawNestedAreaLine(Canvas canvas, Rect firstRect, Rect secondRect) {
        if (secondRect.left >= firstRect.left && secondRect.right <= firstRect.right && secondRect.top >= firstRect.top && secondRect.bottom <= firstRect.bottom) {
            this.drawLineWithText(canvas, secondRect.left, secondRect.top + secondRect.height() / 2, firstRect.left, secondRect.top + secondRect.height() / 2);
            this.drawLineWithText(canvas, secondRect.right, secondRect.top + secondRect.height() / 2, firstRect.right, secondRect.top + secondRect.height() / 2);
            this.drawLineWithText(canvas, secondRect.left + secondRect.width() / 2, secondRect.top, secondRect.left + secondRect.width() / 2, firstRect.top);
            this.drawLineWithText(canvas, secondRect.left + secondRect.width() / 2, secondRect.bottom, secondRect.left + secondRect.width() / 2, firstRect.bottom);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.relativeElements = null;
    }

    @Override
    protected void drawLineWithText(Canvas canvas, int startX, int startY, int endX, int endY) {
        this.drawLineWithText(canvas, startX, startY, endX, endY, DimenUtil.dip2px((float)2.0f));
    }
}

