/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.ele.uetool.R;
import me.ele.uetool.UETool;
import me.ele.uetool.base.DimenUtil;
import me.ele.uetool.base.Element;
import me.ele.uetool.base.ReflectionP;

public class CollectViewsLayout
extends View {
    private final int halfEndPointWidth = DimenUtil.dip2px((float)2.5f);
    private final int textBgFillingSpace = DimenUtil.dip2px((float)2.0f);
    private final int textLineDistance = DimenUtil.dip2px((float)5.0f);
    protected final int screenWidth = DimenUtil.getScreenWidth();
    protected final int screenHeight = DimenUtil.getScreenHeight();
    protected List<Element> elements = new ArrayList<Element>();
    protected Element childElement;
    protected Element parentElement;
    protected Paint textPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setTextSize(DimenUtil.sp2px((float)10.0f));
            this.setColor(-65536);
            this.setStrokeWidth(DimenUtil.dip2px((float)1.0f));
        }
    };
    private Paint textBgPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-1);
            this.setStrokeJoin(Paint.Join.ROUND);
        }
    };
    protected Paint dashLinePaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-1862336512);
            this.setStyle(Paint.Style.STROKE);
            this.setPathEffect((PathEffect)new DashPathEffect(new float[]{DimenUtil.dip2px((float)4.0f), DimenUtil.dip2px((float)8.0f)}, 0.0f));
        }
    };

    public CollectViewsLayout(Context context) {
        super(context);
    }

    public CollectViewsLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CollectViewsLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onAttachedToWindow() {
        block6: {
            super.onAttachedToWindow();
            try {
                final Activity targetActivity = UETool.getInstance().getTargetActivity();
                final WindowManager windowManager = targetActivity.getWindowManager();
                if (Build.VERSION.SDK_INT > 16) {
                    final Field mGlobalField = Class.forName("android.view.WindowManagerImpl").getDeclaredField("mGlobal");
                    mGlobalField.setAccessible(true);
                    if (Build.VERSION.SDK_INT <= 23) {
                        Field mViewsField = Class.forName("android.view.WindowManagerGlobal").getDeclaredField("mViews");
                        mViewsField.setAccessible(true);
                        List<View> views = Build.VERSION.SDK_INT >= 19 ? (List<View>)mViewsField.get(mGlobalField.get(windowManager)) : Arrays.asList((View[])mViewsField.get(mGlobalField.get(windowManager)));
                        for (int i = views.size() - 1; i >= 0; --i) {
                            View targetView = this.getTargetDecorView(targetActivity, views.get(i));
                            if (targetView == null) continue;
                            this.createElements(targetView);
                            break block6;
                        }
                        break block6;
                    }
                    ReflectionP.breakAndroidP((ReflectionP.Func)new ReflectionP.Func<Void>(){

                        public Void call() {
                            try {
                                Field mRootsField = Class.forName("android.view.WindowManagerGlobal").getDeclaredField("mRoots");
                                mRootsField.setAccessible(true);
                                List viewRootImpls = (List)mRootsField.get(mGlobalField.get(windowManager));
                                for (int i = viewRootImpls.size() - 1; i >= 0; --i) {
                                    Class<?> clazz = Class.forName("android.view.ViewRootImpl");
                                    Object object = viewRootImpls.get(i);
                                    WindowManager.LayoutParams layoutParams = null;
                                    try {
                                        Field mWindowAttributesField = clazz.getDeclaredField("mWindowAttributes");
                                        mWindowAttributesField.setAccessible(true);
                                        layoutParams = (WindowManager.LayoutParams)mWindowAttributesField.get(object);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    Field mViewField = clazz.getDeclaredField("mView");
                                    mViewField.setAccessible(true);
                                    View decorView = (View)mViewField.get(object);
                                    if ((layoutParams == null || !layoutParams.getTitle().toString().contains(targetActivity.getClass().getName())) && CollectViewsLayout.this.getTargetDecorView(targetActivity, decorView) == null) continue;
                                    CollectViewsLayout.this.createElements(decorView);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    });
                    break block6;
                }
                Field mWindowManagerField = Class.forName("android.view.WindowManagerImpl$CompatModeWrapper").getDeclaredField("mWindowManager");
                mWindowManagerField.setAccessible(true);
                Field mViewsField = Class.forName("android.view.WindowManagerImpl").getDeclaredField("mViews");
                mViewsField.setAccessible(true);
                List<View> views = Arrays.asList((View[])mViewsField.get(mWindowManagerField.get(windowManager)));
                for (int i = views.size() - 1; i >= 0; --i) {
                    View targetView = this.getTargetDecorView(targetActivity, views.get(i));
                    if (targetView == null) continue;
                    this.createElements(targetView);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.elements.clear();
        this.childElement = null;
        this.parentElement = null;
    }

    private void createElements(View view) {
        ArrayList<Element> elements = new ArrayList<Element>();
        this.traverse(view, elements);
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o2.getArea() - o1.getArea();
            }
        });
        this.elements.addAll(elements);
    }

    private void traverse(View view, List<Element> elements) {
        if (UETool.getInstance().getFilterClasses().contains(view.getClass().getName())) {
            return;
        }
        if (view.getAlpha() == 0.0f || view.getVisibility() != 0) {
            return;
        }
        if (this.getResources().getString(R.string.uet_disable).equals(view.getTag())) {
            return;
        }
        elements.add(new Element(view));
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.traverse(parent.getChildAt(i), elements);
            }
        }
    }

    private View getTargetDecorView(Activity targetActivity, View decorView) {
        if (decorView.getWidth() == 0 || decorView.getHeight() == 0) {
            return null;
        }
        Context context = null;
        if (decorView instanceof ViewGroup && ((ViewGroup)decorView).getChildCount() > 0) {
            context = ((ViewGroup)decorView).getChildAt(0).getContext();
        }
        while (context != null) {
            if (context == targetActivity) {
                return decorView;
            }
            if (context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
                continue;
            }
            return null;
        }
        return null;
    }

    protected Element getTargetElement(float x, float y) {
        Element target = null;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element element = this.elements.get(i);
            if (!element.getRect().contains((int)x, (int)y) || this.isParentNotVisible(element.getParentElement())) continue;
            if (element != this.childElement) {
                this.childElement = element;
                this.parentElement = element;
            } else if (this.parentElement != null) {
                this.parentElement = this.parentElement.getParentElement();
            }
            target = this.parentElement == null ? element : this.parentElement;
            break;
        }
        if (target == null) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.uet_target_element_not_found, new Object[]{Float.valueOf(x), Float.valueOf(y)}), (int)0).show();
        }
        return target;
    }

    private boolean isParentNotVisible(Element parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getRect().left >= DimenUtil.getScreenWidth() || parent.getRect().top >= DimenUtil.getScreenHeight()) {
            return true;
        }
        return this.isParentNotVisible(parent.getParentElement());
    }

    protected List<Element> getTargetElements(float x, float y) {
        ArrayList<Element> validList = new ArrayList<Element>();
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element element = this.elements.get(i);
            if (!element.getRect().contains((int)x, (int)y)) continue;
            validList.add(element);
        }
        return validList;
    }

    protected void drawText(Canvas canvas, String text, float x, float y) {
        float diff;
        float left = x - (float)this.textBgFillingSpace;
        float top = y - this.getTextHeight(text);
        float right = x + this.getTextWidth(text) + (float)this.textBgFillingSpace;
        float bottom = y + (float)this.textBgFillingSpace;
        if (left < 0.0f) {
            right -= left;
            left = 0.0f;
        }
        if (top < 0.0f) {
            bottom -= top;
            top = 0.0f;
        }
        if (bottom > (float)this.screenHeight) {
            diff = top - bottom;
            bottom = this.screenHeight;
            top = bottom + diff;
        }
        if (right > (float)this.screenWidth) {
            diff = left - right;
            right = this.screenWidth;
            left = right + diff;
        }
        canvas.drawRect(left, top, right, bottom, this.textBgPaint);
        canvas.drawText(text, left + (float)this.textBgFillingSpace, bottom - (float)this.textBgFillingSpace, this.textPaint);
    }

    private void drawLineWithEndPoint(Canvas canvas, int startX, int startY, int endX, int endY) {
        canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, this.textPaint);
        if (startX == endX) {
            canvas.drawLine((float)(startX - this.halfEndPointWidth), (float)startY, (float)(endX + this.halfEndPointWidth), (float)startY, this.textPaint);
            canvas.drawLine((float)(startX - this.halfEndPointWidth), (float)endY, (float)(endX + this.halfEndPointWidth), (float)endY, this.textPaint);
        } else if (startY == endY) {
            canvas.drawLine((float)startX, (float)(startY - this.halfEndPointWidth), (float)startX, (float)(endY + this.halfEndPointWidth), this.textPaint);
            canvas.drawLine((float)endX, (float)(startY - this.halfEndPointWidth), (float)endX, (float)(endY + this.halfEndPointWidth), this.textPaint);
        }
    }

    protected void drawLineWithText(Canvas canvas, int startX, int startY, int endX, int endY) {
        this.drawLineWithText(canvas, startX, startY, endX, endY, 0);
    }

    protected void drawLineWithText(Canvas canvas, int startX, int startY, int endX, int endY, int endPointSpace) {
        if (startX == endX && startY == endY) {
            return;
        }
        if (startX > endX) {
            int tempX = startX;
            startX = endX;
            endX = tempX;
        }
        if (startY > endY) {
            int tempY = startY;
            startY = endY;
            endY = tempY;
        }
        if (startX == endX) {
            this.drawLineWithEndPoint(canvas, startX, startY + endPointSpace, endX, endY - endPointSpace);
            String text = DimenUtil.px2dip((float)(endY - startY), (boolean)true);
            this.drawText(canvas, text, startX + this.textLineDistance, (float)(startY + (endY - startY) / 2) + this.getTextHeight(text) / 2.0f);
        } else if (startY == endY) {
            this.drawLineWithEndPoint(canvas, startX + endPointSpace, startY, endX - endPointSpace, endY);
            String text = DimenUtil.px2dip((float)(endX - startX), (boolean)true);
            this.drawText(canvas, text, (float)(startX + (endX - startX) / 2) - this.getTextWidth(text) / 2.0f, startY - this.textLineDistance);
        }
    }

    protected float getTextHeight(String text) {
        Rect rect = new Rect();
        this.textPaint.getTextBounds(text, 0, text.length(), rect);
        return rect.height();
    }

    protected float getTextWidth(String text) {
        return this.textPaint.measureText(text);
    }
}

