/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SwitchCompat;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.ele.uetool.R;
import me.ele.uetool.UETool;
import me.ele.uetool.Util;
import me.ele.uetool.attrdialog.AttrsDialogItemViewBinder;
import me.ele.uetool.attrdialog.AttrsDialogMultiTypePool;
import me.ele.uetool.base.DimenUtil;
import me.ele.uetool.base.Element;
import me.ele.uetool.base.IAttrs;
import me.ele.uetool.base.ItemArrayList;
import me.ele.uetool.base.item.AddMinusEditItem;
import me.ele.uetool.base.item.BitmapItem;
import me.ele.uetool.base.item.BriefDescItem;
import me.ele.uetool.base.item.EditTextItem;
import me.ele.uetool.base.item.Item;
import me.ele.uetool.base.item.SwitchItem;
import me.ele.uetool.base.item.TextItem;
import me.ele.uetool.base.item.TitleItem;

public class AttrsDialog
extends Dialog {
    private RecyclerView vList;
    private Adapter adapter = new Adapter();
    private RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(this.getContext());

    public AttrsDialog(Context context) {
        super(context, R.style.uet_Theme_Holo_Dialog_background_Translucent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.uet_dialog_attrs);
        this.vList = (RecyclerView)this.findViewById(R.id.list);
        this.vList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.vList.setLayoutManager(this.layoutManager);
    }

    public void show(Element element) {
        this.show();
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        dialogWindow.setGravity(51);
        lp.x = element.getRect().left;
        lp.y = element.getRect().bottom;
        lp.width = DimenUtil.getScreenWidth() - DimenUtil.dip2px((float)30.0f);
        lp.height = DimenUtil.getScreenHeight() / 2;
        dialogWindow.setAttributes(lp);
        this.adapter.notifyDataSetChanged(element);
        this.layoutManager.scrollToPosition(0);
    }

    public void notifyValidViewItemInserted(int positionStart, List<Element> validElements, Element targetElement) {
        ArrayList<Item> validItems = new ArrayList<Item>();
        int N = validElements.size();
        for (int i = 0; i < N; ++i) {
            Element element = validElements.get(i);
            validItems.add((Item)new BriefDescItem(element, targetElement.equals((Object)element)));
        }
        this.adapter.notifyValidViewItemInserted(positionStart, validItems);
    }

    public final void notifyItemRangeRemoved(int positionStart) {
        this.adapter.notifyValidViewItemRemoved(positionStart);
    }

    public void setAttrDialogCallback(AttrDialogCallback callback) {
        this.adapter.setAttrDialogCallback(callback);
    }

    public static class Adapter
    extends RecyclerView.Adapter {
        private List<Item> items = new ItemArrayList();
        private List<Item> validItems = new ArrayList<Item>();
        private AttrDialogCallback callback;

        public void setAttrDialogCallback(AttrDialogCallback callback) {
            this.callback = callback;
        }

        public AttrDialogCallback getAttrDialogCallback() {
            return this.callback;
        }

        public void notifyDataSetChanged(Element element) {
            this.items.clear();
            for (String attrsProvider : UETool.getInstance().getAttrsProvider()) {
                try {
                    IAttrs attrs = (IAttrs)Class.forName(attrsProvider).newInstance();
                    this.items.addAll(attrs.getAttrs(element));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.notifyDataSetChanged();
        }

        public void notifyValidViewItemInserted(int positionStart, List<Item> validItems) {
            this.validItems.addAll(validItems);
            this.items.addAll(positionStart, validItems);
            this.notifyItemRangeInserted(positionStart, validItems.size());
        }

        public void notifyValidViewItemRemoved(int positionStart) {
            this.items.removeAll(this.validItems);
            this.notifyItemRangeRemoved(positionStart, this.validItems.size());
        }

        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            AttrsDialogMultiTypePool pool = UETool.getInstance().getAttrsDialogMultiTypePool();
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            return pool.getItemViewBinder(viewType).onCreateViewHolder(inflater, parent, (RecyclerView.Adapter)this);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            AttrsDialogMultiTypePool pool = UETool.getInstance().getAttrsDialogMultiTypePool();
            ((AttrsDialogItemViewBinder)pool.getItemViewBinder(holder.getItemViewType())).onBindViewHolder(holder, this.getItem(position));
        }

        public int getItemViewType(int position) {
            Object item = this.getItem(position);
            AttrsDialogMultiTypePool pool = UETool.getInstance().getAttrsDialogMultiTypePool();
            return pool.getItemType(item);
        }

        public int getItemCount() {
            return this.items.size();
        }

        @Nullable
        protected <T extends Item> T getItem(int adapterPosition) {
            if (adapterPosition < 0 || adapterPosition >= this.items.size()) {
                return null;
            }
            return (T)this.items.get(adapterPosition);
        }

        public static class BriefDescViewHolder
        extends BaseViewHolder<BriefDescItem> {
            private TextView vDesc;

            public BriefDescViewHolder(View itemView, final AttrDialogCallback callback) {
                super(itemView);
                this.vDesc = (TextView)itemView;
                this.vDesc.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (callback != null) {
                            callback.selectView(((BriefDescItem)BriefDescViewHolder.this.item).getElement());
                        }
                    }
                });
            }

            public static BriefDescViewHolder newInstance(ViewGroup parent, AttrDialogCallback callback) {
                return new BriefDescViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_brief_view_desc, parent, false), callback);
            }

            @Override
            public void bindView(BriefDescItem briefDescItem) {
                super.bindView(briefDescItem);
                View view = briefDescItem.getElement().getView();
                StringBuilder sb = new StringBuilder();
                sb.append(view.getClass().getName());
                String resName = Util.getResourceName(view.getId());
                if (!TextUtils.isEmpty((CharSequence)resName)) {
                    sb.append("@").append(resName);
                }
                this.vDesc.setText((CharSequence)sb.toString());
                this.vDesc.setSelected(briefDescItem.isSelected());
            }
        }

        public static class BitmapInfoViewHolder
        extends BaseViewHolder<BitmapItem> {
            private final int imageHeight = DimenUtil.dip2px((float)58.0f);
            private TextView vName;
            private ImageView vImage;
            private TextView vInfo;

            public BitmapInfoViewHolder(View itemView) {
                super(itemView);
                this.vName = (TextView)itemView.findViewById(R.id.name);
                this.vImage = (ImageView)itemView.findViewById(R.id.image);
                this.vInfo = (TextView)itemView.findViewById(R.id.info);
            }

            public static BitmapInfoViewHolder newInstance(ViewGroup parent) {
                return new BitmapInfoViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_bitmap_info, parent, false));
            }

            @Override
            public void bindView(BitmapItem bitmapItem) {
                super.bindView(bitmapItem);
                this.vName.setText((CharSequence)bitmapItem.getName());
                Bitmap bitmap = bitmapItem.getBitmap();
                int height = Math.min(bitmap.getHeight(), this.imageHeight);
                int width = (int)((float)height / (float)bitmap.getHeight() * (float)bitmap.getWidth());
                ViewGroup.LayoutParams layoutParams = this.vImage.getLayoutParams();
                layoutParams.width = width;
                layoutParams.height = height;
                this.vImage.setImageBitmap(bitmap);
                this.vInfo.setText((CharSequence)(bitmap.getWidth() + "px*" + bitmap.getHeight() + "px"));
            }
        }

        public static class SwitchViewHolder
        extends BaseViewHolder<SwitchItem> {
            private TextView vName;
            private SwitchCompat vSwitch;

            public SwitchViewHolder(View itemView, final AttrDialogCallback callback) {
                super(itemView);
                this.vName = (TextView)itemView.findViewById(R.id.name);
                this.vSwitch = (SwitchCompat)itemView.findViewById(R.id.switch_view);
                this.vSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        try {
                            if (((SwitchItem)SwitchViewHolder.this.item).getType() == 2) {
                                if (callback != null && isChecked) {
                                    callback.enableMove();
                                }
                                return;
                            }
                            if (((SwitchItem)SwitchViewHolder.this.item).getType() == 3) {
                                ((SwitchItem)SwitchViewHolder.this.item).setChecked(isChecked);
                                if (callback != null) {
                                    callback.showValidViews(SwitchViewHolder.this.getAdapterPosition(), isChecked);
                                }
                                return;
                            }
                            if (((SwitchItem)SwitchViewHolder.this.item).getElement().getView() instanceof TextView) {
                                TextView textView = (TextView)((SwitchItem)SwitchViewHolder.this.item).getElement().getView();
                                if (((SwitchItem)SwitchViewHolder.this.item).getType() == 1) {
                                    Typeface tf = Typeface.create((Typeface)textView.getTypeface(), (int)(isChecked ? 1 : 0));
                                    textView.setTypeface(tf);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public static SwitchViewHolder newInstance(ViewGroup parent, AttrDialogCallback callback) {
                return new SwitchViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_switch, parent, false), callback);
            }

            @Override
            public void bindView(SwitchItem switchItem) {
                super.bindView(switchItem);
                this.vName.setText((CharSequence)switchItem.getName());
                this.vSwitch.setChecked(switchItem.isChecked());
            }
        }

        public static class AddMinusEditViewHolder
        extends EditTextViewHolder<AddMinusEditItem> {
            private View vAdd;
            private View vMinus;

            public AddMinusEditViewHolder(View itemView) {
                super(itemView);
                this.vAdd = itemView.findViewById(R.id.add);
                this.vMinus = itemView.findViewById(R.id.minus);
                this.vAdd.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            int textSize = Integer.valueOf(AddMinusEditViewHolder.this.vDetail.getText().toString());
                            AddMinusEditViewHolder.this.vDetail.setText((CharSequence)String.valueOf(++textSize));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                this.vMinus.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            int textSize = Integer.valueOf(AddMinusEditViewHolder.this.vDetail.getText().toString());
                            if (textSize > 0) {
                                AddMinusEditViewHolder.this.vDetail.setText((CharSequence)String.valueOf(--textSize));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public static AddMinusEditViewHolder newInstance(ViewGroup parent) {
                return new AddMinusEditViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_add_minus_edit, parent, false));
            }

            @Override
            public void bindView(AddMinusEditItem editTextItem) {
                super.bindView(editTextItem);
            }
        }

        public static class EditTextViewHolder<T extends EditTextItem>
        extends BaseViewHolder<T> {
            protected TextView vName;
            protected EditText vDetail;
            @Nullable
            private View vColor;
            protected TextWatcher textWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    try {
                        if (((EditTextItem)EditTextViewHolder.this.item).getType() == 1) {
                            TextView textView = (TextView)((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            if (!TextUtils.equals((CharSequence)textView.getText().toString(), (CharSequence)s.toString())) {
                                textView.setText((CharSequence)s.toString());
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 2) {
                            TextView textView = (TextView)((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            float textSize = Float.valueOf(s.toString()).floatValue();
                            if (textView.getTextSize() != textSize) {
                                textView.setTextSize(textSize);
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 3) {
                            TextView textView = (TextView)((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int color = Color.parseColor((String)EditTextViewHolder.this.vDetail.getText().toString());
                            if (color != textView.getCurrentTextColor()) {
                                EditTextViewHolder.this.vColor.setBackgroundColor(color);
                                textView.setTextColor(color);
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 4) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int width = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(width - view.getWidth()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.getLayoutParams().width = width;
                                view.requestLayout();
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 5) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int height = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(height - view.getHeight()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.getLayoutParams().height = height;
                                view.requestLayout();
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 6) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int paddingLeft = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(paddingLeft - view.getPaddingLeft()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.setPadding(paddingLeft, view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 7) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int paddingRight = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(paddingRight - view.getPaddingRight()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), paddingRight, view.getPaddingBottom());
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 8) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int paddingTop = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(paddingTop - view.getPaddingTop()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.setPadding(view.getPaddingLeft(), paddingTop, view.getPaddingRight(), view.getPaddingBottom());
                            }
                        } else if (((EditTextItem)EditTextViewHolder.this.item).getType() == 9) {
                            View view = ((EditTextItem)EditTextViewHolder.this.item).getElement().getView();
                            int paddingBottom = DimenUtil.dip2px((float)Integer.valueOf(s.toString()).intValue());
                            if (Math.abs(paddingBottom - view.getPaddingBottom()) >= DimenUtil.dip2px((float)1.0f)) {
                                view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), paddingBottom);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void afterTextChanged(Editable s) {
                }
            };

            public EditTextViewHolder(View itemView) {
                super(itemView);
                this.vName = (TextView)itemView.findViewById(R.id.name);
                this.vDetail = (EditText)itemView.findViewById(R.id.detail);
                this.vColor = itemView.findViewById(R.id.color);
                this.vDetail.addTextChangedListener(this.textWatcher);
            }

            public static EditTextViewHolder newInstance(ViewGroup parent) {
                return new EditTextViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_edit_text, parent, false));
            }

            @Override
            public void bindView(T editTextItem) {
                super.bindView(editTextItem);
                this.vName.setText((CharSequence)editTextItem.getName());
                this.vDetail.setText((CharSequence)editTextItem.getDetail());
                if (this.vColor != null) {
                    try {
                        this.vColor.setBackgroundColor(Color.parseColor((String)editTextItem.getDetail()));
                        this.vColor.setVisibility(0);
                    }
                    catch (Exception e) {
                        this.vColor.setVisibility(8);
                    }
                }
            }
        }

        public static class TextViewHolder
        extends BaseViewHolder<TextItem> {
            private TextView vName;
            private TextView vDetail;

            public TextViewHolder(View itemView) {
                super(itemView);
                this.vName = (TextView)itemView.findViewById(R.id.name);
                this.vDetail = (TextView)itemView.findViewById(R.id.detail);
            }

            public static TextViewHolder newInstance(ViewGroup parent) {
                return new TextViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_text, parent, false));
            }

            @Override
            public void bindView(TextItem textItem) {
                super.bindView(textItem);
                this.vName.setText((CharSequence)textItem.getName());
                final String detail = textItem.getDetail();
                if (textItem.getOnClickListener() != null) {
                    this.vDetail.setText((CharSequence)Html.fromHtml((String)("<u>" + detail + "</u>")));
                    this.vDetail.setOnClickListener(textItem.getOnClickListener());
                } else {
                    this.vDetail.setText((CharSequence)detail);
                    if (textItem.isEnableCopy()) {
                        this.vDetail.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Util.clipText(detail);
                            }
                        });
                    }
                }
            }
        }

        public static class TitleViewHolder
        extends BaseViewHolder<TitleItem> {
            private TextView vTitle;

            public TitleViewHolder(View itemView) {
                super(itemView);
                this.vTitle = (TextView)itemView.findViewById(R.id.title);
            }

            public static TitleViewHolder newInstance(ViewGroup parent) {
                return new TitleViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uet_cell_title, parent, false));
            }

            @Override
            public void bindView(TitleItem titleItem) {
                super.bindView(titleItem);
                this.vTitle.setText((CharSequence)titleItem.getName());
            }
        }

        public static abstract class BaseViewHolder<T extends Item>
        extends RecyclerView.ViewHolder {
            protected T item;

            public BaseViewHolder(View itemView) {
                super(itemView);
            }

            public void bindView(T t) {
                this.item = t;
            }
        }
    }

    public static interface AttrDialogCallback {
        public void enableMove();

        public void showValidViews(int var1, boolean var2);

        public void selectView(Element var1);
    }
}

